/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunConfigurationsServiceViewContributor;
import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final ExtensionPointName<RunDashboardCustomizer> EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardCustomizer");
    private static final float DEFAULT_CONTENT_PROPORTION = 0.3f;
    @NonNls
    private static final String HELP_ID = "run-dashboard.reference";
    private final Project myProject;
    private final ContentManager myContentManager;
    private final ContentManagerListener myContentManagerListener;
    private State myState;
    private volatile List<List<RunDashboardServiceImpl>> myServices;
    private final ReentrantReadWriteLock myServiceLock;
    private final List<RunDashboardGrouper> myGroupers;
    private final Condition<Content> myReuseCondition;
    private final AtomicBoolean myListenersInitialized;
    private boolean myShowConfigurations;
    private RunDashboardContent myDashboardContent;
    private Content myToolWindowContent;
    private ContentManager myToolWindowContentManager;
    private ContentManagerListener myToolWindowContentManagerListener;
    private final Map<Content, Content> myDashboardToToolWindowContents;

    public RunDashboardManagerImpl(@NotNull Project project) {
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myServices = Collections.emptyList();
        this.myServiceLock = new ReentrantReadWriteLock();
        this.myListenersInitialized = new AtomicBoolean();
        this.myShowConfigurations = true;
        this.myDashboardToToolWindowContents = new HashMap<Content, Content>();
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        this.myContentManager = contentFactory.createContentManager((ContentUI)new PanelContentUI(), false, project);
        this.myContentManagerListener = new DashboardContentManagerListener();
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myReuseCondition = this::canReuseContent;
        this.myGroupers = ContainerUtil.map((Object[])RunDashboardGroupingRule.EP_NAME.getExtensions(), RunDashboardGrouper::new);
    }

    private void initToolWindowContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            @Override
            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.syncConfigurations();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (handler2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void configurationChanged(@NotNull RunConfiguration configuration, boolean withStructure) {
                if (configuration == null) {
                    3.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(configuration, withStructure);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/dashboard/RunDashboardManagerImpl$3", "configurationChanged"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                boolean onAdd = event.getOperation() == ContentManagerEvent.ContentOperation.add;
                Content content2 = event.getContent();
                if (onAdd) {
                    RunDashboardManagerImpl.updateContentToolbar(content2, false);
                    RunDashboardManagerImpl.this.updateServiceContent(content2);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboard(true);
                if (Registry.is((String)"ide.service.view") && onAdd) {
                    RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
                    Set<RunnerAndConfigurationSettings> settingsSet = ExecutionManagerImpl.getInstance(RunDashboardManagerImpl.this.myProject).getConfigurations(descriptor2);
                    RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem(settingsSet);
                    if (settings != null) {
                        RunDashboardServiceImpl service = new RunDashboardServiceImpl(settings);
                        service.setContent(content2);
                        RunConfigurationNode node = new RunConfigurationNode(RunDashboardManagerImpl.this.myProject, service, RunDashboardManagerImpl.this.getCustomizers(settings, descriptor2));
                        ServiceViewManager.getInstance((Project)RunDashboardManagerImpl.this.myProject).select((Object)node, RunConfigurationsServiceViewContributor.class, true, false);
                    }
                }
            }

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                RunDashboardManagerImpl.this.addServiceContent(event.getContent());
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (RunDashboardManagerImpl.this.myContentManager.getContentCount() == 0 && !RunDashboardManagerImpl.this.isShowConfigurations()) {
                    RunDashboardManagerImpl.this.setShowConfigurations(true);
                }
                RunDashboardManagerImpl.this.removeServiceContent(event.getContent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return Registry.is((String)"ide.service.view") ? ToolWindowId.SERVICES : ToolWindowId.RUN_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return Registry.is((String)"ide.service.view") ? AllIcons.Toolwindows.ToolWindowServices : AllIcons.Toolwindows.ToolWindowRun;
    }

    public String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    public boolean isToolWindowAvailable() {
        return this.hasContent();
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(1);
        }
        this.myDashboardContent = new RunDashboardContent(this.myProject, this.myContentManager, this.myGroupers);
        this.myToolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, null, false);
        this.myToolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myToolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContent.setCloseable(false);
        Disposer.register((Disposable)this.myToolWindowContent, (Disposable)this.myDashboardContent);
        Disposer.register((Disposable)this.myToolWindowContent, () -> {
            this.myDashboardContent = null;
            this.myToolWindowContent = null;
            this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
            this.myToolWindowContentManager = null;
            this.myToolWindowContentManagerListener = null;
            this.myDashboardToToolWindowContents.clear();
        });
        this.myToolWindowContentManager = toolWindow.getContentManager();
        this.myToolWindowContentManager.addContent(this.myToolWindowContent);
        this.myToolWindowContentManagerListener = new ToolWindowContentManagerListener();
        this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
    }

    public List<RunDashboardManager.RunDashboardService> getRunConfigurations() {
        this.myServiceLock.readLock().lock();
        try {
            List<RunDashboardManager.RunDashboardService> list2 = this.myServices.stream().flatMap(s -> s.stream()).collect(Collectors.toList());
            return list2;
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
    }

    private List<RunContentDescriptor> filterByContent(List<RunContentDescriptor> descriptors) {
        return ContainerUtil.filter(descriptors, descriptor2 -> {
            Content content2 = descriptor2.getAttachedContent();
            return content2 != null && content2.getManager() == this.myContentManager;
        });
    }

    public boolean isShowConfigurations() {
        return this.myShowConfigurations;
    }

    public void setShowConfigurations(boolean value) {
        this.myShowConfigurations = value;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            Content content2;
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myToolWindowContentManager != null && (content2 = this.myToolWindowContentManager.getSelectedContent()) != null && content2.equals(this.myToolWindowContent)) {
                this.myToolWindowContentManager.setSelectedContent(content2, true);
            }
        });
        this.updateDashboard(false);
        this.updateToolWindowContent();
    }

    public float getContentProportion() {
        return this.myState.contentProportion;
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(2);
        }
        return this.myState.configurationTypes.contains(runConfiguration.getType().getId());
    }

    @NotNull
    public Set<String> getTypes() {
        Set<String> set = Collections.unmodifiableSet(this.myState.configurationTypes);
        if (set == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void setTypes(@NotNull Set<String> types) {
        if (types == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(4);
        }
        HashSet<String> removed = new HashSet<String>((Collection<String>)Sets.difference(this.myState.configurationTypes, types));
        HashSet<String> added = new HashSet<String>((Collection<String>)Sets.difference(types, this.myState.configurationTypes));
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(types);
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        this.syncConfigurations();
        this.moveRemovedTypesContent(removed);
        this.moveAddedTypesContent(added);
        this.updateDashboard(true);
    }

    private void moveRemovedTypesContent(Set<String> removedTypes) {
        if (removedTypes.isEmpty()) {
            return;
        }
        ExecutionManagerImpl executionManager = (ExecutionManagerImpl)ExecutionManager.getInstance((Project)this.myProject);
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)executionManager.getContentManager();
        for (RunDashboardManager.RunDashboardService service : this.getRunConfigurations()) {
            Executor executor;
            RunContentDescriptor descriptor2;
            Content content2 = service.getContent();
            if (content2 == null || !removedTypes.contains(service.getSettings().getType().getId()) || (descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2)) == null || (executor = RunContentManagerImpl.getExecutorByContent(content2)) == null) continue;
            descriptor2.setContentToolWindowId(null);
            RunDashboardManagerImpl.updateContentToolbar(content2, true);
            runContentManager.moveContent(executor, descriptor2);
        }
    }

    private void moveAddedTypesContent(Set<String> addedTypes) {
        if (addedTypes.isEmpty()) {
            return;
        }
        ExecutionManagerImpl executionManager = (ExecutionManagerImpl)ExecutionManager.getInstance((Project)this.myProject);
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)executionManager.getContentManager();
        List<RunContentDescriptor> descriptors = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> addedTypes.contains(settings.getType().getId())));
        for (RunContentDescriptor descriptor2 : descriptors) {
            Executor executor;
            Content content2 = descriptor2.getAttachedContent();
            if (content2 == null || (executor = RunContentManagerImpl.getExecutorByContent(content2)) == null) continue;
            descriptor2.setContentToolWindowId(this.getToolWindowId());
            runContentManager.moveContent(executor, descriptor2);
        }
    }

    @NotNull
    public List<RunDashboardCustomizer> getCustomizers(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor2) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(5);
        }
        List customizers = ContainerUtil.newSmartList();
        for (RunDashboardCustomizer customizer : (RunDashboardCustomizer[])EP_NAME.getExtensions()) {
            if (!customizer.isApplicable(settings, descriptor2)) continue;
            customizers.add(customizer);
        }
        List list2 = customizers;
        if (list2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            this.updateDashboardIfNeeded(settings.getConfiguration(), true);
        }
    }

    private void updateDashboardIfNeeded(@NotNull RunConfiguration configuration, boolean withStructure) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.isShowInDashboard(configuration) || !this.filterByContent(ExecutionManagerImpl.getInstance(this.myProject).getDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> configuration.equals(s.getConfiguration())))).isEmpty()) {
            this.updateDashboard(withStructure);
        }
    }

    @NotNull
    public Condition<Content> getReuseCondition() {
        Condition<Content> condition = this.myReuseCondition;
        if (condition == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(8);
        }
        return condition;
    }

    private boolean canReuseContent(Content content2) {
        RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        if (descriptor2 == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        Set<RunnerAndConfigurationSettings> descriptorConfigurations = executionManager.getConfigurations(descriptor2);
        if (descriptorConfigurations.isEmpty()) {
            return true;
        }
        HashSet storedConfigurations = new HashSet(RunManager.getInstance((Project)this.myProject).getAllConfigurationsList());
        return descriptorConfigurations.stream().noneMatch(descriptorConfiguration -> {
            RunConfiguration configuration = descriptorConfiguration.getConfiguration();
            return this.isShowInDashboard(configuration) && storedConfigurations.contains(configuration);
        });
    }

    public void updateDashboard(boolean withStructure) {
        ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(RunConfigurationsServiceViewContributor.class));
        if (Registry.is((String)"ide.service.view")) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (withStructure) {
                boolean available = this.hasContent();
                ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
                if (toolWindow == null) {
                    if (!this.myState.configurationTypes.isEmpty() || available) {
                        toolWindow = this.createToolWindow(toolWindowManager, available);
                    }
                    if (available) {
                        toolWindow.show(null);
                    }
                    return;
                }
                boolean doShow = !toolWindow.isAvailable() && available;
                toolWindow.setAvailable(available, null);
                if (doShow) {
                    toolWindow.show(null);
                }
            }
            if (this.myDashboardContent != null) {
                this.myDashboardContent.updateContent(withStructure);
            }
        });
    }

    private ToolWindow createToolWindow(ToolWindowManager toolWindowManager, boolean available) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        toolWindow.setAvailable(available, null);
        this.createToolWindowContent(toolWindow);
        return toolWindow;
    }

    private boolean hasContent() {
        return !this.getRunConfigurations().isEmpty();
    }

    private void updateToolWindowContent() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myToolWindowContent == null || this.myToolWindowContentManager == null || this.myToolWindowContentManagerListener == null) {
                return;
            }
            boolean containsConfigurationsContent = false;
            for (Content content2 : this.myToolWindowContentManager.getContents()) {
                if (!this.myToolWindowContent.equals(content2)) continue;
                containsConfigurationsContent = true;
                break;
            }
            if (this.myShowConfigurations) {
                if (!containsConfigurationsContent) {
                    this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                    this.myDashboardToToolWindowContents.clear();
                    this.myToolWindowContentManager.removeAllContents(true);
                    this.myToolWindowContentManager.addContent(this.myToolWindowContent);
                    this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
                }
                this.updateToolWindowContentTabHeader(this.myContentManager.getSelectedContent());
            } else if (containsConfigurationsContent) {
                Content contentToSelect;
                this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                this.myToolWindowContentManager.removeContent(this.myToolWindowContent, false);
                for (Content dashboardContent : this.myContentManager.getContents()) {
                    this.addToolWindowContent(dashboardContent);
                }
                Content dashboardSelectedContent = this.myContentManager.getSelectedContent();
                if (dashboardSelectedContent == null && this.myContentManager.getContentCount() > 0 && (dashboardSelectedContent = this.myContentManager.getContent(0)) != null) {
                    this.myContentManager.setSelectedContent(dashboardSelectedContent);
                }
                if ((contentToSelect = this.myDashboardToToolWindowContents.get(dashboardSelectedContent)) != null) {
                    this.myToolWindowContentManager.setSelectedContent(contentToSelect, true);
                }
                this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
            }
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
            if (toolWindow instanceof ToolWindowImpl) {
                ToolWindowContentUi contentUi = ((ToolWindowImpl)toolWindow).getContentUI();
                contentUi.revalidate();
                contentUi.repaint();
            }
        });
    }

    private void addToolWindowContent(final Content dashboardContent) {
        if (this.myToolWindowContentManager == null) {
            return;
        }
        final Content toolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, dashboardContent.getDisplayName(), false);
        toolWindowContent.setIcon(dashboardContent.getIcon());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("displayName".equals(property)) {
                    toolWindowContent.setDisplayName(dashboardContent.getDisplayName());
                } else if ("icon".equals(property)) {
                    toolWindowContent.setIcon(dashboardContent.getIcon());
                }
            }
        };
        Disposer.register((Disposable)toolWindowContent, () -> dashboardContent.removePropertyChangeListener(propertyChangeListener));
        dashboardContent.addPropertyChangeListener(propertyChangeListener);
        toolWindowContent.setShouldDisposeContent(false);
        toolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        toolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContentManager.addContent(toolWindowContent);
        this.myDashboardToToolWindowContents.put(dashboardContent, toolWindowContent);
    }

    private void updateToolWindowContentTabHeader(@Nullable Content content2) {
        if (content2 != null) {
            this.myToolWindowContent.setDisplayName(content2.getDisplayName());
            this.myToolWindowContent.setIcon(content2.getIcon());
            this.myToolWindowContent.setCloseable(true);
        } else {
            this.myToolWindowContent.setDisplayName(null);
            this.myToolWindowContent.setIcon(null);
            this.myToolWindowContent.setCloseable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncConfigurations() {
        List settingsList = ContainerUtil.filter((Collection)RunManager.getInstance((Project)this.myProject).getAllSettings(), settings -> this.isShowInDashboard(settings.getConfiguration()));
        ArrayList<List<RunDashboardServiceImpl>> result2 = new ArrayList<List<RunDashboardServiceImpl>>();
        this.myServiceLock.writeLock().lock();
        try {
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : settingsList) {
                List syncedServices = this.getServices(runnerAndConfigurationSettings);
                if (syncedServices == null) {
                    syncedServices = ContainerUtil.newSmartList((Object)new RunDashboardServiceImpl(runnerAndConfigurationSettings));
                }
                result2.add(syncedServices);
            }
            for (List list2 : this.myServices) {
                RunDashboardManager.RunDashboardService service = (RunDashboardManager.RunDashboardService)list2.get(0);
                if (service.getContent() == null || settingsList.contains(service.getSettings())) continue;
                result2.add(list2);
            }
            this.myServices = result2;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void addServiceContent(@NotNull Content content2) {
        RunnerAndConfigurationSettings settings;
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(9);
        }
        if ((settings = this.findSettings(content2)) == null) {
            return;
        }
        this.myServiceLock.writeLock().lock();
        try {
            this.doAddServiceContent(settings, content2);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void removeServiceContent(@NotNull Content content2) {
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(10);
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardServiceImpl service = this.findService(content2);
            if (service == null) {
                return;
            }
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.updateDashboard(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceContent(@NotNull Content content2) {
        RunnerAndConfigurationSettings settings;
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(11);
        }
        if ((settings = this.findSettings(content2)) == null) {
            return;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardServiceImpl service = this.findService(content2);
            if (service == null || service.getSettings().equals(settings)) {
                return;
            }
            this.doAddServiceContent(settings, content2);
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void doAddServiceContent(@NotNull RunnerAndConfigurationSettings settings, @NotNull Content content2) {
        RunDashboardServiceImpl newService;
        RunDashboardServiceImpl service;
        List settingsServices;
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(12);
        }
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(13);
        }
        if ((settingsServices = this.getServices(settings)) == null) {
            settingsServices = ContainerUtil.newSmartList((Object)new RunDashboardServiceImpl(settings));
            this.myServices.add(settingsServices);
        }
        if ((service = settingsServices.get(0)).getContent() == null) {
            newService = service;
        } else {
            newService = new RunDashboardServiceImpl(settings);
            settingsServices.add(newService);
        }
        newService.setContent(content2);
    }

    private void doRemoveServiceContent(@NotNull RunDashboardServiceImpl service) {
        if (service == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(14);
        }
        service.setContent(null);
        RunnerAndConfigurationSettings contentSettings = service.getSettings();
        List<RunDashboardServiceImpl> services = this.getServices(contentSettings);
        if (services == null) {
            return;
        }
        if (services.size() > 1) {
            services.remove(service);
        } else if (!this.isShowInDashboard(contentSettings.getConfiguration()) || !RunManager.getInstance((Project)this.myProject).getAllSettings().contains(contentSettings)) {
            this.myServices.remove(services);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunDashboardServiceImpl findService(@NotNull Content content2) {
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(15);
        }
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardServiceImpl> services : this.myServices) {
                for (RunDashboardServiceImpl service : services) {
                    if (!content2.equals(service.getContent())) continue;
                    RunDashboardServiceImpl runDashboardServiceImpl = service;
                    return runDashboardServiceImpl;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
            this.updateDashboard(true);
        }
        return null;
    }

    @Nullable
    private RunnerAndConfigurationSettings findSettings(@NotNull Content content2) {
        if (content2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(16);
        }
        RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        Set<RunnerAndConfigurationSettings> settingsSet = ExecutionManagerImpl.getInstance(this.myProject).getConfigurations(descriptor2);
        return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem(settingsSet);
    }

    @Nullable
    private List<RunDashboardServiceImpl> getServices(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(17);
        }
        for (List<RunDashboardServiceImpl> services : this.myServices) {
            if (!services.get(0).getSettings().equals(settings)) continue;
            return services;
        }
        return null;
    }

    private static void updateContentToolbar(Content content2, boolean visible) {
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(RunContentManagerImpl.getRunContentDescriptorByContent(content2));
        if (ui != null) {
            ui.setLeftToolbarVisible(visible);
            ui.setContentToolbarBefore(visible);
        }
    }

    @Nullable
    static RunnerLayoutUiImpl getRunnerLayoutUi(@Nullable RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            return null;
        }
        RunnerLayoutUi layoutUi = descriptor2.getRunnerLayoutUi();
        return layoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)layoutUi : null;
    }

    @Nullable
    public State getState() {
        List<RuleState> ruleStates = this.myState.ruleStates;
        ruleStates.clear();
        for (RunDashboardGrouper grouper : this.myGroupers) {
            if (grouper.getRule().isAlwaysEnabled()) continue;
            ruleStates.add(new RuleState(grouper.getRule().getName(), grouper.isEnabled()));
        }
        if (this.myDashboardContent != null) {
            this.myState.contentProportion = this.myDashboardContent.getContentProportion();
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(18);
        }
        this.myState = state;
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        block0: for (RuleState ruleState : state.ruleStates) {
            for (RunDashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                continue block0;
            }
        }
        this.syncConfigurations();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReuseCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShowInDashboard";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDashboardIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addServiceContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeServiceContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateServiceContent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doAddServiceContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveServiceContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToolWindowContentManagerListener
    extends ContentManagerAdapter {
        private ToolWindowContentManagerListener() {
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowContentManagerListener.$$$reportNull$$$0(0);
            }
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                Content content2 = RunDashboardManagerImpl.this.myContentManager.getSelectedContent();
                if (content2 != null) {
                    RunDashboardManagerImpl.this.myContentManager.removeContent(content2, true);
                }
                event.consume();
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null) {
                return;
            }
            RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(dashboardContent);
            if (!RunDashboardManagerImpl.this.myContentManager.removeContent(dashboardContent, true)) {
                event.consume();
                RunDashboardManagerImpl.this.myDashboardToToolWindowContents.put(dashboardContent, event.getContent());
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowContentManagerListener.$$$reportNull$$$0(1);
            }
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                return;
            }
            if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null || RunDashboardManagerImpl.this.myContentManager.isSelected(dashboardContent)) {
                return;
            }
            RunDashboardManagerImpl.this.myContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
            RunDashboardManagerImpl.this.myContentManager.setSelectedContent(dashboardContent);
            RunDashboardManagerImpl.this.myContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
        }

        private Content getDashboardContent(Content content2) {
            for (Map.Entry entry : RunDashboardManagerImpl.this.myDashboardToToolWindowContents.entrySet()) {
                if (!((Content)entry.getValue()).equals(content2)) continue;
                return (Content)entry.getKey();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$ToolWindowContentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoveQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DashboardContentManagerListener
    extends ContentManagerAdapter {
        private DashboardContentManagerListener() {
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                DashboardContentManagerListener.$$$reportNull$$$0(0);
            }
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.get(event.getContent());
            if (toolWindowContent == null) {
                RunDashboardManagerImpl.this.addToolWindowContent(event.getContent());
            } else if (!RunDashboardManagerImpl.this.myToolWindowContentManager.isSelected(toolWindowContent)) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.setSelectedContent(toolWindowContent);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                DashboardContentManagerListener.$$$reportNull$$$0(1);
            }
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(event.getContent());
            if (toolWindowContent != null && toolWindowContent.getManager() != null) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContent(toolWindowContent, true);
                RunDashboardManagerImpl.this.myToolWindowContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                DashboardContentManagerListener.$$$reportNull$$$0(2);
            }
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                this.contentAdded(event);
            }
            if (RunDashboardManagerImpl.this.myToolWindowContentManager == null || RunDashboardManagerImpl.this.myToolWindowContent == null || !RunDashboardManagerImpl.this.myShowConfigurations) {
                return;
            }
            Content content2 = event.getOperation() == ContentManagerEvent.ContentOperation.add ? event.getContent() : null;
            RunDashboardManagerImpl.this.updateToolWindowContentTabHeader(content2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$DashboardContentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDashboardServiceImpl
    implements RunDashboardManager.RunDashboardService {
        private final RunnerAndConfigurationSettings mySettings;
        private volatile Content myContent;

        RunDashboardServiceImpl(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(0);
            }
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(1);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            Content content2 = this.myContent;
            return content2 == null ? null : RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        }

        @Nullable
        public Content getContent() {
            return this.myContent;
        }

        void setContent(@Nullable Content content2) {
            this.myContent = content2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunDashboardServiceImpl service = (RunDashboardServiceImpl)o;
            return this.mySettings.equals(service.mySettings) && Comparing.equal((Object)this.myContent, (Object)service.myContent);
        }

        public int hashCode() {
            int result2 = this.mySettings.hashCode();
            result2 = 31 * result2 + (this.myContent != null ? this.myContent.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        RuleState() {
        }

        RuleState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }
    }

    static class State {
        public final Set<String> configurationTypes = new THashSet();
        public final List<RuleState> ruleStates = new ArrayList<RuleState>();
        public float contentProportion = 0.3f;

        State() {
        }
    }
}

