/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LossyEncodingInspection");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            LossyEncodingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
        if (string == null) {
            LossyEncodingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("LossyEncoding" == null) {
            LossyEncodingInspection.$$$reportNull$$$0(2);
        }
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(4);
        }
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text2 = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text2);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList descriptors = new SmartList();
        boolean ok = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile, charset, (List<? super ProblemDescriptor>)descriptors);
        if (ok) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text2, charset, (List<ProblemDescriptor>)descriptors);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull List<? super ProblemDescriptor> descriptors) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            LossyEncodingInspection.$$$reportNull$$$0(7);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(9);
        }
        if (FileDocumentManager.getInstance().isFileModified(virtualFile) || !EncodingUtil.canReload(virtualFile)) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile, charset)) {
            LocalQuickFix[] fixes = LossyEncodingInspection.getFixes(file2, virtualFile, charset);
            descriptors.add((ProblemDescriptor)manager.createProblemDescriptor((PsiElement)file2, "File was loaded in the wrong encoding: '" + charset + "'", true, ProblemHighlightType.GENERIC_ERROR, isOnTheFly, fixes));
            return false;
        }
        return true;
    }

    @NotNull
    private static LocalQuickFix[] getFixes(final @NotNull PsiFile file2, final @NotNull VirtualFile virtualFile, @NotNull Charset wrongCharset) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            LossyEncodingInspection.$$$reportNull$$$0(11);
        }
        if (wrongCharset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(12);
        }
        HashSet suspects = ContainerUtil.newHashSet((Object[])new Charset[]{CharsetToolkit.getDefaultSystemCharset(), CharsetToolkit.getPlatformCharset()});
        suspects.remove(wrongCharset);
        List goodCharsets = ContainerUtil.filter((Collection)suspects, c2 -> LossyEncodingInspection.isGoodCharset(virtualFile, c2));
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (!goodCharsets.isEmpty()) {
            final Charset goodCharset = (Charset)goodCharsets.get(0);
            fixes.add(new LocalQuickFix(){

                @Nls
                @NotNull
                public String getFamilyName() {
                    String string = "Reload in '" + goodCharset.displayName() + "'";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean startInWriteAction() {
                    return false;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                    Document document;
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (descriptor2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file2)) == null) {
                        return;
                    }
                    ChangeFileEncodingAction.changeTo(project, document, null, virtualFile, goodCharset, EncodingUtil.Magic8.ABSOLUTELY, EncodingUtil.Magic8.ABSOLUTELY);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            fixes.add(new LocalQuickFix(){

                @Nls
                @NotNull
                public String getFamilyName() {
                    String string = "Set project encoding to '" + goodCharset.displayName() + "'";
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (descriptor2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    EncodingProjectManager.getInstance((Project)project).setDefaultCharsetName(goodCharset.name());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        fixes.add((Object)new ReloadInAnotherEncodingFix(file2));
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            LossyEncodingInspection.$$$reportNull$$$0(13);
        }
        return localQuickFixArray;
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean equals;
        byte[] bytesToSave;
        byte[] loadedBytes;
        FileDocumentManager documentManager;
        Document document;
        if (virtualFile == null) {
            LossyEncodingInspection.$$$reportNull$$$0(14);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(15);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(virtualFile)) == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e) {
            return true;
        }
        if (loadedBytes.length == 0 && bytesToSave.length == 0) {
            return true;
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        if (!(equals = Arrays.equals(bytesToSave, loadedBytes)) && LOG.isDebugEnabled()) {
            try {
                String tempDir = FileUtil.getTempDirectory();
                FileUtil.writeToFile((File)new File(tempDir, "lossy-bytes-to-save"), (byte[])bytesToSave);
                FileUtil.writeToFile((File)new File(tempDir, "lossy-loaded-bytes"), (byte[])loadedBytes);
                LOG.debug("lossy bytes dumped into " + tempDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return equals;
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text2, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        TextRange errRange;
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(16);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(18);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(19);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(20);
        }
        CharBuffer buffer = CharBuffer.wrap(text2);
        int textLength = text2.length();
        CharBuffer back = CharBuffer.allocate(textLength);
        Ref outRef = Ref.create();
        int pos = 0;
        for (int errorCount = 0; pos < text2.length() && errorCount < 200 && (errRange = LossyEncodingInspection.nextUnmappable(buffer, pos, (Ref<ByteBuffer>)outRef, back, charset)) != null; ++errorCount) {
            ProblemDescriptor lastDescriptor = (ProblemDescriptor)ContainerUtil.getLastItem(descriptors);
            if (lastDescriptor != null && lastDescriptor.getTextRangeInElement().getEndOffset() == errRange.getStartOffset()) {
                errRange = lastDescriptor.getTextRangeInElement().union(errRange);
                descriptors.remove(descriptors.size() - 1);
            }
            String message = InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset});
            ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file2, errRange, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new ChangeEncodingFix(file2)});
            descriptors.add(descriptor2);
            pos = errRange.getEndOffset();
        }
    }

    private static TextRange nextUnmappable(@NotNull CharBuffer in, int position, @NotNull Ref<ByteBuffer> outRef, @NotNull CharBuffer back, @NotNull Charset charset) {
        CoderResult cr;
        if (in == null) {
            LossyEncodingInspection.$$$reportNull$$$0(21);
        }
        if (outRef == null) {
            LossyEncodingInspection.$$$reportNull$$$0(22);
        }
        if (back == null) {
            LossyEncodingInspection.$$$reportNull$$$0(23);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(24);
        }
        CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        int textLength = in.limit() - position;
        ByteBuffer out = (ByteBuffer)outRef.get();
        if (out == null) {
            out = ByteBuffer.allocate((int)(encoder.averageBytesPerChar() * (float)textLength));
            outRef.set((Object)out);
        }
        out.rewind();
        out.limit(out.capacity());
        in.rewind();
        in.position(position);
        while (true) {
            CoderResult coderResult = cr = in.hasRemaining() ? encoder.encode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = encoder.flush(out);
            }
            if (!cr.isOverflow()) break;
            int n = 3 * out.capacity() / 2 + 1;
            ByteBuffer tmp = ByteBuffer.allocate(n);
            out.flip();
            tmp.put(out);
            out = tmp;
            outRef.set((Object)out);
        }
        if (cr.isError()) {
            return TextRange.from((int)in.position(), (int)cr.length());
        }
        int outLength = out.position();
        CharsetDecoder decoder = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        out.rewind();
        out.limit(outLength);
        back.rewind();
        CoderResult dr = decoder.decode(out, back, true);
        if (dr.isError()) {
            return TextRange.from((int)back.position(), (int)dr.length());
        }
        if (back.position() != textLength) {
            return TextRange.from((int)Math.min(textLength, back.position()), (int)1);
        }
        in.rewind();
        in.position(position);
        back.rewind();
        int len = StringUtil.commonPrefixLength((CharSequence)in, (CharSequence)back);
        if (len == textLength) {
            return null;
        }
        return TextRange.from((int)len, (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 15: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrongCharset";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outRef";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "back";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLoadedInWrongEncoding";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGoodCharset";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCharactersWillBeLostAfterSave";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "nextUnmappable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeEncodingFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        ChangeEncodingFix(@NotNull PsiFile file2) {
            if (file2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)file2);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ChangeEncodingFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Change file encoding" == null) {
                ChangeEncodingFix.$$$reportNull$$$0(2);
            }
            return "Change file encoding";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            VirtualFile virtualFile;
            DataContext dataContext;
            ListPopup popup2;
            if (project == null) {
                ChangeEncodingFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ChangeEncodingFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ChangeEncodingFix.$$$reportNull$$$0(6);
            }
            if ((popup2 = new ChangeFileEncodingAction().createPopup(dataContext = ChangeEncodingFix.createDataContext(editor, editor == null ? null : editor.getComponent(), virtualFile = file2.getVirtualFile(), project))) != null) {
                popup2.showInBestPositionFor(dataContext);
            }
        }

        @NotNull
        static DataContext createDataContext(Editor editor, Component component, VirtualFile selectedFile, Project project) {
            DataContext parent = DataManager.getInstance().getDataContext(component);
            DataContext context = SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent);
            DataContext projectContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project, context);
            DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), selectedFile, projectContext);
            if (dataContext == null) {
                ChangeEncodingFix.$$$reportNull$$$0(7);
            }
            return dataContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        ReloadInAnotherEncodingFix(@NotNull PsiFile file2) {
            if (file2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        @NotNull
        public String getText() {
            if ("Reload in another encoding" == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(1);
            }
            return "Reload in another encoding";
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(5);
            }
            if (FileDocumentManager.getInstance().isFileModified(file2.getVirtualFile())) {
                return;
            }
            super.invoke(project, file2, editor, startElement, endElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

