/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUtil {
    private FoldingUtil() {
    }

    @Nullable
    public static FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion region;
        if (editor == null) {
            FoldingUtil.$$$reportNull$$$0(0);
        }
        return (region = editor.getFoldingModel().getFoldRegion(startOffset, endOffset)) != null && region.isValid() ? region : null;
    }

    @Nullable
    public static FoldRegion findFoldRegionStartingAtLine(@NotNull Editor editor, int line2) {
        FoldRegion[] regions;
        if (editor == null) {
            FoldingUtil.$$$reportNull$$$0(1);
        }
        if (line2 < 0 || line2 >= editor.getDocument().getLineCount()) {
            return null;
        }
        FoldRegion result2 = null;
        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid() || region.getDocument().getLineNumber(region.getStartOffset()) != line2) continue;
            if (result2 != null) {
                return null;
            }
            result2 = region;
        }
        return result2;
    }

    public static FoldRegion[] getFoldRegionsAtOffset(Editor editor, int offset) {
        FoldRegion[] allRegions;
        ArrayList<FoldRegion> list2 = new ArrayList<FoldRegion>();
        for (FoldRegion region : allRegions = editor.getFoldingModel().getAllFoldRegions()) {
            if (region.getStartOffset() > offset || offset > region.getEndOffset()) continue;
            list2.add(region);
        }
        FoldRegion[] regions = list2.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(regions, Collections.reverseOrder(RangeMarker.BY_START_OFFSET));
        return regions;
    }

    static boolean caretInsideRange(Editor editor, TextRange range2) {
        int offset = editor.getCaretModel().getOffset();
        return range2.contains(offset) && range2.getStartOffset() != offset;
    }

    public static boolean isHighlighterFolded(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        if (editor == null) {
            FoldingUtil.$$$reportNull$$$0(2);
        }
        if (highlighter == null) {
            FoldingUtil.$$$reportNull$$$0(3);
        }
        int startOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaStartOffset() : highlighter.getStartOffset();
        int endOffset = highlighter instanceof RangeHighlighterEx ? ((RangeHighlighterEx)highlighter).getAffectedAreaEndOffset() : highlighter.getEndOffset();
        return FoldingUtil.isTextRangeFolded(editor, new TextRange(startOffset, endOffset));
    }

    public static boolean isTextRangeFolded(@NotNull Editor editor, @NotNull TextRange range2) {
        FoldRegion foldRegion;
        if (editor == null) {
            FoldingUtil.$$$reportNull$$$0(4);
        }
        if (range2 == null) {
            FoldingUtil.$$$reportNull$$$0(5);
        }
        return (foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(range2.getStartOffset())) != null && range2.getEndOffset() <= foldRegion.getEndOffset();
    }

    public static Iterator<FoldRegion> createFoldTreeIterator(@NotNull Editor editor) {
        if (editor == null) {
            FoldingUtil.$$$reportNull$$$0(6);
        }
        final FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        return new Iterator<FoldRegion>(){
            private int sectionStart;
            private int current;
            private int sectionEnd;
            {
                this.advanceSection();
            }

            private void advanceSection() {
                this.sectionStart = this.sectionEnd;
                this.sectionEnd = this.sectionStart + 1;
                while (this.sectionEnd < allRegions.length && allRegions[this.sectionEnd].getStartOffset() == allRegions[this.sectionStart].getStartOffset()) {
                    ++this.sectionEnd;
                }
                this.current = this.sectionEnd;
            }

            @Override
            public boolean hasNext() {
                return this.current > this.sectionStart || this.sectionEnd < allRegions.length;
            }

            @Override
            public FoldRegion next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.current <= this.sectionStart) {
                    this.advanceSection();
                }
                return allRegions[--this.current];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFoldRegion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFoldRegionStartingAtLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isHighlighterFolded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTextRangeFolded";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFoldTreeIterator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

