/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectAndLibrariesScope
extends GlobalSearchScope {
    protected final ProjectFileIndex myProjectFileIndex;
    protected final boolean mySearchOutsideRootModel;
    private String myDisplayName = PsiBundle.message("psi.search.scope.project.and.libraries", new Object[0]);

    public ProjectAndLibrariesScope(Project project) {
        this(project, false);
    }

    public ProjectAndLibrariesScope(Project project, boolean searchOutsideRootModel) {
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.mySearchOutsideRootModel = searchOutsideRootModel;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(0);
        }
        return this.myProjectFileIndex.isInContent(file) || this.myProjectFileIndex.isInLibrary(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(2);
        }
        List<OrderEntry> entries1 = this.myProjectFileIndex.getOrderEntriesForFile(file1);
        List<OrderEntry> entries2 = this.myProjectFileIndex.getOrderEntriesForFile(file2);
        if (entries1.size() != entries2.size()) {
            return 0;
        }
        int res = 0;
        for (OrderEntry entry1 : entries1) {
            Module module = entry1.getOwnerModule();
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            OrderEntry entry2 = moduleFileIndex.getOrderEntryForFile(file2);
            if (entry2 == null) {
                return 0;
            }
            int aRes = entry2.compareTo(entry1);
            if (aRes == 0) {
                return 0;
            }
            if (res == 0) {
                res = aRes;
                continue;
            }
            if (res == aRes) continue;
            return 0;
        }
        return res;
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.mySearchOutsideRootModel;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        Collection<UnloadedModuleDescription> collection = project != null ? ModuleManager.getInstance(project).getUnloadedModuleDescriptions() : Collections.emptySet();
        if (collection == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(6);
        }
        this.myDisplayName = displayName;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(7);
        }
        if (scope.isSearchOutsideRootModel()) {
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                ProjectAndLibrariesScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(10);
        }
        if (scope.isSearchOutsideRootModel()) {
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                ProjectAndLibrariesScope.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        ProjectAndLibrariesScope projectAndLibrariesScope = this;
        if (projectAndLibrariesScope == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(12);
        }
        return projectAndLibrariesScope;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/ProjectAndLibrariesScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/ProjectAndLibrariesScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

