/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.execution.util.StringWithNewLinesCellEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvVariablesTable
extends ListTableWithButtons<EnvironmentVariable> {
    private CopyPasteProviderPanel myPanel;
    private boolean myPasteEnabled = false;

    public EnvVariablesTable() {
        AnAction pasteAction;
        this.getTableView().getEmptyText().setText("No variables");
        AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
        if (copyAction != null) {
            copyAction.registerCustomShortcutSet(copyAction.getShortcutSet(), this.getTableView());
        }
        if ((pasteAction = ActionManager.getInstance().getAction("$Paste")) != null) {
            pasteAction.registerCustomShortcutSet(pasteAction.getShortcutSet(), this.getTableView());
        }
    }

    public void setPasteActionEnabled(boolean enabled) {
        this.myPasteEnabled = enabled;
    }

    @Override
    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{new NameColumnInfo(), new ValueColumnInfo()});
    }

    public void editVariableName(EnvironmentVariable environmentVariable) {
        ApplicationManager.getApplication().invokeLater(() -> {
            EnvironmentVariable actualEnvVar = (EnvironmentVariable)ContainerUtil.find(this.getElements(), item -> StringUtil.equals((CharSequence)environmentVariable.getName(), (CharSequence)item.getName()));
            if (actualEnvVar == null) {
                return;
            }
            this.setSelection(actualEnvVar);
            if (actualEnvVar.getNameIsWriteable()) {
                this.editSelection(0);
            }
        });
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.getElements();
    }

    @Override
    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CopyPasteProviderPanel(super.getComponent());
        }
        return this.myPanel;
    }

    @Override
    protected EnvironmentVariable createElement() {
        return new EnvironmentVariable("", "", false);
    }

    @Override
    protected boolean isEmpty(EnvironmentVariable element) {
        return element.getName().isEmpty() && element.getValue().isEmpty();
    }

    @Override
    protected EnvironmentVariable cloneElement(EnvironmentVariable envVariable) {
        return envVariable.clone();
    }

    @Override
    protected boolean canDeleteElement(EnvironmentVariable selection) {
        return !selection.getIsPredefined();
    }

    @Override
    @NotNull
    protected AnActionButton[] createExtraActions() {
        AnActionButton copyButton = new AnActionButton(ActionsBundle.message("action.EditorCopy.text", new Object[0]), AllIcons.Actions.Copy){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EnvVariablesTable.this.myPanel.performCopy(e.getDataContext());
            }

            @Override
            public boolean isEnabled() {
                return EnvVariablesTable.this.myPanel.isCopyEnabled(DataContext.EMPTY_CONTEXT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/util/EnvVariablesTable$1", "actionPerformed"));
            }
        };
        AnActionButton pasteButton = new AnActionButton(ActionsBundle.message("action.EditorPaste.text", new Object[0]), AllIcons.Actions.Menu_paste){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EnvVariablesTable.this.myPanel.performPaste(e.getDataContext());
            }

            @Override
            public boolean isEnabled() {
                return EnvVariablesTable.this.myPanel.isPasteEnabled(DataContext.EMPTY_CONTEXT);
            }

            @Override
            public boolean isVisible() {
                return EnvVariablesTable.this.myPanel.isPastePossible(DataContext.EMPTY_CONTEXT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/util/EnvVariablesTable$2", "actionPerformed"));
            }
        };
        AnActionButton[] anActionButtonArray = new AnActionButton[]{copyButton, pasteButton};
        if (anActionButtonArray == null) {
            EnvVariablesTable.$$$reportNull$$$0(0);
        }
        return anActionButtonArray;
    }

    @NotNull
    public static Map<String, String> parseEnvsFromText(String content) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (content != null && content.contains("=")) {
            ArrayList<String> pairs;
            boolean legacyFormat = content.contains("\n");
            if (legacyFormat) {
                pairs = StringUtil.split((String)content, (String)"\n");
            } else {
                pairs = new ArrayList<String>();
                int start = 0;
                int end = content.indexOf(";");
                while (end < content.length()) {
                    if (end == -1) {
                        pairs.add(content.substring(start).replace("\\;", ";"));
                        break;
                    }
                    if (end > 0 && content.charAt(end - 1) != '\\') {
                        pairs.add(content.substring(start, end).replace("\\;", ";"));
                        start = end + 1;
                    }
                    end = content.indexOf(";", end + 1);
                }
            }
            for (String pair : pairs) {
                int pos = pair.indexOf(61);
                if (pos <= 0) continue;
                while (pos > 0 && pair.charAt(pos - 1) == '\\') {
                    pos = pair.indexOf(61, pos + 1);
                }
                pair = pair.replaceAll("[\\\\]{1}", "\\\\\\\\");
                result.put(StringUtil.unescapeStringCharacters((String)pair.substring(0, pos)), StringUtil.unescapeStringCharacters((String)pair.substring(pos + 1)));
            }
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            EnvVariablesTable.$$$reportNull$$$0(1);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/util/EnvVariablesTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnvsFromText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CopyPasteProviderPanel
    extends JPanel
    implements DataProvider,
    CopyProvider,
    PasteProvider {
        private CopyPasteProviderPanel(JComponent component) {
            super(new GridLayout(1, 1));
            this.add(component);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return this;
            }
            return null;
        }

        @Override
        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(1);
            }
            EnvVariablesTable.this.stopEditing();
            StringBuilder sb = new StringBuilder();
            List variables = EnvVariablesTable.this.getSelection();
            for (EnvironmentVariable environmentVariable : variables) {
                if (EnvVariablesTable.this.isEmpty(environmentVariable)) continue;
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(StringUtil.escapeChars((String)environmentVariable.getName(), (char[])new char[]{'=', ';'})).append('=').append(StringUtil.escapeChars((String)environmentVariable.getValue(), (char[])new char[]{'=', ';'}));
            }
            CopyPasteManager.getInstance().setContents(new StringSelection(sb.toString()));
        }

        @Override
        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(2);
            }
            return !EnvVariablesTable.this.getSelection().isEmpty();
        }

        @Override
        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(3);
            }
            return this.isCopyEnabled(dataContext);
        }

        @Override
        public void performPaste(@NotNull DataContext dataContext) {
            String content;
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmpty((String)(content = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)))) {
                return;
            }
            Map<String, String> map = EnvVariablesTable.parseEnvsFromText(content);
            TableView view = EnvVariablesTable.this.getTableView();
            if (view.isEditing() || map.isEmpty()) {
                int row = view.getEditingRow();
                int column = view.getEditingColumn();
                if (row < 0 || column < 0) {
                    row = view.getSelectedRow();
                    column = view.getSelectedColumn();
                }
                if (row >= 0 && column >= 0) {
                    view.stopEditing();
                    view.getModel().setValueAt(content, row, column);
                }
                return;
            }
            EnvVariablesTable.this.stopEditing();
            EnvVariablesTable.this.removeSelected();
            ArrayList<EnvironmentVariable> parsed = new ArrayList<EnvironmentVariable>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                parsed.add(new EnvironmentVariable(entry.getKey(), entry.getValue(), false));
            }
            List<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(EnvVariablesTable.this.getEnvironmentVariables());
            variables.addAll(parsed);
            variables = ContainerUtil.filter(variables, variable -> !StringUtil.isEmpty((String)variable.getName()) || !StringUtil.isEmpty((String)variable.getValue()));
            EnvVariablesTable.this.setValues(variables);
        }

        @Override
        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(5);
            }
            return EnvVariablesTable.this.myPasteEnabled;
        }

        @Override
        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(6);
            }
            return EnvVariablesTable.this.myPasteEnabled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class ValueColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public ValueColumnInfo() {
            super("Value");
        }

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getValue();
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return !environmentVariable.getIsPredefined();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setValue(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        @Nullable
        protected String getDescription(EnvironmentVariable environmentVariable) {
            return environmentVariable.getDescription();
        }

        @NotNull
        public TableCellEditor getEditor(EnvironmentVariable variable) {
            StringWithNewLinesCellEditor editor = new StringWithNewLinesCellEditor();
            editor.setClickCountToStart(1);
            StringWithNewLinesCellEditor stringWithNewLinesCellEditor = editor;
            if (stringWithNewLinesCellEditor == null) {
                ValueColumnInfo.$$$reportNull$$$0(0);
            }
            return stringWithNewLinesCellEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/EnvVariablesTable$ValueColumnInfo", "getEditor"));
        }
    }

    protected class NameColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public NameColumnInfo() {
            super("Name");
        }

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getName();
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return environmentVariable.getNameIsWriteable();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setName(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        protected String getDescription(EnvironmentVariable environmentVariable) {
            return environmentVariable.getDescription();
        }
    }
}

