/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class PsiLocation<E extends PsiElement>
extends Location<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.PsiLocation");
    private final E myPsiElement;
    private final Project myProject;
    private final Module myModule;

    public PsiLocation(E psiElement) {
        this(psiElement.getProject(), psiElement);
    }

    public PsiLocation(@NotNull Project project, @NotNull E psiElement) {
        if (project == null) {
            PsiLocation.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            PsiLocation.$$$reportNull$$$0(1);
        }
        this.myPsiElement = psiElement;
        this.myProject = project;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(psiElement);
    }

    public PsiLocation(@NotNull Project project, Module module, @NotNull E psiElement) {
        if (project == null) {
            PsiLocation.$$$reportNull$$$0(2);
        }
        if (psiElement == null) {
            PsiLocation.$$$reportNull$$$0(3);
        }
        this.myPsiElement = psiElement;
        this.myProject = project;
        this.myModule = module;
    }

    @Override
    @NotNull
    public E getPsiElement() {
        E e = this.myPsiElement;
        if (e == null) {
            PsiLocation.$$$reportNull$$$0(4);
        }
        return e;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PsiLocation.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(@NotNull Class<T> ancestorClass, boolean strict) {
        if (ancestorClass == null) {
            PsiLocation.$$$reportNull$$$0(6);
        }
        T first = strict || !ancestorClass.isInstance(this.myPsiElement) ? PsiLocation.findNext(this.myPsiElement, ancestorClass) : this.myPsiElement;
        Iterator iterator = new Iterator<Location<T>>((PsiElement)first, ancestorClass){
            private T myCurrent;
            final /* synthetic */ PsiElement val$first;
            final /* synthetic */ Class val$ancestorClass;
            {
                this.val$first = psiElement;
                this.val$ancestorClass = clazz;
                this.myCurrent = this.val$first;
            }

            @Override
            public boolean hasNext() {
                return this.myCurrent != null;
            }

            @Override
            public Location<T> next() {
                if (this.myCurrent == null) {
                    throw new NoSuchElementException();
                }
                PsiLocation psiLocation = new PsiLocation(PsiLocation.this.myProject, this.myCurrent);
                this.myCurrent = PsiLocation.findNext(this.myCurrent, this.val$ancestorClass);
                return psiLocation;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
        if (iterator == null) {
            PsiLocation.$$$reportNull$$$0(7);
        }
        return iterator;
    }

    @Override
    @NotNull
    public PsiLocation<E> toPsiLocation() {
        PsiLocation psiLocation = this;
        if (psiLocation == null) {
            PsiLocation.$$$reportNull$$$0(8);
        }
        return psiLocation;
    }

    private static <ElementClass extends PsiElement> ElementClass findNext(PsiElement psiElement, Class<ElementClass> ancestorClass) {
        PsiElement element = psiElement;
        while ((element = element.getParent()) != null && !(element instanceof PsiFile)) {
            PsiElement ancestor = (PsiElement)PsiLocation.safeCast(element, ancestorClass);
            if (ancestor == null) continue;
            return (ElementClass)ancestor;
        }
        return null;
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(@NotNull Project project, T element) {
        if (project == null) {
            PsiLocation.$$$reportNull$$$0(9);
        }
        if (element == null) {
            return null;
        }
        return new PsiLocation<T>(project, element);
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(T element) {
        return PsiLocation.fromPsiElement(element, null);
    }

    public static <T extends PsiElement> Location<T> fromPsiElement(T element, Module module) {
        if (element == null || !element.isValid()) {
            return null;
        }
        return module != null ? new PsiLocation<T>(element.getProject(), module, element) : new PsiLocation<T>(element.getProject(), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/PsiLocation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/PsiLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAncestors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromPsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

