/*
 * Decompiled with CFR 0.152.
 */
package net.iharder.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class TransferableObject
implements Transferable {
    public static final String MIME_TYPE = "application/x-net.iharder.dnd.TransferableObject";
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.dnd.TransferableObject");
    private Fetcher fetcher;
    private Object data;
    private DataFlavor customFlavor;

    public TransferableObject(Object data) {
        this.data = data;
        this.customFlavor = new DataFlavor(data.getClass(), MIME_TYPE);
    }

    public TransferableObject(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    public TransferableObject(Class dataClass, Fetcher fetcher) {
        this.fetcher = fetcher;
        this.customFlavor = new DataFlavor(dataClass, MIME_TYPE);
    }

    public DataFlavor getCustomDataFlavor() {
        return this.customFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.customFlavor != null) {
            return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
        }
        return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DATA_FLAVOR)) {
            return this.fetcher == null ? this.data : this.fetcher.getObject();
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DATA_FLAVOR)) {
            return true;
        }
        return flavor.equals(DataFlavor.stringFlavor);
    }

    public static interface Fetcher {
        public Object getObject();
    }
}

