/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.controller.actions.generated.instance.CollaborationActionBase;
import freemind.controller.actions.generated.instance.CollaborationTransaction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import plugins.collaboration.socket.TerminateableThread;

public abstract class CommunicationBase
extends TerminateableThread {
    private static final String STRING_CONTINUATION_SUFFIX = "<cont>";
    protected Socket mSocket;
    protected MindMapController mController;
    protected DataOutputStream out;
    protected DataInputStream in;
    protected static final int ROUNDTRIP_ROUNDS = 200;
    protected static final int ROUNDTRIP_TIMEOUT = 20000;
    protected static final int STATE_IDLE = 0;
    protected static final int STATE_WAIT_FOR_HELLO = 1;
    protected static final int STATE_WAIT_FOR_COMMAND = 2;
    protected static final int STATE_WAIT_FOR_WHO_ARE_YOU = 3;
    protected static final int STATE_WAIT_FOR_WELCOME = 4;
    protected static final int STATE_WAIT_FOR_LOCK = 5;
    protected static final int STATE_LOCK_RECEIVED = 6;
    private static final int MAX_STRING_LENGTH_TO_SEND = 65500;
    private int mCurrentState = 0;
    private String mCurrentStateMutex = "lockme";
    private StringBuffer mCurrentCommand = new StringBuffer();
    int mCounter = 1;

    public CommunicationBase(String pName, Socket pClient, MindMapController pController, DataOutputStream pOut, DataInputStream pIn) {
        super(pName);
        this.mSocket = pClient;
        this.mController = pController;
        this.out = pOut;
        this.in = pIn;
    }

    public synchronized boolean send(CollaborationActionBase pCommand) {
        try {
            this.printCommand("Send", pCommand);
            String marshalledText = Tools.marshall((XmlAction)pCommand);
            logger.fine(this.getName() + " :Sending " + marshalledText);
            String text = Tools.compress((String)marshalledText);
            int index = 0;
            while (index + 65500 < text.length()) {
                this.out.writeUTF(text.substring(index, index + 65500) + STRING_CONTINUATION_SUFFIX);
                index += 65500;
            }
            this.out.writeUTF(text.substring(index));
            return true;
        }
        catch (IOException e) {
            Resources.getInstance().logException((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean processAction() throws Exception {
        boolean didSomething = false;
        try {
            String text = this.in.readUTF();
            if (text.endsWith(STRING_CONTINUATION_SUFFIX)) {
                this.mCurrentCommand.append(text.substring(0, text.length() - STRING_CONTINUATION_SUFFIX.length()));
                didSomething = true;
            } else {
                this.mCurrentCommand.append(text);
                String textValue = this.mCurrentCommand.toString();
                this.mCurrentCommand.setLength(0);
                String decompressedText = Tools.decompress((String)textValue);
                logger.fine(this.getName() + " :Received " + decompressedText);
                final CollaborationActionBase command = (CollaborationActionBase)Tools.unMarshall((String)decompressedText);
                if (command != null) {
                    this.printCommand("Receive", command);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommunicationBase.this.processCommand(command);
                            }
                            catch (Exception e) {
                                Resources.getInstance().logException((Throwable)e);
                            }
                        }
                    };
                    if (command instanceof CollaborationTransaction) {
                        EventQueue.invokeLater(runnable);
                    } else {
                        runnable.run();
                    }
                    didSomething = true;
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        --this.mCounter;
        if (this.mCounter <= 0) {
            this.mCounter = 10;
            this.mController.getController().setTitle();
        }
        return didSomething;
    }

    private void printCommand(String pDirection, CollaborationActionBase pCommand) {
        if (pCommand instanceof CollaborationTransaction) {
            CollaborationTransaction trans = (CollaborationTransaction)pCommand;
            XmlAction doAction = this.mController.unMarshall(trans.getDoAction());
            String out = pDirection + ": " + Tools.printXmlAction((XmlAction)doAction) + " (Id: " + trans.getId() + ")";
            logger.info(out);
        } else {
            String out = pDirection + ": " + Tools.printXmlAction((XmlAction)pCommand);
            logger.info(out);
        }
    }

    public abstract void processCommand(CollaborationActionBase var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentState() {
        String string = this.mCurrentStateMutex;
        synchronized (string) {
            return this.mCurrentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentState(int pCurrentState) {
        String string = this.mCurrentStateMutex;
        synchronized (string) {
            this.mCurrentState = pCurrentState;
        }
    }

    public void sendCommand(String pDoAction, String pUndoAction, String pLockId) {
        CollaborationTransaction trans = new CollaborationTransaction();
        trans.setDoAction(pDoAction);
        trans.setUndoAction(pUndoAction);
        trans.setId(pLockId);
        this.send((CollaborationActionBase)trans);
    }

    public void close() throws IOException {
        this.mSocket.close();
    }

    public ActionPair getActionPair(CollaborationTransaction trans) {
        return new ActionPair(this.mController.unMarshall(trans.getDoAction()), this.mController.unMarshall(trans.getUndoAction()));
    }

    public String getIpToSocket() {
        return this.mSocket.getLocalAddress().getHostAddress();
    }

    protected void printWrongState(CollaborationActionBase pCommand) {
        logger.warning("Wrong state for " + pCommand.getClass() + ": " + this.printState(this.getCurrentState()));
    }

    protected String printState(int pCurrentState) {
        switch (pCurrentState) {
            case 0: {
                return "STATE_IDLE";
            }
            case 1: {
                return "STATE_WAIT_FOR_HELLO";
            }
            case 2: {
                return "STATE_WAIT_FOR_COMMAND";
            }
            case 3: {
                return "STATE_WAIT_FOR_WHO_ARE_YOU";
            }
            case 4: {
                return "STATE_WAIT_FOR_WELCOME";
            }
            case 5: {
                return "STATE_WAIT_FOR_LOCK";
            }
            case 6: {
                return "STATE_LOCK_RECEIVED";
            }
        }
        return "UNKNOWN: " + pCurrentState;
    }
}

