/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    protected final String myName;
    protected final String myPath;
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp;
    private final VirtualFileSystem myFileSystem;

    protected AbstractVcsVirtualFile(String path, VirtualFileSystem fileSystem) {
        this.myModificationStamp = 0;
        this.myFileSystem = fileSystem;
        this.myPath = path;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), this, this.myFileSystem) : null;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull String name, VirtualFileSystem fileSystem) {
        if (name == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(0);
        }
        this.myModificationStamp = 0;
        this.myFileSystem = fileSystem;
        this.myPath = parent != null && !StringUtil.isEmpty((String)parent.getPath()) ? parent.getPath() + "/" + name : name;
        this.myName = name;
        this.myParent = parent;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFileSystem;
        if (virtualFileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(1);
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getPresentableName() {
        return this.getPresentableName(this.myName);
    }

    @NotNull
    String getPresentableName(@NotNull String baseName) {
        if (baseName == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(4);
        }
        if (this.myRevision == null) {
            String string = baseName;
            if (string == null) {
                AbstractVcsVirtualFile.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = baseName + " (" + this.myRevision + ")";
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new RuntimeException(VcsFileSystem.COULD_NOT_IMPLEMENT_MESSAGE);
    }

    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void showLoadingContentFailedMessage(@NotNull VcsException e) {
        if (e == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.could.not.load.virtual.file.content", (Object[])new Object[]{this.getPresentableUrl(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.could.not.load.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showLoadingContentFailedMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

