/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.icons.AllIcons;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class SingleRowLayoutStrategy {
    private static final int MIN_TAB_WIDTH = 50;
    final SingleRowLayout myLayout;
    final JBTabsImpl myTabs;

    protected SingleRowLayoutStrategy(SingleRowLayout layout) {
        this.myLayout = layout;
        this.myTabs = this.myLayout.myTabs;
    }

    abstract int getMoreRectAxisSize();

    public abstract int getStartPosition(SingleRowPassInfo var1);

    public abstract int getToFitLength(SingleRowPassInfo var1);

    public abstract int getLengthIncrement(Dimension var1);

    public abstract int getMinPosition(Rectangle var1);

    public abstract int getMaxPosition(Rectangle var1);

    protected abstract int getFixedFitLength(SingleRowPassInfo var1);

    public Rectangle getLayoutRect(SingleRowPassInfo data, int position, int length) {
        return this.getLayoutRec(position, this.getFixedPosition(data), length, this.getFixedFitLength(data));
    }

    protected abstract Rectangle getLayoutRec(int var1, int var2, int var3, int var4);

    protected abstract int getFixedPosition(SingleRowPassInfo var1);

    public abstract Rectangle getMoreRect(SingleRowPassInfo var1);

    public abstract boolean isToCenterTextWhenStretched();

    public abstract ShapeTransform createShapeTransform(Rectangle var1);

    public abstract boolean canBeStretched();

    public abstract void layoutComp(SingleRowPassInfo var1);

    public boolean isSideComponentOnTabs() {
        return false;
    }

    public abstract boolean isDragOut(TabLabel var1, int var2, int var3);

    public abstract boolean drawPartialOverflowTabs();

    public abstract int getScrollUnitIncrement(TabLabel var1);

    static class Right
    extends Vertical {
        Right(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, -this.myTabs.myHeaderFitSize.width, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Right(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength - 1, length);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.layoutSize.width - this.myTabs.myHeaderFitSize.width - data.insets.right;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(data.layoutSize.width - this.myTabs.myHeaderFitSize.width, this.myTabs.getHeight() - data.insets.bottom - data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.width - 1, data.moreRectAxisSize - 1);
        }
    }

    static class Left
    extends Vertical {
        Left(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, this.myTabs.myHeaderFitSize.width + 1, 0, 0, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Left(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength, length);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.left;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(data.insets.left + JBTabsImpl.getSelectionTabVShift(), this.myTabs.getHeight() - data.insets.bottom - data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.width - 1, data.moreRectAxisSize - 1);
        }
    }

    static abstract class Vertical
    extends SingleRowLayoutStrategy {
        protected Vertical(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            return (double)Math.abs(deltaX) > (double)tabLabel.getHeight() * TabLayout.getDragOutMultiplier();
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return false;
        }

        @Override
        int getMoreRectAxisSize() {
            return AllIcons.General.MoreTabs.getIconHeight() + 4;
        }

        @Override
        public boolean canBeStretched() {
            return false;
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            return this.myTabs.getHeight() - data.insets.top - data.insets.bottom;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return labelPrefSize.height;
        }

        @Override
        public int getMinPosition(Rectangle bounds) {
            return (int)bounds.getMinY();
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            int maxY = (int)bounds.getMaxY();
            return this.myTabs.isEditorTabs() ? maxY - 1 : maxY;
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.myHeaderFitSize.width;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return false;
        }

        @Override
        public int getScrollUnitIncrement(TabLabel label) {
            return label.getPreferredSize().height;
        }
    }

    static class Bottom
    extends Horizontal {
        Bottom(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, 0, -(this.myTabs.myHeaderFitSize.height + 1));
            }
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return this.myTabs.getSize().height - data.insets.bottom - this.myTabs.myHeaderFitSize.height - 1;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(this.myTabs.getWidth() - data.insets.right - data.moreRectAxisSize + 2, this.getFixedPosition(data), data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.height - 1);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Bottom(labelRec);
        }
    }

    static class Top
    extends Horizontal {
        Top(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isSideComponentOnTabs() {
            return !this.myTabs.isSideComponentVertical() && this.myTabs.isSideComponentOnTabs();
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Top(labelRec);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            int x = this.myTabs.isEditorTabs() ? data.layoutSize.width - data.moreRectAxisSize - 1 : data.position + (data.lastGhostVisible ? data.lastGhost.width : 0);
            return new Rectangle(x, data.insets.top + JBTabsImpl.getSelectionTabVShift(), data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.height - 1);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                JComponent vToolbar = (JComponent)data.vToolbar.get();
                int vToolbarWidth = vToolbar != null ? vToolbar.getPreferredSize().width : 0;
                int vSeparatorWidth = vToolbarWidth > 0 ? 1 : 0;
                int x = vToolbarWidth > 0 ? vToolbarWidth + vSeparatorWidth : 0;
                JComponent hToolbar = (JComponent)data.hToolbar.get();
                int hToolbarHeight = !this.myTabs.isSideComponentOnTabs() && hToolbar != null ? hToolbar.getPreferredSize().height : 0;
                int y = this.myTabs.myHeaderFitSize.height + (this.myTabs.isEditorTabs() ? 0 : 1) + (hToolbarHeight > 0 ? hToolbarHeight - 2 : 0);
                JComponent comp = (JComponent)data.comp.get();
                if (hToolbar != null) {
                    Rectangle compBounds = this.myTabs.layoutComp(x, y, comp, 0, 0);
                    if (this.myTabs.isSideComponentOnTabs()) {
                        int toolbarX = (data.moreRect != null ? (int)data.moreRect.getMaxX() : data.position) + this.myTabs.getToolbarInset();
                        Rectangle rec = new Rectangle(toolbarX, data.insets.top + 1, this.myTabs.getSize().width - data.insets.left - toolbarX, this.myTabs.myHeaderFitSize.height);
                        this.myTabs.layout(hToolbar, rec);
                    } else {
                        int toolbarHeight = hToolbar.getPreferredSize().height - 2;
                        this.myTabs.layout(hToolbar, compBounds.x, compBounds.y - toolbarHeight - 1, compBounds.width, toolbarHeight);
                    }
                } else if (vToolbar != null) {
                    if (this.myTabs.isSideComponentBefore()) {
                        Rectangle compBounds = this.myTabs.layoutComp(x, y, comp, 0, 0);
                        this.myTabs.layout(vToolbar, compBounds.x - vToolbarWidth - vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    } else {
                        int width = vToolbarWidth > 0 ? this.myTabs.getWidth() - vToolbarWidth - vSeparatorWidth : this.myTabs.getWidth();
                        Rectangle compBounds = this.myTabs.layoutComp(new Rectangle(0, y, width, this.myTabs.getHeight()), comp, 0, 0);
                        this.myTabs.layout(vToolbar, compBounds.x + compBounds.width + vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    }
                } else {
                    this.myTabs.layoutComp(x, y, comp, 0, 0);
                }
            }
        }
    }

    static abstract class Horizontal
    extends SingleRowLayoutStrategy {
        protected Horizontal(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return true;
        }

        @Override
        public boolean canBeStretched() {
            return true;
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            return (double)Math.abs(deltaY) > (double)tabLabel.getHeight() * TabLayout.getDragOutMultiplier();
        }

        @Override
        public int getMoreRectAxisSize() {
            return AllIcons.General.MoreTabs.getIconWidth() + 15;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            JComponent hToolbar = (JComponent)data.hToolbar.get();
            if (hToolbar != null) {
                return this.myTabs.getWidth() - data.insets.left - data.insets.right - hToolbar.getMinimumSize().width;
            }
            return this.myTabs.getWidth() - data.insets.left - data.insets.right;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return this.myTabs.isEditorTabs() ? (labelPrefSize.width < 50 ? 50 : labelPrefSize.width) : labelPrefSize.width;
        }

        @Override
        public int getMinPosition(Rectangle bounds) {
            return (int)bounds.getX();
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            return (int)bounds.getMaxX();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.myHeaderFitSize.height;
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(position, fixedPos + (this.myTabs.getTabsPosition() == JBTabsPosition.bottom ? 1 : 0), length, fixedFitLength);
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            return data.insets.left;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return true;
        }

        @Override
        public int getScrollUnitIncrement(TabLabel label) {
            return 10;
        }
    }
}

