/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpParser
implements PsiParser,
LightPsiParser {
    private static final TokenSet PROPERTY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER, RegExpTT.COMMA, RegExpTT.NAME, RegExpTT.RBRACE});
    private final EnumSet<RegExpCapability> myCapabilities;

    public RegExpParser(EnumSet<RegExpCapability> capabilities) {
        this.myCapabilities = capabilities;
    }

    public void parseLight(IElementType root, PsiBuilder builder2) {
        PsiBuilder.Marker rootMarker = builder2.mark();
        do {
            this.parsePattern(builder2);
            if (builder2.eof()) break;
            RegExpParser.patternExpected(builder2);
        } while (!builder2.eof());
        rootMarker.done(root);
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
        if (root == null) {
            RegExpParser.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            RegExpParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root, builder2);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            RegExpParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private void parsePattern(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        this.parseBranch(builder2);
        while (builder2.getTokenType() == RegExpTT.UNION) {
            builder2.advanceLexer();
            this.parseBranch(builder2);
        }
        marker.done(RegExpElementTypes.PATTERN);
    }

    private void parseBranch(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        while (!this.parseAtom(builder2)) {
            IElementType token = builder2.getTokenType();
            if (token == RegExpTT.GROUP_END || token == RegExpTT.UNION || token == null) {
                marker.done(RegExpElementTypes.BRANCH);
                return;
            }
            RegExpParser.patternExpected(builder2);
        }
        while (this.parseAtom(builder2)) {
        }
        marker.done(RegExpElementTypes.BRANCH);
    }

    private boolean parseAtom(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseGroup(builder2);
        if (marker == null) {
            return false;
        }
        PsiBuilder.Marker marker2 = marker.precede();
        if (this.parseQuantifier(builder2)) {
            marker2.done(RegExpElementTypes.CLOSURE);
        } else {
            marker2.drop();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseQuantifier(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        if (builder2.getTokenType() == RegExpTT.LBRACE) {
            PsiBuilder.Marker numberMark;
            boolean minOmitted;
            builder2.advanceLexer();
            boolean bl = minOmitted = builder2.getTokenType() == RegExpTT.COMMA && this.myCapabilities.contains((Object)RegExpCapability.OMIT_NUMBERS_IN_QUANTIFIERS);
            if (minOmitted) {
                builder2.advanceLexer();
            } else if (builder2.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder2.mark();
                builder2.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
            } else {
                builder2.error("Number expected");
            }
            if (builder2.getTokenType() == RegExpTT.RBRACE) {
                builder2.advanceLexer();
                RegExpParser.parseQuantifierType(builder2);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (!minOmitted) {
                RegExpParser.checkMatches(builder2, RegExpTT.COMMA, "',' expected");
            }
            if (builder2.getTokenType() == RegExpTT.RBRACE) {
                builder2.advanceLexer();
                RegExpParser.parseQuantifierType(builder2);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (builder2.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder2.mark();
                builder2.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
                RegExpParser.checkMatches(builder2, RegExpTT.RBRACE, "'}' expected");
                RegExpParser.parseQuantifierType(builder2);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            builder2.error("'}' or number expected");
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        if (RegExpTT.QUANTIFIERS.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            RegExpParser.parseQuantifierType(builder2);
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        marker.drop();
        return false;
    }

    private static void parseQuantifierType(PsiBuilder builder2) {
        if (builder2.getTokenType() == RegExpTT.PLUS || builder2.getTokenType() == RegExpTT.QUEST) {
            builder2.advanceLexer();
        } else if (RegExpTT.QUANTIFIERS.contains(builder2.getTokenType())) {
            builder2.error("Dangling metacharacter");
        }
    }

    private PsiBuilder.Marker parseClass(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == RegExpTT.CARET) {
            builder2.advanceLexer();
        }
        this.parseClassIntersection(builder2);
        RegExpParser.checkMatches(builder2, RegExpTT.CLASS_END, "Unclosed character class");
        marker.done(RegExpElementTypes.CLASS);
        return marker;
    }

    private void parseClassIntersection(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        boolean left = this.parseClassdef(builder2);
        if (RegExpTT.ANDAND != builder2.getTokenType()) {
            marker.drop();
            return;
        }
        while (RegExpTT.ANDAND == builder2.getTokenType()) {
            builder2.advanceLexer();
            boolean right = this.parseClassdef(builder2);
            if (!left && !right) {
                builder2.error("character class expected");
            }
            left = right;
        }
        marker.done(RegExpElementTypes.INTERSECTION);
    }

    private boolean parseClassdef(PsiBuilder builder2) {
        int count = 0;
        while (true) {
            IElementType token;
            if ((token = builder2.getTokenType()) == RegExpTT.CLASS_BEGIN) {
                this.parseClass(builder2);
            } else if (token == RegExpTT.BRACKET_EXPRESSION_BEGIN) {
                RegExpParser.parseBracketExpression(builder2);
            } else if (token == RegExpTT.MYSQL_CHAR_BEGIN) {
                RegExpParser.parseMysqlCharExpression(builder2);
            } else if (token == RegExpTT.MYSQL_CHAR_EQ_BEGIN) {
                RegExpParser.parseMysqlCharEqExpression(builder2);
            } else if (RegExpTT.CHARACTERS.contains(token) || token == RegExpTT.NAMED_CHARACTER) {
                this.parseCharacterRange(builder2);
            } else if (token == RegExpTT.CHAR_CLASS) {
                PsiBuilder.Marker m = builder2.mark();
                builder2.advanceLexer();
                m.done(RegExpElementTypes.SIMPLE_CLASS);
            } else if (token == RegExpTT.PROPERTY) {
                this.parseProperty(builder2);
            } else {
                return count > 0;
            }
            ++count;
        }
    }

    private static void parseBracketExpression(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == RegExpTT.CARET) {
            builder2.advanceLexer();
        }
        RegExpParser.checkMatches(builder2, RegExpTT.NAME, "POSIX character class name expected");
        RegExpParser.checkMatches(builder2, RegExpTT.BRACKET_EXPRESSION_END, "Unclosed POSIX bracket expression");
        marker.done(RegExpElementTypes.POSIX_BRACKET_EXPRESSION);
    }

    private static void parseMysqlCharExpression(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == RegExpTT.NAME) {
            builder2.advanceLexer();
        } else {
            RegExpParser.checkMatches(builder2, RegExpTT.CHARACTER, "Character or MySQL character name expected");
        }
        RegExpParser.checkMatches(builder2, RegExpTT.MYSQL_CHAR_END, "Unclosed MySQL character expression");
        marker.done(RegExpElementTypes.MYSQL_CHAR_EXPRESSION);
    }

    private static void parseMysqlCharEqExpression(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        RegExpParser.checkMatches(builder2, RegExpTT.CHARACTER, "Character expected");
        RegExpParser.checkMatches(builder2, RegExpTT.MYSQL_CHAR_EQ_END, "Unclosed MySQL character equivalence class");
        marker.done(RegExpElementTypes.MYSQL_CHAR_EQ_EXPRESSION);
    }

    private void parseCharacterRange(PsiBuilder builder2) {
        PsiBuilder.Marker rangeMarker = builder2.mark();
        RegExpParser.parseCharacter(builder2);
        if (builder2.getTokenType() == RegExpTT.MINUS) {
            PsiBuilder.Marker minusMarker = builder2.mark();
            builder2.advanceLexer();
            IElementType t = builder2.getTokenType();
            if (RegExpTT.CHARACTERS.contains(t) || t == RegExpTT.NAMED_CHARACTER) {
                minusMarker.drop();
                RegExpParser.parseCharacter(builder2);
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            } else if (t == RegExpTT.CLASS_END) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
            } else if (t == RegExpTT.CLASS_BEGIN) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
                this.parseClassdef(builder2);
            } else {
                minusMarker.drop();
                builder2.error("Illegal character range");
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            }
        } else {
            rangeMarker.drop();
        }
    }

    @Nullable
    private PsiBuilder.Marker parseGroup(PsiBuilder builder2) {
        IElementType type = builder2.getTokenType();
        PsiBuilder.Marker marker = builder2.mark();
        if (RegExpTT.GROUPS.contains(type)) {
            builder2.advanceLexer();
            this.parseGroupEnd(builder2);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.SET_OPTIONS) {
            PsiBuilder.Marker o;
            builder2.advanceLexer();
            if (builder2.getTokenType() == RegExpTT.OPTIONS_ON) {
                o = builder2.mark();
                builder2.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder2.getTokenType() == RegExpTT.OPTIONS_OFF) {
                o = builder2.mark();
                builder2.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder2.getTokenType() == RegExpTT.COLON) {
                builder2.advanceLexer();
                this.parseGroupEnd(builder2);
                marker.done(RegExpElementTypes.GROUP);
            } else {
                RegExpParser.checkMatches(builder2, RegExpTT.GROUP_END, "Unclosed options group");
                marker.done(RegExpElementTypes.SET_OPTIONS);
            }
        } else if (RegExpTT.CHARACTERS.contains(type) || type == RegExpTT.NAMED_CHARACTER) {
            marker.drop();
            RegExpParser.parseCharacter(builder2);
        } else if (type == RegExpTT.NUMBER || type == RegExpTT.COMMA) {
            builder2.remapCurrentToken(RegExpTT.CHARACTER);
            builder2.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        } else if (RegExpTT.BOUNDARIES.contains(type)) {
            builder2.advanceLexer();
            marker.done(RegExpElementTypes.BOUNDARY);
        } else if (type == RegExpTT.BACKREF) {
            builder2.advanceLexer();
            marker.done(RegExpElementTypes.BACKREF);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP || type == RegExpTT.RUBY_NAMED_GROUP || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP) {
            builder2.advanceLexer();
            RegExpParser.checkMatches(builder2, RegExpTT.NAME, "Group name expected");
            RegExpParser.checkMatches(builder2, type == RegExpTT.RUBY_QUOTED_NAMED_GROUP ? RegExpTT.QUOTE : RegExpTT.GT, "Unclosed group name");
            this.parseGroupEnd(builder2);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder2, marker, RegExpTT.GROUP_END);
        } else if (type == RegExpTT.RUBY_NAMED_GROUP_REF || type == RegExpTT.RUBY_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder2, marker, RegExpTT.GT);
        } else if (type == RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder2, marker, RegExpTT.QUOTE);
        } else if (type == RegExpTT.PYTHON_COND_REF) {
            builder2.advanceLexer();
            if (builder2.getTokenType() == RegExpTT.NAME || builder2.getTokenType() == RegExpTT.NUMBER) {
                builder2.advanceLexer();
            } else {
                builder2.error("Group name or number expected");
            }
            RegExpParser.checkMatches(builder2, RegExpTT.GROUP_END, "Unclosed group reference");
            this.parseBranch(builder2);
            if (builder2.getTokenType() == RegExpTT.UNION) {
                builder2.advanceLexer();
                this.parseBranch(builder2);
            }
            RegExpParser.checkMatches(builder2, RegExpTT.GROUP_END, "Unclosed conditional");
            marker.done(RegExpElementTypes.PY_COND_REF);
        } else if (type == RegExpTT.PROPERTY) {
            marker.drop();
            this.parseProperty(builder2);
        } else if (type == RegExpTT.DOT || type == RegExpTT.CHAR_CLASS) {
            builder2.advanceLexer();
            marker.done(RegExpElementTypes.SIMPLE_CLASS);
        } else {
            if (type == RegExpTT.CLASS_BEGIN) {
                marker.drop();
                return this.parseClass(builder2);
            }
            marker.drop();
            return null;
        }
        return marker;
    }

    private void parseGroupEnd(PsiBuilder builder2) {
        this.parsePattern(builder2);
        RegExpParser.checkMatches(builder2, RegExpTT.GROUP_END, "Unclosed group");
    }

    private static void parseNamedGroupRef(PsiBuilder builder2, PsiBuilder.Marker marker, IElementType type) {
        builder2.advanceLexer();
        RegExpParser.checkMatches(builder2, RegExpTT.NAME, "Group name expected");
        RegExpParser.checkMatches(builder2, type, "Unclosed group reference");
        marker.done(RegExpElementTypes.NAMED_GROUP_REF);
    }

    private static boolean isLetter(CharSequence text2) {
        if (text2 == null) {
            return false;
        }
        assert (text2.length() == 1);
        char c2 = text2.charAt(0);
        return AsciiUtil.isLetter(c2);
    }

    private void parseProperty(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == RegExpTT.CATEGORY_SHORT_HAND) {
            if (!this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND)) {
                builder2.error("Category shorthand not allowed in this regular expression dialect");
            }
            builder2.advanceLexer();
        } else if (builder2.getTokenType() == RegExpTT.CHARACTER && RegExpParser.isLetter(builder2.getTokenText())) {
            builder2.error(this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? "Illegal category shorthand" : "'{' expected");
            builder2.advanceLexer();
        } else if (RegExpParser.checkMatches(builder2, RegExpTT.LBRACE, this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? "'{' or category shorthand expected" : "'{' expected")) {
            if (builder2.getTokenType() == RegExpTT.CARET) {
                if (!this.myCapabilities.contains((Object)RegExpCapability.CARET_NEGATED_PROPERTIES)) {
                    builder2.error("Negating a property not allowed in this regular expression dialect");
                }
                builder2.advanceLexer();
            }
            if (builder2.getTokenType() == RegExpTT.NAME) {
                builder2.advanceLexer();
                if (this.myCapabilities.contains((Object)RegExpCapability.PROPERTY_VALUES) && builder2.getTokenType() == RegExpTT.EQ) {
                    builder2.advanceLexer();
                    RegExpParser.checkMatches(builder2, RegExpTT.NAME, "Property value expected");
                }
                RegExpParser.checkMatches(builder2, RegExpTT.RBRACE, "Unclosed property");
            } else {
                if (builder2.getTokenType() == RegExpTT.RBRACE) {
                    builder2.error("Empty property");
                    builder2.advanceLexer();
                } else {
                    builder2.error("Property name expected");
                }
                while (PROPERTY_TOKENS.contains(builder2.getTokenType())) {
                    builder2.advanceLexer();
                }
            }
        }
        marker.done(RegExpElementTypes.PROPERTY);
    }

    private static void parseCharacter(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        if (builder2.getTokenType() == RegExpTT.NAMED_CHARACTER) {
            builder2.advanceLexer();
            RegExpParser.checkMatches(builder2, RegExpTT.LBRACE, "'{' expected");
            RegExpParser.checkMatches(builder2, RegExpTT.NAME, "Unicode character name expected");
            RegExpParser.checkMatches(builder2, RegExpTT.RBRACE, "'}' expected");
            marker.done(RegExpElementTypes.NAMED_CHARACTER);
        } else {
            builder2.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        }
    }

    private static void patternExpected(PsiBuilder builder2) {
        IElementType token = builder2.getTokenType();
        if (token == RegExpTT.GROUP_END) {
            builder2.error("Unmatched closing ')'");
        } else if (RegExpTT.QUANTIFIERS.contains(token) || token == RegExpTT.RBRACE || token == RegExpTT.CLASS_END) {
            builder2.error("Dangling metacharacter");
        } else {
            builder2.error("Pattern expected");
        }
        builder2.advanceLexer();
    }

    protected static boolean checkMatches(PsiBuilder builder2, IElementType token, @NotNull String message) {
        if (message == null) {
            RegExpParser.$$$reportNull$$$0(3);
        }
        if (builder2.getTokenType() == token) {
            builder2.advanceLexer();
            return true;
        }
        builder2.error(message);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

