/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexImporterMappingIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SharedIntMapForwardIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SnapshotInputMappingIndex;
import com.intellij.util.indexing.SnapshotInputMappings;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value, Input>
extends MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    private final AtomicBoolean myInMemoryMode;
    private final TIntObjectHashMap<Map<Key, Value>> myInMemoryKeysAndValues;
    private final SnapshotInputMappingIndex<Key, Value, Input> mySnapshotInputMappings;
    private final boolean myUpdateMappings;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, storage, VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value, Input>(extension) : null);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable SnapshotInputMappings<Key, Value, Input> snapshotInputMappings) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, storage, (ForwardIndex)(snapshotInputMappings != null ? new SharedIntMapForwardIndex(extension, snapshotInputMappings.getInputIndexStorageFile(), true) : VfsAwareMapReduceIndex.getForwardIndexMap(extension)), (ForwardIndexAccessor<Key, Value>)(snapshotInputMappings != null ? snapshotInputMappings.getForwardIndexAccessor() : VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)), snapshotInputMappings);
    }

    protected VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndexMap, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable SnapshotInputMappingIndex<Key, Value, Input> snapshotInputMappings) {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(5);
        }
        super(extension, storage, forwardIndexMap, forwardIndexAccessor, null);
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeysAndValues = new TIntObjectHashMap();
        SharedIndicesData.registerIndex((ID)this.myIndexId, extension);
        this.mySnapshotInputMappings = IndexImporterMappingIndex.wrap(snapshotInputMappings, extension);
        this.myUpdateMappings = snapshotInputMappings instanceof UpdatableSnapshotInputMappingIndex;
        this.installMemoryModeListener();
    }

    private static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(6);
        }
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled;
    }

    @NotNull
    protected InputData<Key, Value> mapInput(@Nullable Input content2) {
        InputData<Key, Value> data;
        boolean containsSnapshotData = true;
        if (this.mySnapshotInputMappings != null && content2 != null) {
            block10: {
                InputData<Key, Value> inputData;
                try {
                    data = this.mySnapshotInputMappings.readData(content2);
                    if (data == null) break block10;
                    inputData = data;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (inputData == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(7);
                }
                return inputData;
            }
            containsSnapshotData = !this.myUpdateMappings;
        }
        data = super.mapInput(content2);
        if (!containsSnapshotData && !UpdatableSnapshotInputMappingIndex.ignoreMappingIndexUpdate(content2)) {
            InputData<Key, Value> inputData;
            try {
                inputData = ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).putData(content2, data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (inputData == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(8);
            }
            return inputData;
        }
        InputData<Key, Value> inputData = data;
        if (inputData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(9);
        }
        return inputData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.mySnapshotInputMappings != null && !this.myInMemoryMode.get()) {
            InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
            if (inputDataDiffBuilder == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(10);
            }
            return inputDataDiffBuilder;
        }
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                Map keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId);
                if (keysAndValues != null) {
                    InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.getKeysDiffBuilderInMemoryMode(inputId, keysAndValues);
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (inputDataDiffBuilder == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(11);
                    }
                    return inputDataDiffBuilder;
                }
            }
        }
        InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
        if (inputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(12);
        }
        return inputDataDiffBuilder;
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilderInMemoryMode(int inputId, @NotNull Map<Key, Value> keysAndValues) {
        if (keysAndValues == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(13);
        }
        MapInputDataDiffBuilder mapInputDataDiffBuilder = new MapInputDataDiffBuilder(inputId, keysAndValues);
        if (mapInputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(14);
        }
        return mapInputDataDiffBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (data == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(15);
        }
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                this.myInMemoryKeysAndValues.put(inputId, (Object)data.getKeyValues());
            }
        } else {
            super.updateForwardIndex(inputId, data);
        }
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(16);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(17);
        }
        return IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientDataForFile(int inputId) {
        Lock lock = this.getWriteLock();
        lock.lock();
        try {
            Map keyValueMap;
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
            }
            if (keyValueMap == null) {
                return;
            }
            try {
                this.removeTransientDataForInMemoryKeys(inputId, keyValueMap);
                InputDataDiffBuilder<Key, Value> builder2 = this.getKeysDiffBuilder(inputId);
                if (builder2 instanceof CollectionInputDataDiffBuilder) {
                    Collection keyCollectionFromDisk = ((CollectionInputDataDiffBuilder)builder2).getSeq();
                    if (keyCollectionFromDisk != null) {
                        this.removeTransientDataForKeys(inputId, keyCollectionFromDisk);
                    }
                } else {
                    THashSet diskKeySet = new THashSet();
                    builder2.differentiate(Collections.emptyMap(), (key, value, inputId1) -> {}, (key, value, inputId1) -> {}, (arg_0, arg_1) -> VfsAwareMapReduceIndex.lambda$removeTransientDataForFile$2((Set)diskKeySet, arg_0, arg_1));
                    this.removeTransientDataForKeys(inputId, (Collection<? extends Key>)diskKeySet);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Key, ? extends Value> map2) {
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(18);
        }
        this.removeTransientDataForKeys(inputId, map2.keySet());
    }

    public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Key> keys) {
        if (keys == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(19);
        }
        MemoryIndexStorage memoryIndexStorage = (MemoryIndexStorage)this.getStorage();
        for (Key key : keys) {
            memoryIndexStorage.clearMemoryMapForId(key, inputId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(21);
        }
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            boolean bl = ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map2;
        try {
            map2 = Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(22);
        }
        return map2;
    }

    @Nullable
    private Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        Map map2;
        if (this.myInMemoryMode.get() && (map2 = (Map)this.myInMemoryKeysAndValues.get(fileId)) != null) {
            return map2;
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndexMap().get(Integer.valueOf(fileId));
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(serializedInputData);
        }
        if (this.myExtension instanceof SingleEntryFileBasedIndexExtension) {
            Integer key = fileId;
            Map[] result2 = new Map[]{Collections.emptyMap()};
            ValueContainer container = this.getData(key);
            container.forEach((id, value) -> {
                result2[0] = Collections.singletonMap(key, value);
                return false;
            });
            return result2[0];
        }
        LOG.error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(23);
        }
        Runnable action2 = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)application, action2);
        } else {
            action2.run();
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            try {
                ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).flush();
        }
    }

    protected void doDispose() throws StorageException {
        super.doDispose();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static <Key, Value> ForwardIndexAccessor<Key, Value> getForwardIndexAccessor(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(24);
        }
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        return new MapForwardIndexAccessor(new InputMapExternalizer<Key, Value>(indexExtension));
    }

    @Nullable
    private static ForwardIndex getForwardIndexMap(@NotNull IndexExtension<?, ?, ?> indexExtension) throws IOException {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(25);
        }
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)indexExtension.getName());
        return new PersistentMapBasedForwardIndex(indexStorageFile, false);
    }

    private static boolean shouldCreateForwardIndex(@NotNull IndexExtension<?, ?, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(26);
        }
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension)) {
            return false;
        }
        if (indexExtension instanceof CustomInputsIndexFileBasedIndexExtension) {
            LOG.error("Index `" + indexExtension.getName() + "` will be created without forward index");
            return false;
        }
        return true;
    }

    private void installMemoryModeListener() {
        IndexStorage storage = this.getStorage();
        if (storage instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues.clear();
                    }
                }
            });
        }
    }

    private static /* synthetic */ void lambda$removeTransientDataForFile$2(Set diskKeySet, Object key, int inputId1) throws StorageException {
        diskKeySet.add(key);
    }

    static {
        if (!DebugAssertions.DEBUG) {
            Application app = ApplicationManager.getApplication();
            DebugAssertions.DEBUG = (app.isEAP() || app.isInternal()) && !ApplicationInfoImpl.isInStressTest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysAndValues";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilderInMemoryMode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSnapshotMapping";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKeysDiffBuilderInMemoryMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedStateForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForInMemoryKeys";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexAccessor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexMap";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateForwardIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

