/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class ListCellRendererWithRightAlignedComponent<T>
implements ListCellRenderer<T> {
    private final ListCellRenderer<T> myLeftRenderer;
    private final ListCellRenderer<T> myRightRenderer;
    private final JComponent myPanel = new CellRendererPanel();
    private String myLeftText;
    private String myRightText;
    private Icon myIcon;
    private Icon myRightIcon;
    private Color myLeftForeground;
    private Color myRightForeground;

    public ListCellRendererWithRightAlignedComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myLeftRenderer = SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setText(this.myLeftText);
            label2.setIcon(this.myIcon);
        });
        this.myRightRenderer = SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setText(StringUtil.notNullize((String)this.myRightText));
            label2.setIcon(this.myRightIcon);
        });
    }

    protected abstract void customize(T var1);

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list2, T value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myPanel.removeAll();
        this.myLeftText = null;
        this.myRightText = null;
        this.myIcon = null;
        this.myRightForeground = null;
        this.customize(value);
        Component left = this.myLeftRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        Component right = this.myRightRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        if (!isSelected) {
            left.setForeground(this.myLeftForeground);
            right.setForeground(this.myRightForeground);
        }
        this.myPanel.add(left, "Center");
        this.myPanel.add(right, "East");
        return this.myPanel;
    }

    protected Icon getRightIcon() {
        return this.myRightIcon;
    }

    protected void setRightIcon(Icon rightIcon) {
        this.myRightIcon = rightIcon;
    }

    protected final void setLeftText(String text2) {
        this.myLeftText = text2;
    }

    protected final void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    protected final void setRightText(String text2) {
        this.myRightText = text2;
    }

    protected final void setLeftForeground(Color color) {
        this.myLeftForeground = color;
    }

    protected final void setRightForeground(Color color) {
        this.myRightForeground = color;
    }
}

