/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.ColorThief;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class ToolWindowIcon
implements RetrievableIcon,
MenuBarIconProvider {
    private static final Map<Icon, int[]> ourCache = new HashMap<Icon, int[]>();
    private final Icon myIcon;
    private final boolean myUseOriginal;
    private final String myToolWindowId;

    public ToolWindowIcon(Icon icon, String toolWindowId) {
        this.myIcon = icon;
        this.myToolWindowId = toolWindowId;
        if (Arrays.asList("Event Log", "Problems").contains(toolWindowId)) {
            this.myUseOriginal = true;
        } else {
            int[] rgb = ColorThief.getColor(ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)icon)));
            Color color = rgb != null && rgb.length == 3 ? new Color(rgb[0], rgb[1], rgb[2]) : null;
            this.myUseOriginal = color == null || color.equals(Gray._108) || color.equals(ColorUtil.fromHex((String)"AFB1B3"));
        }
    }

    public Icon retrieveIcon() {
        return this.myIcon;
    }

    public Icon getMenuBarIcon(boolean isDark) {
        return new ToolWindowIcon(IconLoader.getMenuBarIcon((Icon)this.myIcon, (boolean)isDark), this.myToolWindowId);
    }

    public void paintIcon(Component c2, Graphics g, int x, int y) {
        if (!Registry.is((String)"ide.convert.tool.window.icons") || this.myUseOriginal) {
            this.myIcon.paintIcon(c2, g, x, y);
            return;
        }
        int[] dominant = ToolWindowIcon.getDominantColor(this.myIcon);
        if (dominant == null || dominant.length != 3) {
            this.myIcon.paintIcon(c2, g, x, y);
            return;
        }
        double brightnessDominant = 0.299 * (double)dominant[0] + 0.587 * (double)dominant[1] + 0.114 * (double)dominant[2];
        final double k = brightnessDominant / (double)ToolWindowIcon.getBaseGray();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                int a = rgb >> 24 & 0xFF;
                double brightness = 0.299 * (double)(rgb >> 16 & 0xFF) + 0.587 * (double)(rgb >> 8 & 0xFF) + 0.114 * (double)(rgb & 0xFF);
                double d = k == 0.0 ? 255.0 : brightness / k;
                try {
                    return (a & 0xFF) << 24 | ((int)d & 0xFF) << 16 | ((int)d & 0xFF) << 8 | (int)d & 0xFF;
                }
                catch (Exception e) {
                    return 0;
                }
            }
        };
        ScaleContext ctx = ScaleContext.create((Graphics2D)((Graphics2D)g));
        Image rawImage = ImageUtil.filter((Image)IconUtil.toImage((Icon)this.myIcon, (ScaleContext)ctx), (ImageFilter)filter);
        Image hidpiImage = ImageUtil.ensureHiDPI((Image)rawImage, (ScaleContext)ctx);
        UIUtil.drawImage((Graphics)g, (Image)hidpiImage, (int)x, (int)y, null);
    }

    private static int getBaseGray() {
        return UIUtil.isUnderDarcula() ? 177 : 108;
    }

    private static int[] getDominantColor(Icon icon) {
        int[] rgb = ourCache.get(icon);
        if (rgb == null) {
            rgb = ColorThief.getColor(ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)icon)));
            ourCache.put(icon, rgb);
        }
        return rgb;
    }

    public int getIconWidth() {
        return this.myIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myIcon.getIconHeight();
    }

    static {
        LafManager.getInstance().addLafManagerListener(x -> ourCache.clear());
    }
}

