/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EventLogTestWhitelistPersistence {
    private static final String TEST_RULE = "{util#fus_test_mode}";

    public static void addGroupWithCustomRules(@NotNull String recorderId, @NotNull String groupId, @NotNull String rules) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(2);
        }
        String content2 = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        FUStatisticsWhiteListGroupsService.WLGroup newGroup = (FUStatisticsWhiteListGroupsService.WLGroup)new GsonBuilder().create().fromJson(content2, FUStatisticsWhiteListGroupsService.WLGroup.class);
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, newGroup);
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull String groupId) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(3);
        }
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(4);
        }
        FUStatisticsWhiteListGroupsService.WLGroup group = EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, group);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull FUStatisticsWhiteListGroupsService.WLGroup group) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(5);
        }
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(6);
        }
        EventLogWhitelistPersistence persistence = new EventLogWhitelistPersistence(recorderId);
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = EventLogTestWhitelistPersistence.loadTestWhitelist(persistence);
        whitelist.groups.stream().filter(g -> StringUtil.equals((CharSequence)g.id, (CharSequence)group.id)).findFirst().ifPresent(whitelist.groups::remove);
        whitelist.groups.add(group);
        File file2 = persistence.getWhiteListFile();
        FileUtil.writeToFile((File)file2, (String)new Gson().toJson((Object)whitelist));
    }

    @NotNull
    private static FUStatisticsWhiteListGroupsService.WLGroups loadTestWhitelist(@NotNull EventLogWhitelistPersistence persistence) {
        FUStatisticsWhiteListGroupsService.WLGroups loaded;
        String existing;
        if (persistence == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(existing = persistence.getCachedWhiteList())) && (loaded = FUStatisticsWhiteListGroupsService.parseWhiteListContent(existing)) != null) {
            FUStatisticsWhiteListGroupsService.WLGroups wLGroups = loaded;
            if (wLGroups == null) {
                EventLogTestWhitelistPersistence.$$$reportNull$$$0(8);
            }
            return wLGroups;
        }
        FUStatisticsWhiteListGroupsService.WLGroups wLGroups = new FUStatisticsWhiteListGroupsService.WLGroups();
        if (wLGroups == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(9);
        }
        return wLGroups;
    }

    @NotNull
    private static FUStatisticsWhiteListGroupsService.WLGroup createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(10);
        }
        if (eventData == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(11);
        }
        FUStatisticsWhiteListGroupsService.WLGroup group = new FUStatisticsWhiteListGroupsService.WLGroup();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new FUStatisticsWhiteListGroupsService.WLVersion("1", null));
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        rule.event_id = ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE});
        HashMap dataRules = new HashMap();
        for (String datum : eventData) {
            dataRules.put(datum, ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE}));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        FUStatisticsWhiteListGroupsService.WLGroup wLGroup = group;
        if (wLGroup == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(12);
        }
        return wLGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestWhitelist";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addGroupWithCustomRules";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadTestWhitelist";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

