/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UITheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Nullable;

public final class UIThemeProvider
implements PluginAware {
    public static final ExtensionPointName<UIThemeProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.themeProvider");
    private PluginDescriptor myDescriptor;
    @Attribute(value="path")
    @RequiredElement
    public String path;
    @Attribute(value="id")
    @RequiredElement
    public String id;

    @Nullable
    public UITheme createTheme() {
        try {
            ClassLoader loader = this.myDescriptor != null ? this.myDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
            return UITheme.loadFromJson(loader.getResourceAsStream(this.path), this.id, loader);
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn("error loading UITheme '" + this.path + "', pluginId=" + (this.myDescriptor != null ? this.myDescriptor.getPluginId().getIdString() : "(none)"), (Throwable)e);
            return null;
        }
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myDescriptor = pluginDescriptor;
    }
}

