/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionWithRoot
extends WSLDistribution {
    private static final AtomicNotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = AtomicNotNullLazyValue.createValue(() -> {
        HashMap<String, String> result2 = new HashMap<String, String>();
        String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
        List distributions = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
        WSLUtil.LOG.debug("Processing Lxss registry: " + distributions.size());
        for (String distribution : distributions) {
            String name = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"DistributionName");
            String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"BasePath");
            WSLUtil.LOG.debug(name + ": " + path);
            if (path == null) continue;
            result2.put(name, path + "\\rootfs");
        }
        return Collections.unmodifiableMap(result2);
    });
    @Nullable
    private final String myWslRootInHost;

    public WSLDistributionWithRoot(@NotNull WSLDistribution wslDistribution) {
        if (wslDistribution == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(0);
        }
        super(wslDistribution);
        String wslRootInHost = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
        if (wslRootInHost == null) {
            WSLUtil.LOG.warn("WSL (" + wslDistribution.getPresentableName() + ") rootfs is null");
        } else if (!FileUtil.exists((String)wslRootInHost)) {
            WSLUtil.LOG.warn("WSL rootfs doesn't exist: " + wslRootInHost);
            wslRootInHost = null;
        }
        this.myWslRootInHost = wslRootInHost;
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        if (windowsPath == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(1);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)windowsPath);
        if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)canonicalPath, (boolean)true)) {
            return FileUtil.toSystemIndependentName((String)canonicalPath.substring(this.myWslRootInHost.length()));
        }
        return super.getWslPath(canonicalPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(2);
        }
        if ((windowsPath = super.getWindowsPath(wslPath)) != null) {
            return windowsPath;
        }
        if (this.myWslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(this.myWslRootInHost + FileUtil.toCanonicalPath((String)wslPath)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslDistribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/wsl/WSLDistributionWithRoot";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWslPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWindowsPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

