/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final Set<IntentionActionWithTextCaching> myIntentions;
    private final Set<IntentionActionWithTextCaching> myErrorFixes;
    private final Set<IntentionActionWithTextCaching> myInspectionFixes;
    private final Set<IntentionActionWithTextCaching> myGutters;
    private final Set<IntentionActionWithTextCaching> myNotifications;
    private int myOffset;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            IntentionAction action2 = o1.getAction();
            if (action2 instanceof IntentionActionDelegate) {
                return ((IntentionActionDelegate)action2).getDelegate().getClass();
            }
            return action2.getClass();
        }
    };

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(1);
        }
        this.myIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        Set<IntentionActionWithTextCaching> set = this.myIntentions;
        if (set == null) {
            CachedIntentions.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        Set<IntentionActionWithTextCaching> set = this.myErrorFixes;
        if (set == null) {
            CachedIntentions.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getInspectionFixes() {
        Set<IntentionActionWithTextCaching> set = this.myInspectionFixes;
        if (set == null) {
            CachedIntentions.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        Set<IntentionActionWithTextCaching> set = this.myGutters;
        if (set == null) {
            CachedIntentions.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        Set<IntentionActionWithTextCaching> set = this.myNotifications;
        if (set == null) {
            CachedIntentions.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CachedIntentions.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(8);
        }
        return project;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(10);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(11);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, false);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(12);
        }
        return cachedIntentions;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            CachedIntentions.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            CachedIntentions.$$$reportNull$$$0(14);
        }
        if (intentions == null) {
            CachedIntentions.$$$reportNull$$$0(15);
        }
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, true);
        CachedIntentions cachedIntentions = res2;
        if (cachedIntentions == null) {
            CachedIntentions.$$$reportNull$$$0(16);
        }
        return cachedIntentions;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        if (newInfo == null) {
            CachedIntentions.$$$reportNull$$$0(17);
        }
        this.myOffset = newInfo.getOffset();
        boolean changed = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed |= this.wrapActionsTo(newInfo.guttersToShow, this.myGutters, callUpdate);
        return changed |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    public boolean addActions(@NotNull ShowIntentionsPass.IntentionsInfo info) {
        if (info == null) {
            CachedIntentions.$$$reportNull$$$0(18);
        }
        boolean changed = this.addActionsTo(info.errorFixesToShow, this.myErrorFixes);
        changed |= this.addActionsTo(info.inspectionFixesToShow, this.myInspectionFixes);
        changed |= this.addActionsTo(info.intentionsToShow, this.myIntentions);
        changed |= this.addActionsTo(info.guttersToShow, this.myGutters);
        return changed |= this.addActionsTo(info.notificationActionsToShow, this.myNotifications);
    }

    private boolean addActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<? super IntentionActionWithTextCaching> cachedActions) {
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(19);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(20);
        }
        boolean changed = false;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            changed |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, this.myEditor));
        }
        return changed;
    }

    private boolean wrapActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean callUpdate) {
        if (newDescriptors == null) {
            CachedIntentions.$$$reportNull$$$0(21);
        }
        if (cachedActions == null) {
            CachedIntentions.$$$reportNull$$$0(22);
        }
        boolean changed = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!callUpdate);
            for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
                changed |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, null));
            }
        } else {
            Editor injectedEditor;
            PsiFile injectedFile;
            PsiFile hostElement;
            PsiFile element;
            int n;
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int n2 = n = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
            if (this.myFile instanceof PsiCompiledElement) {
                hostElement = element = this.myFile;
            } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                FileViewProvider viewProvider = this.myFile.getViewProvider();
                hostElement = element = viewProvider.findElementAt(n, viewProvider.getBaseLanguage());
            } else {
                hostElement = this.myFile.getViewProvider().findElementAt(n, this.myFile.getLanguage());
                element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, n);
            }
            if (element == null || element == hostElement) {
                injectedFile = this.myFile;
                injectedEditor = this.myEditor;
            } else {
                injectedFile = element.getContainingFile();
                injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            }
            Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
            while (iterator.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator.next();
                IntentionAction intentionAction = cachedAction.getAction();
                if (ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, intentionAction) || hostElement != element && (element == null || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, intentionAction))) continue;
                iterator.remove();
                changed = true;
            }
            THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
            for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
                IntentionActionWithTextCaching cachedAction;
                IntentionAction action3 = intentionActionDescriptor.getAction();
                if (element != null && element != hostElement && (!callUpdate || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action3))) {
                    cachedAction = this.wrapAction(intentionActionDescriptor, (PsiElement)element, injectedFile, injectedEditor);
                    wrappedNew.add(cachedAction);
                    changed |= cachedActions.add(cachedAction);
                    continue;
                }
                if (hostElement == null || callUpdate && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action3)) continue;
                cachedAction = this.wrapAction(intentionActionDescriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
                wrappedNew.add(cachedAction);
                changed |= cachedActions.add(cachedAction);
            }
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching intentionActionWithTextCaching = iterator2.next();
                if (wrappedNew.contains(intentionActionWithTextCaching)) continue;
                iterator2.remove();
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @Nullable PsiElement element, @Nullable PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor2 == null) {
            CachedIntentions.$$$reportNull$$$0(23);
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor2, (cached, action2) -> {
            this.removeActionFromCached((IntentionActionWithTextCaching)cached);
            this.markInvoked((IntentionAction)action2);
        });
        if (element == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                CachedIntentions.$$$reportNull$$$0(24);
            }
            return intentionActionWithTextCaching;
        }
        List<IntentionAction> options = descriptor2.getOptions(element, containingEditor);
        if (options == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                CachedIntentions.$$$reportNull$$$0(25);
            }
            return intentionActionWithTextCaching;
        }
        for (IntentionAction option : options) {
            boolean isInspectionFix;
            if (containingFile == null || containingEditor == null || this.myEditor == null ? !option.isAvailable(this.myProject, containingEditor, containingFile) && (containingEditor == this.myEditor || !option.isAvailable(this.myProject, this.myEditor, this.myFile)) : !ShowIntentionActionsHandler.availableFor(containingFile, containingEditor, option) && (containingEditor == this.myEditor || !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, option))) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option);
                continue;
            }
            cachedAction.addIntention(option);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            CachedIntentions.$$$reportNull$$$0(26);
        }
        return intentionActionWithTextCaching;
    }

    private void markInvoked(@NotNull IntentionAction action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(27);
        }
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action2);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(28);
        }
        this.myErrorFixes.remove(action2);
        this.myGutters.remove(action2);
        this.myInspectionFixes.remove(action2);
        this.myIntentions.remove(action2);
        this.myNotifications.remove(action2);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        result2.addAll(this.myIntentions);
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Collections.sort(result2, (o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        List<IntentionActionWithTextCaching> list2 = result2;
        if (list2 == null) {
            CachedIntentions.$$$reportNull$$$0(29);
        }
        return list2;
    }

    private int getWeight(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(30);
        }
        IntentionAction a = action2.getAction();
        int group = this.getGroup(action2).getPriority();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group + CachedIntentions.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case TOP: {
                return 20;
            }
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action2) {
        if (action2 == null) {
            CachedIntentions.$$$reportNull$$$0(31);
        }
        if (this.myErrorFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.ERROR;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(32);
            }
            return intentionGroup;
        }
        if (this.myInspectionFixes.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.INSPECTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(33);
            }
            return intentionGroup;
        }
        if (this.myNotifications.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.NOTIFICATION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(34);
            }
            return intentionGroup;
        }
        if (this.myGutters.contains(action2)) {
            IntentionGroup intentionGroup = IntentionGroup.GUTTER;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(35);
            }
            return intentionGroup;
        }
        if (action2.getAction() instanceof EmptyIntentionAction) {
            IntentionGroup intentionGroup = IntentionGroup.EMPTY_ACTION;
            if (intentionGroup == null) {
                CachedIntentions.$$$reportNull$$$0(36);
            }
            return intentionGroup;
        }
        IntentionGroup intentionGroup = IntentionGroup.OTHER;
        if (intentionGroup == null) {
            CachedIntentions.$$$reportNull$$$0(37);
        }
        return intentionGroup;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value) {
        Icon icon;
        if (value == null) {
            CachedIntentions.$$$reportNull$$$0(38);
        }
        if (value.getIcon() != null) {
            Icon icon2 = value.getIcon();
            if (icon2 == null) {
                CachedIntentions.$$$reportNull$$$0(39);
            }
            return icon2;
        }
        IntentionAction action2 = value.getAction();
        while (action2 instanceof IntentionActionDelegate) {
            action2 = ((IntentionActionDelegate)action2).getDelegate();
        }
        IntentionAction iconable = action2;
        if (action2 instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action2).getFix();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            Icon icon3 = icon;
            if (icon3 == null) {
                CachedIntentions.$$$reportNull$$$0(40);
            }
            return icon3;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action2)) {
            Icon icon4 = this.myErrorFixes.contains(value) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
            if (icon4 == null) {
                CachedIntentions.$$$reportNull$$$0(41);
            }
            return icon4;
        }
        if (this.myErrorFixes.contains(value)) {
            Icon icon5 = AllIcons.Actions.QuickfixOffBulb;
            if (icon5 == null) {
                CachedIntentions.$$$reportNull$$$0(42);
            }
            return icon5;
        }
        Icon disabledIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Actions.RealIntentionBulb);
        Icon icon6 = disabledIcon != null ? disabledIcon : AllIcons.Actions.RealIntentionBulb;
        if (icon6 == null) {
            CachedIntentions.$$$reportNull$$$0(43);
        }
        return icon6;
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info -> IntentionManagerSettings.getInstance().isShowLightBulb(info.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptors";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedActions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CachedIntentions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndUpdateActions";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActions";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAndUpdateActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndUpdateActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addActionsTo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionsTo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "markInvoked";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeActionFromCached";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

