/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineTooltipRenderer
extends ComparableObject.Impl
implements TooltipRenderer {
    @NonNls
    @Nullable
    protected String myText;
    private volatile boolean myActiveLink;
    protected final int myCurrentWidth;

    public LineTooltipRenderer(@Nullable String text2, @NotNull Object[] comparable) {
        if (comparable == null) {
            LineTooltipRenderer.$$$reportNull$$$0(0);
        }
        this(text2, 0, comparable);
    }

    public LineTooltipRenderer(@Nullable String text2, int width, @NotNull Object[] comparable) {
        if (comparable == null) {
            LineTooltipRenderer.$$$reportNull$$$0(1);
        }
        super(comparable);
        this.myCurrentWidth = width;
        this.myText = text2;
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull HintHint hintHint, @NotNull JComponent pane2, final @NotNull JEditorPane editorPane) {
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(2);
        }
        if (pane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(3);
        }
        if (editorPane == null) {
            LineTooltipRenderer.$$$reportNull$$$0(4);
        }
        JPanel grid = new JPanel((LayoutManager)new GridBagLayout()){

            @Override
            public AccessibleContext getAccessibleContext() {
                return new AccessibleContextDelegate(editorPane.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }
                };
            }
        };
        GridBag bag = new GridBag().anchor(10).weightx(1.0).weighty(1.0).fillCell();
        pane2.setBorder((Border)JBUI.Borders.empty((int)6, (int)8, (int)6, (int)12));
        grid.add((Component)pane2, bag);
        grid.setBackground(hintHint.getTextBackground());
        grid.setBorder((Border)JBUI.Borders.empty());
        grid.setOpaque(hintHint.isOpaqueAllowed());
        JPanel jPanel = grid;
        if (jPanel == null) {
            LineTooltipRenderer.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public LightweightHint show(final @NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, final @NotNull HintHint hintHint) {
        if (editor == null) {
            LineTooltipRenderer.$$$reportNull$$$0(6);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(7);
        }
        if (group == null) {
            LineTooltipRenderer.$$$reportNull$$$0(8);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(9);
        }
        if (this.myText == null) {
            return null;
        }
        String tooltipPreText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        String dressedText = this.dressDescription(editor, tooltipPreText, this.myCurrentWidth > 0);
        final boolean expanded = this.myCurrentWidth > 0 && !dressedText.equals(tooltipPreText);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final JComponent contentComponent = editor.getContentComponent();
        JComponent editorComponent = editor.getComponent();
        if (!editorComponent.isShowing()) {
            return null;
        }
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        final JEditorPane editorPane = IdeTooltipManager.initPane(new Html(dressedText).setKeepFont(true), hintHint, layeredPane);
        hintHint.setContentActive(this.isContentAction(dressedText));
        if (!hintHint.isAwtTooltip()) {
            LineTooltipRenderer.correctLocation(editor, editorPane, p, alignToRight, expanded, this.myCurrentWidth);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane, (boolean)true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.getViewport().setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.setBackground(hintHint.getTextBackground());
        scrollPane.getViewport().setBackground(hintHint.getTextBackground());
        scrollPane.setViewportBorder(null);
        editorPane.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
        if (hintHint.isRequestFocus()) {
            editorPane.setFocusable(true);
        }
        final ArrayList<AnAction> actions = new ArrayList<AnAction>();
        final JPanel grid = LineTooltipRenderer.createMainPanel(hintHint, scrollPane, editorPane);
        if (ScreenReader.isActive()) {
            grid.setFocusTraversalPolicyProvider(true);
            grid.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return editorPane;
                }

                @Override
                public boolean getImplicitDownCycleTraversal() {
                    return true;
                }
            });
        }
        final LightweightHint hint = new LightweightHint(grid){

            @Override
            public void hide() {
                LineTooltipRenderer.this.onHide(editorPane);
                super.hide();
                for (AnAction action2 : actions) {
                    action2.unregisterCustomShortcutSet(contentComponent);
                }
            }

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                if (!LineTooltipRenderer.this.canAutoHideOn(event)) {
                    return false;
                }
                return super.canAutoHideOn(event);
            }
        };
        final TooltipReloader reloader = toExpand -> this.reloadFor(hint, editor, p, editorPane, alignToRight, group, hintHint, toExpand);
        actions.add(new AnAction(){
            {
                this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription"), contentComponent);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                hintHint.setRequestFocus(ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent);
                ActionsCollector.getInstance().record("tooltip.actions.show.description.shortcut", e.getInputEvent(), ((Object)((Object)this)).getClass());
                reloader.reload(!expanded);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/LineTooltipRenderer$4", "actionPerformed"));
            }
        });
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LineTooltipRenderer.this.myActiveLink = true;
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    LineTooltipRenderer.this.myActiveLink = false;
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                        hint.hide();
                        return;
                    }
                    String description = e.getDescription();
                    if (description != null && LineTooltipRenderer.handle(description, editor)) {
                        hint.hide();
                        return;
                    }
                    ActionsCollector.getInstance().record("tooltip.actions.show.description.morelink", e.getInputEvent(), this.getClass());
                    reloader.reload(!expanded);
                }
            }
        });
        this.fillPanel(editor, grid, hint, hintHint, actions, reloader);
        grid.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LineTooltipRenderer.this.myActiveLink) {
                    MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, contentComponent);
                    hint.hide();
                    contentComponent.dispatchEvent(newMouseEvent);
                }
            }
        });
        ListenerUtil.addMouseListener(grid, new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Container candidate;
                if (expanded) {
                    return;
                }
                Container parentContainer = grid;
                while (!(parentContainer instanceof ComponentWithMnemonics) && (candidate = parentContainer.getParent()) != null) {
                    parentContainer = candidate;
                }
                MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, parentContainer);
                if (parentContainer.contains(newMouseEvent.getPoint())) {
                    return;
                }
                hint.hide();
            }
        });
        hintManager.showEditorHint(hint, editor, p, 58, 0, false, hintHint);
        return hint;
    }

    protected boolean isContentAction(String dressedText) {
        return LineTooltipRenderer.isActiveHtml(dressedText);
    }

    protected boolean canAutoHideOn(@NotNull TooltipEvent event) {
        if (event == null) {
            LineTooltipRenderer.$$$reportNull$$$0(10);
        }
        return true;
    }

    private void reloadFor(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @NotNull JComponent pane2, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint, boolean expand) {
        if (hint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            LineTooltipRenderer.$$$reportNull$$$0(12);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(13);
        }
        if (pane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(14);
        }
        if (group == null) {
            LineTooltipRenderer.$$$reportNull$$$0(15);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(16);
        }
        hint.hide();
        hintHint.setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, new Point(p.x - 3, p.y - 3), this.createRenderer(this.myText, expand ? pane2.getWidth() : 0), alignToRight, group, hintHint);
    }

    protected void fillPanel(@NotNull Editor editor, @NotNull JPanel component, @NotNull LightweightHint hint, @NotNull HintHint hintHint, @NotNull ArrayList<AnAction> actions, @NotNull TooltipReloader expandCallback) {
        if (editor == null) {
            LineTooltipRenderer.$$$reportNull$$$0(17);
        }
        if (component == null) {
            LineTooltipRenderer.$$$reportNull$$$0(18);
        }
        if (hint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(19);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(20);
        }
        if (actions == null) {
            LineTooltipRenderer.$$$reportNull$$$0(21);
        }
        if (expandCallback == null) {
            LineTooltipRenderer.$$$reportNull$$$0(22);
        }
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        hintHint.setBorderInsets((Insets)JBUI.insets((int)0));
    }

    private static boolean handle(@NotNull String ref, @NotNull Editor editor) {
        if (ref == null) {
            LineTooltipRenderer.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            LineTooltipRenderer.$$$reportNull$$$0(24);
        }
        return TooltipLinkHandlerEP.handleLink(ref, editor);
    }

    public static void correctLocation(Editor editor, JComponent tooltipComponent, Point p, boolean alignToRight, boolean expanded, int currentWidth) {
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane.getWidth() - 10;
        int heightLimit = layeredPane.getHeight() - 5;
        Dimension dimension = LineTooltipRenderer.correctLocation(editor, p, alignToRight, expanded, tooltipComponent, layeredPane, widthLimit, heightLimit, currentWidth);
        tooltipComponent.setSize(dimension);
        tooltipComponent.setMaximumSize(dimension);
        tooltipComponent.setMinimumSize(dimension);
        tooltipComponent.setPreferredSize(dimension);
    }

    private static Dimension correctLocation(Editor editor, Point p, boolean alignToRight, boolean expanded, JComponent tooltipComponent, JLayeredPane layeredPane, int widthLimit, int heightLimit, int currentWidth) {
        Dimension preferredSize = tooltipComponent.getPreferredSize();
        int width = expanded ? 3 * currentWidth / 2 : preferredSize.width;
        int height = expanded ? Math.max(preferredSize.height, 150) : preferredSize.height;
        Dimension dimension = new Dimension(width, height);
        if (alignToRight) {
            p.x = Math.max(0, p.x - width);
        }
        p.x += 3;
        p.y += 3;
        if (p.x >= widthLimit - width) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            dimension = new Dimension(width, height += 20);
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y > heightLimit - height) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
            dimension = new Dimension(width, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        LineTooltipRenderer.locateOutsideMouseCursor(editor, layeredPane, p, width, height, heightLimit);
        return dimension;
    }

    private static void locateOutsideMouseCursor(Editor editor, JComponent editorComponent, Point p, int width, int height, int heightLimit) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouse = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouse, editorComponent);
        Rectangle tooltipRect = new Rectangle(p, new Dimension(width, height));
        tooltipRect.setBounds(tooltipRect.x, tooltipRect.y - editor.getLineHeight(), width, height + 2 * editor.getLineHeight());
        if (tooltipRect.contains(mouse)) {
            p.y = mouse.y + height + editor.getLineHeight() > heightLimit && mouse.y - height - editor.getLineHeight() > 0 ? mouse.y - height - editor.getLineHeight() : mouse.y + editor.getLineHeight();
        }
    }

    protected void onHide(@NotNull JComponent contentComponent) {
        if (contentComponent == null) {
            LineTooltipRenderer.$$$reportNull$$$0(25);
        }
    }

    @NotNull
    protected LineTooltipRenderer createRenderer(@Nullable String text2, int width) {
        LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text2, width, this.getEqualityObjects());
        if (lineTooltipRenderer == null) {
            LineTooltipRenderer.$$$reportNull$$$0(26);
        }
        return lineTooltipRenderer;
    }

    @NotNull
    protected String dressDescription(@NotNull Editor editor, @NotNull String tooltipText, boolean expanded) {
        if (editor == null) {
            LineTooltipRenderer.$$$reportNull$$$0(27);
        }
        if (tooltipText == null) {
            LineTooltipRenderer.$$$reportNull$$$0(28);
        }
        String string = tooltipText;
        if (string == null) {
            LineTooltipRenderer.$$$reportNull$$$0(29);
        }
        return string;
    }

    protected static boolean isActiveHtml(@NotNull String html) {
        if (html == null) {
            LineTooltipRenderer.$$$reportNull$$$0(30);
        }
        return html.contains("</a>");
    }

    public void addBelow(@NotNull String text2) {
        String newBody;
        if (text2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(31);
        }
        if (this.myText == null) {
            newBody = UIUtil.getHtmlBody((String)text2);
        } else {
            String html1 = UIUtil.getHtmlBody((String)this.myText);
            String html2 = UIUtil.getHtmlBody((String)text2);
            newBody = html1 + "<hr size=1 noshade>" + html2;
        }
        this.myText = XmlStringUtil.wrapInHtml((CharSequence)newBody);
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparable";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 5: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/LineTooltipRenderer";
                break;
            }
            case 6: 
            case 12: 
            case 17: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandCallback";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/LineTooltipRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPanel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "dressDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 5: 
            case 26: 
            case 29: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canAutoHideOn";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reloadFor";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillPanel";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "onHide";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dressDescription";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isActiveHtml";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addBelow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface TooltipReloader {
        public void reload(boolean var1);
    }
}

