/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.Patches;
import com.intellij.application.options.EditorFontsConstants;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFontOptionsPanel
extends JPanel
implements OptionsPanel {
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    @NotNull
    private final JTextField myEditorFontSizeField = new JTextField(4);
    @NotNull
    private final JTextField myLineSpacingField = new JTextField(4);
    private final FontComboBox myPrimaryCombo = new FontComboBox();
    private final JCheckBox myEnableLigaturesCheckbox = new JCheckBox(ApplicationBundle.message((String)"use.ligatures", (Object[])new Object[0]));
    private final FontComboBox mySecondaryCombo = new FontComboBox(false, false, true);
    @NotNull
    private final JBCheckBox myOnlyMonospacedCheckBox = new JBCheckBox(ApplicationBundle.message((String)"checkbox.show.only.monospaced.fonts", (Object[])new Object[0]));
    private boolean myIsInSchemeChange;
    private JLabel myPrimaryLabel;
    private JLabel mySizeLabel;
    protected static final int ADDITIONAL_VERTICAL_GAP = 12;
    protected static final int BASE_INSET = 5;
    private JLabel mySecondaryFontLabel;
    private JLabel myLineSpacingLabel;

    protected AbstractFontOptionsPanel() {
        this.setLayout(new FlowLayout(0));
        this.add(this.createControls());
    }

    protected JComponent createControls() {
        return this.createFontSettingsPanel();
    }

    protected final JPanel createFontSettingsPanel() {
        Insets baseInsets = AbstractFontOptionsPanel.getInsets(0, 0);
        JPanel fontPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 17;
        c2.insets = baseInsets;
        c2.gridx = 0;
        c2.gridy = 0;
        this.myPrimaryLabel = new JLabel(ApplicationBundle.message((String)"primary.font", (Object[])new Object[0]));
        fontPanel.add((Component)this.myPrimaryLabel, c2);
        c2.gridx = 1;
        fontPanel.add((Component)((Object)this.myPrimaryCombo), c2);
        c2.gridx = 2;
        c2.insets = AbstractFontOptionsPanel.getInsets(0, 5);
        fontPanel.add((Component)this.myOnlyMonospacedCheckBox, c2);
        c2.gridx = 0;
        c2.gridy = 1;
        c2.insets = baseInsets;
        this.mySizeLabel = new JLabel(ApplicationBundle.message((String)"editbox.font.size", (Object[])new Object[0]));
        fontPanel.add((Component)this.mySizeLabel, c2);
        c2.gridx = 1;
        fontPanel.add((Component)this.myEditorFontSizeField, c2);
        c2.gridx = 0;
        c2.gridy = 2;
        this.myLineSpacingLabel = new JLabel(ApplicationBundle.message((String)"editbox.line.spacing", (Object[])new Object[0]));
        this.myLineSpacingLabel.setLabelFor(this.myLineSpacingField);
        fontPanel.add((Component)this.myLineSpacingLabel, c2);
        c2.gridx = 1;
        fontPanel.add((Component)this.myLineSpacingField, c2);
        c2.gridy = 3;
        c2.gridx = 0;
        c2.insets = AbstractFontOptionsPanel.getInsets(12, 0);
        this.mySecondaryFontLabel = new JLabel(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this.mySecondaryFontLabel.setLabelFor((Component)((Object)this.mySecondaryCombo));
        fontPanel.add((Component)this.mySecondaryFontLabel, c2);
        c2.gridx = 1;
        fontPanel.add((Component)((Object)this.mySecondaryCombo), c2);
        c2.gridx = 2;
        c2.insets = AbstractFontOptionsPanel.getInsets(12, 5);
        JLabel fallbackLabel = new JLabel(ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]));
        fallbackLabel.setEnabled(false);
        fontPanel.add((Component)fallbackLabel, c2);
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        this.myEnableLigaturesCheckbox.setBorder(null);
        panel2.add(this.myEnableLigaturesCheckbox);
        JLabel warningIcon = new JLabel(AllIcons.General.BalloonWarning);
        IdeTooltipManager.getInstance().setCustomTooltip(warningIcon, new TooltipWithClickableLinks.ForBrowser(warningIcon, ApplicationBundle.message((String)"ligatures.jre.warning", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()})));
        warningIcon.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        warningIcon.setVisible(!AbstractFontOptionsPanel.areLigaturesAllowed());
        panel2.add(warningIcon);
        c2.gridx = 0;
        c2.gridy = 4;
        c2.gridwidth = 2;
        c2.insets = AbstractFontOptionsPanel.getInsets(12, 0);
        c2.insets.bottom = 5;
        fontPanel.add((Component)panel2, c2);
        this.myOnlyMonospacedCheckBox.setBorder(null);
        this.mySecondaryCombo.setEnabled(false);
        this.myOnlyMonospacedCheckBox.setSelected(EditorColorsManager.getInstance().isUseOnlyMonospacedFonts());
        this.myOnlyMonospacedCheckBox.addActionListener(e -> {
            EditorColorsManager.getInstance().setUseOnlyMonospacedFonts(this.myOnlyMonospacedCheckBox.isSelected());
            this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
            this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        });
        this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        FontInfoRenderer renderer2 = new FontInfoRenderer(){

            @Override
            protected boolean isEditorFont() {
                return true;
            }
        };
        this.myPrimaryCombo.setRenderer((ListCellRenderer)((Object)renderer2));
        this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        this.mySecondaryCombo.setRenderer((ListCellRenderer)((Object)renderer2));
        ItemListener itemListener = this::syncFontFamilies;
        this.myPrimaryCombo.addItemListener(itemListener);
        this.mySecondaryCombo.addItemListener(itemListener);
        ActionListener actionListener = this::syncFontFamilies;
        this.myPrimaryCombo.addActionListener(actionListener);
        this.mySecondaryCombo.addActionListener(actionListener);
        this.myEditorFontSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (AbstractFontOptionsPanel.this.myIsInSchemeChange || !SwingUtilities.isEventDispatchThread()) {
                    return;
                }
                String selectedFont = AbstractFontOptionsPanel.this.myPrimaryCombo.getFontName();
                if (selectedFont != null) {
                    AbstractFontOptionsPanel.this.setFontSize(AbstractFontOptionsPanel.this.getFontSizeFromField());
                }
                AbstractFontOptionsPanel.this.updateDescription(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/colors/AbstractFontOptionsPanel$2", "textChanged"));
            }
        });
        this.myEditorFontSizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    int value = Integer.parseInt(AbstractFontOptionsPanel.this.myEditorFontSizeField.getText());
                    value += up ? 1 : -1;
                    value = Math.min(EditorFontsConstants.getMaxEditorFontSize(), Math.max(EditorFontsConstants.getMinEditorFontSize(), value));
                    AbstractFontOptionsPanel.this.myEditorFontSizeField.setText(String.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myLineSpacingField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (AbstractFontOptionsPanel.this.myIsInSchemeChange) {
                    return;
                }
                float lineSpacing = AbstractFontOptionsPanel.this.getLineSpacingFromField();
                if (AbstractFontOptionsPanel.this.getLineSpacing() != lineSpacing) {
                    AbstractFontOptionsPanel.this.setCurrentLineSpacing(lineSpacing);
                }
                AbstractFontOptionsPanel.this.updateDescription(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/colors/AbstractFontOptionsPanel$4", "textChanged"));
            }
        });
        this.myLineSpacingField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    float value = Float.parseFloat(AbstractFontOptionsPanel.this.myLineSpacingField.getText());
                    value += (float)(up ? 1 : -1) * 0.1f;
                    value = Math.min(EditorFontsConstants.getMaxEditorLineSpacing(), Math.max(EditorFontsConstants.getMinEditorLineSpacing(), value));
                    AbstractFontOptionsPanel.this.myLineSpacingField.setText(String.format(Locale.ENGLISH, "%.1f", Float.valueOf(value)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myEnableLigaturesCheckbox.addActionListener(e -> {
            FontPreferences preferences = this.getFontPreferences();
            if (preferences instanceof ModifiableFontPreferences) {
                ((ModifiableFontPreferences)preferences).setUseLigatures(this.myEnableLigaturesCheckbox.isSelected());
                this.updateDescription(true);
            }
        });
        return fontPanel;
    }

    private static Insets getInsets(int extraTopSpacing, int extraLeftSpacing) {
        return JBUI.insets((int)(5 + extraTopSpacing), (int)(5 + extraLeftSpacing), (int)0, (int)0);
    }

    protected void setDelegatingPreferences(boolean isDelegating) {
    }

    private int getFontSizeFromField() {
        try {
            return Math.min(EditorFontsConstants.getMaxEditorFontSize(), Math.max(EditorFontsConstants.getMinEditorFontSize(), Integer.parseInt(this.myEditorFontSizeField.getText())));
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorFontSize();
        }
    }

    private float getLineSpacingFromField() {
        try {
            return Math.min(EditorFontsConstants.getMaxEditorLineSpacing(), Math.max(EditorFontsConstants.getMinEditorLineSpacing(), Float.parseFloat(this.myLineSpacingField.getText())));
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorLineSpacing();
        }
    }

    private void syncFontFamilies(AWTEvent event) {
        FontComboBox combo;
        Object source = event.getSource();
        if (source instanceof FontComboBox && (combo = (FontComboBox)((Object)source)).isEnabled() && combo.isShowing() && combo.getSelectedItem() != null) {
            this.syncFontFamilies();
        }
    }

    private void syncFontFamilies() {
        if (this.myIsInSchemeChange) {
            return;
        }
        FontPreferences fontPreferences = this.getFontPreferences();
        if (fontPreferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiableFontPreferences = (ModifiableFontPreferences)fontPreferences;
            modifiableFontPreferences.clearFonts();
            modifiableFontPreferences.setUseLigatures(this.myEnableLigaturesCheckbox.isSelected());
            String primaryFontFamily = this.myPrimaryCombo.getFontName();
            String secondaryFontFamily = this.mySecondaryCombo.isNoFontSelected() ? null : this.mySecondaryCombo.getFontName();
            int fontSize = this.getFontSizeFromField();
            if (primaryFontFamily != null) {
                if (!FontPreferences.DEFAULT_FONT_NAME.equals(primaryFontFamily)) {
                    modifiableFontPreferences.addFontFamily(primaryFontFamily);
                }
                modifiableFontPreferences.register(primaryFontFamily, fontSize);
            }
            if (secondaryFontFamily != null) {
                if (!FontPreferences.DEFAULT_FONT_NAME.equals(secondaryFontFamily)) {
                    modifiableFontPreferences.addFontFamily(secondaryFontFamily);
                }
                modifiableFontPreferences.register(secondaryFontFamily, fontSize);
            }
            this.updateDescription(true);
        }
    }

    @Override
    public void updateOptionsList() {
        this.myIsInSchemeChange = true;
        this.myLineSpacingField.setText(Float.toString(this.getLineSpacing()));
        FontPreferences fontPreferences = this.getFontPreferences();
        List fontFamilies = fontPreferences.getEffectiveFontFamilies();
        this.myPrimaryCombo.setFontName(fontPreferences.getFontFamily());
        boolean isThereSecondaryFont = fontFamilies.size() > 1;
        this.mySecondaryCombo.setFontName(isThereSecondaryFont ? (String)fontFamilies.get(1) : null);
        this.myEditorFontSizeField.setText(String.valueOf(fontPreferences.getSize(fontPreferences.getFontFamily())));
        boolean isReadOnlyColorScheme = this.isReadOnly();
        this.updateCustomOptions();
        boolean readOnly = isReadOnlyColorScheme || !(this.getFontPreferences() instanceof ModifiableFontPreferences);
        this.myPrimaryCombo.setEnabled(!readOnly);
        this.myPrimaryLabel.setEnabled(!readOnly);
        this.mySecondaryCombo.setEnabled(!readOnly);
        this.mySecondaryFontLabel.setEnabled(!readOnly);
        this.myOnlyMonospacedCheckBox.setEnabled(!readOnly);
        this.myLineSpacingField.setEnabled(!readOnly);
        this.myLineSpacingLabel.setEnabled(!readOnly);
        this.myEditorFontSizeField.setEnabled(!readOnly);
        this.mySizeLabel.setEnabled(!readOnly);
        this.myEnableLigaturesCheckbox.setEnabled(!readOnly && AbstractFontOptionsPanel.areLigaturesAllowed());
        this.myEnableLigaturesCheckbox.setSelected(fontPreferences.useLigatures());
        this.myIsInSchemeChange = false;
    }

    private static boolean areLigaturesAllowed() {
        return !Patches.TEXT_LAYOUT_IS_SLOW;
    }

    protected void updateCustomOptions() {
    }

    protected abstract boolean isReadOnly();

    protected abstract boolean isDelegating();

    @NotNull
    protected abstract FontPreferences getFontPreferences();

    protected abstract void setFontSize(int var1);

    protected abstract float getLineSpacing();

    protected abstract void setCurrentLineSpacing(float var1);

    @Override
    @Nullable
    public Runnable showOption(String option) {
        return null;
    }

    @Override
    public void applyChangesToScheme() {
    }

    @Override
    public void selectOption(String typeToSelect) {
    }

    public boolean updateDescription(boolean modified) {
        if (modified && this.isReadOnly()) {
            return false;
        }
        this.fireFontChanged();
        return true;
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void fireFontChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).fontChanged();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Set<String> processListOptions() {
        return new HashSet<String>();
    }
}

