/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlEnumType
extends YamlScalarType {
    private String[] myLiterals;
    private String[] myHiddenLiterals;
    private String[] myDeprecatedLiterals;

    public YamlEnumType(@NotNull String typeName) {
        if (typeName == null) {
            YamlEnumType.$$$reportNull$$$0(0);
        }
        super(typeName);
        this.myLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myHiddenLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myDeprecatedLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public YamlEnumType withLiterals(String ... literals) {
        this.myLiterals = YamlEnumType.cloneArray(literals);
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(1);
        }
        return yamlEnumType;
    }

    @NotNull
    public YamlEnumType withHiddenLiterals(String ... hiddenLiterals) {
        this.myHiddenLiterals = (String[])hiddenLiterals.clone();
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(2);
        }
        return yamlEnumType;
    }

    @NotNull
    public YamlEnumType withDeprecatedLiterals(String ... deprecatedLiterals) {
        this.myDeprecatedLiterals = (String[])deprecatedLiterals.clone();
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(3);
        }
        return yamlEnumType;
    }

    @NotNull
    protected final Stream<String> getLiteralsStream() {
        Stream<String> stream = Stream.concat(Arrays.stream(this.myLiterals), Arrays.stream(this.myDeprecatedLiterals));
        if (stream == null) {
            YamlEnumType.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlEnumType.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            YamlEnumType.$$$reportNull$$$0(6);
        }
        super.validateScalarValue(scalarValue, holder);
        String text = scalarValue.getTextValue();
        if (text.isEmpty()) {
            return;
        }
        if (Arrays.asList(this.myDeprecatedLiterals).contains(text)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlEnumType.validation.warning.value.deprecated", text), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        } else if (Stream.concat(Arrays.stream(this.myHiddenLiterals), this.getLiteralsStream()).noneMatch(text::equals)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlEnumType.validation.error.value.unknown", text), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar context) {
        if (context == null) {
            YamlEnumType.$$$reportNull$$$0(7);
        }
        List<LookupElement> list = Stream.concat(Arrays.stream(this.myLiterals).map(literal -> this.createValueLookup((String)literal, false)), Arrays.stream(this.myDeprecatedLiterals).map(literal -> this.createValueLookup((String)literal, true))).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            YamlEnumType.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    protected LookupElement createValueLookup(@NotNull String literal, boolean deprecated) {
        if (literal == null) {
            YamlEnumType.$$$reportNull$$$0(9);
        }
        return LookupElementBuilder.create((String)literal).withStrikeoutness(deprecated);
    }

    @NotNull
    private static String[] cloneArray(@NotNull String[] array) {
        if (array == null) {
            YamlEnumType.$$$reportNull$$$0(10);
        }
        String[] stringArray = array.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])array.clone();
        if (stringArray == null) {
            YamlEnumType.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlEnumType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalarValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlEnumType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withLiterals";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withHiddenLiterals";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withDeprecatedLiterals";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralsStream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLookups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateScalarValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueLookups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

