/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T extends Disposable> {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final Map<T, Object> myDisposedObjects = ContainerUtil.createWeakMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredObjects = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        List<ObjectNode<T>> list = this.myExecutedNodes;
        if (list == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (parent == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                throw new IncorrectOperationException("Sorry but parent: " + parent + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            if (this.isDisposing(parent)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent + " is being disposed so the child: " + child + " will never be disposed");
            }
            this.myDisposedObjects.remove(child);
            ObjectNode<T> parentNode = this.getNode(parent);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisposalInfo(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, @NotNull ObjectNode<T> parentNode) {
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        for (ObjectNode<T> node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification());
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        return objectNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAll(@NotNull T object, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        block19: {
            boolean needTrace;
            ObjectNode<T> node;
            if (object == null) {
                ObjectTree.$$$reportNull$$$0(9);
            }
            if (action == null) {
                ObjectTree.$$$reportNull$$$0(10);
            }
            Object object2 = this.treeLock;
            synchronized (object2) {
                node = this.getNode(object);
            }
            boolean bl = needTrace = (node != null || processUnregistered) && Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
            if (needTrace) {
                ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
            }
            try {
                ObjectNode<T> parent;
                if (node == null) {
                    if (processUnregistered) {
                        this.rememberDisposedTrace(object);
                        this.executeUnregistered(object, action);
                    }
                    break block19;
                }
                Object object3 = this.treeLock;
                synchronized (object3) {
                    parent = node.getParent();
                }
                SmartList<Throwable> exceptions = new SmartList<Throwable>();
                node.execute(action, exceptions);
                if (parent != null) {
                    Object object4 = this.treeLock;
                    synchronized (object4) {
                        parent.removeChild(node);
                    }
                }
                ObjectTree.handleExceptions(exceptions);
            }
            finally {
                if (needTrace) {
                    ourTopmostDisposeTrace.remove();
                }
            }
        }
    }

    private static void handleExceptions(List<? extends Throwable> exceptions) {
        if (!exceptions.isEmpty()) {
            for (Throwable throwable : exceptions) {
                if (throwable instanceof ProcessCanceledException) continue;
                ObjectTree.getLogger().error(throwable);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull T disposable) {
        List<ObjectNode<T>> guard;
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        List<ObjectNode<T>> list = guard = this.getNodesInExecution();
        synchronized (list) {
            for (ObjectNode<T> node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<? super T> action) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        if (recursiveGuard == null) {
            ObjectTree.$$$reportNull$$$0(13);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, ContainerUtil.identityStrategy()) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, ContainerUtil.identityStrategy());
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<? super T> action) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredObjects, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoReferenceKeptInTree(@NotNull T disposable) {
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(17);
        }
        Object object = this.treeLock;
        synchronized (object) {
            for (Map.Entry<T, ObjectNode<T>> entry : this.myObject2NodeMap.entrySet()) {
                Disposable key = (Disposable)entry.getKey();
                assert (key != disposable);
                ObjectNode<T> node = entry.getValue();
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    void removeRootObject(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        this.myRootObjects.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Disposable object2 : this.myRootObjects) {
                ObjectNode<Disposable> objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: '" + object2 + "' of " + object2.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (throwError) {
                    throw exception;
                }
                ObjectTree.getLogger().error(exception);
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
        if (logger == null) {
            ObjectTree.$$$reportNull$$$0(19);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberDisposedTrace(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(20);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <D extends Disposable> D findRegisteredObject(@NotNull T parentDisposable, @NotNull D object) {
        if (parentDisposable == null) {
            ObjectTree.$$$reportNull$$$0(21);
        }
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(22);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveGuard";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesInExecution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putNode";
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlready";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNodeFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeActionWithRecursiveGuard";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeUnregistered";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeRootObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

