/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.apache.batik.apps.svgbrowser.DOMViewerController;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public class HistoryBrowser {
    public static final int EXECUTING = 1;
    public static final int UNDOING = 2;
    public static final int REDOING = 3;
    public static final int IDLE = 4;
    protected EventListenerList eventListeners = new EventListenerList();
    protected ArrayList history = new ArrayList();
    protected int currentCommandIndex = -1;
    protected int historySize = 1000;
    protected int state = 4;
    protected CommandController commandController;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener;

    public HistoryBrowser(CommandController commandController) {
        this.commandController = commandController;
    }

    public HistoryBrowser(int n) {
        this.setHistorySize(n);
    }

    protected void setHistorySize(int n) {
        this.historySize = n;
    }

    public void setCommandController(CommandController commandController) {
        this.commandController = commandController;
    }

    public void addCommand(UndoableCommand undoableCommand) {
        int n = this.history.size();
        for (int i = n - 1; i > this.currentCommandIndex; --i) {
            this.history.remove(i);
        }
        if (this.commandController != null) {
            this.commandController.execute(undoableCommand);
        } else {
            this.state = 1;
            undoableCommand.execute();
            this.state = 4;
        }
        this.history.add(undoableCommand);
        this.currentCommandIndex = this.history.size() - 1;
        if (this.currentCommandIndex >= this.historySize) {
            this.history.remove(0);
            --this.currentCommandIndex;
        }
        this.fireExecutePerformed(new HistoryBrowserEvent(new CommandNamesInfo(undoableCommand.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void undo() {
        if (this.history.isEmpty() || this.currentCommandIndex < 0) {
            return;
        }
        UndoableCommand undoableCommand = (UndoableCommand)this.history.get(this.currentCommandIndex);
        if (this.commandController != null) {
            this.commandController.undo(undoableCommand);
        } else {
            this.state = 2;
            undoableCommand.undo();
            this.state = 4;
        }
        --this.currentCommandIndex;
        this.fireUndoPerformed(new HistoryBrowserEvent(new CommandNamesInfo(undoableCommand.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void redo() {
        if (this.history.isEmpty() || this.currentCommandIndex == this.history.size() - 1) {
            return;
        }
        UndoableCommand undoableCommand = (UndoableCommand)this.history.get(++this.currentCommandIndex);
        if (this.commandController != null) {
            this.commandController.redo(undoableCommand);
        } else {
            this.state = 3;
            undoableCommand.redo();
            this.state = 4;
        }
        this.fireRedoPerformed(new HistoryBrowserEvent(new CommandNamesInfo(undoableCommand.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void compoundUndo(int n) {
        for (int i = 0; i < n; ++i) {
            this.undo();
        }
    }

    public void compoundRedo(int n) {
        for (int i = 0; i < n; ++i) {
            this.redo();
        }
    }

    public String getLastUndoableCommandName() {
        if (this.history.isEmpty() || this.currentCommandIndex < 0) {
            return "";
        }
        return ((UndoableCommand)this.history.get(this.currentCommandIndex)).getName();
    }

    public String getLastRedoableCommandName() {
        if (this.history.isEmpty() || this.currentCommandIndex == this.history.size() - 1) {
            return "";
        }
        return ((UndoableCommand)this.history.get(this.currentCommandIndex + 1)).getName();
    }

    public void resetHistory() {
        this.history.clear();
        this.currentCommandIndex = -1;
        this.fireHistoryReset(new HistoryBrowserEvent(new Object()));
    }

    public int getState() {
        if (this.commandController != null) {
            return this.commandController.getState();
        }
        return this.state;
    }

    public void addListener(HistoryBrowserListener historyBrowserListener) {
        this.eventListeners.add(class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener = HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener")) : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener, historyBrowserListener);
    }

    public void fireExecutePerformed(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).executePerformed(historyBrowserEvent);
        }
    }

    public void fireUndoPerformed(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).undoPerformed(historyBrowserEvent);
        }
    }

    public void fireRedoPerformed(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).redoPerformed(historyBrowserEvent);
        }
    }

    public void fireHistoryReset(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).historyReset(historyBrowserEvent);
        }
    }

    public void fireDoCompoundEdit(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).doCompoundEdit(historyBrowserEvent);
        }
    }

    public void fireCompoundEditPerformed(HistoryBrowserEvent historyBrowserEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) continue;
            ((HistoryBrowserListener)objectArray[i + 1]).compoundEditPerformed(historyBrowserEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DocumentCommandController
    implements CommandController {
        protected DOMViewerController controller;
        protected int state = 4;

        public DocumentCommandController(DOMViewerController dOMViewerController) {
            this.controller = dOMViewerController;
        }

        public void execute(UndoableCommand undoableCommand) {
            Runnable runnable = new Runnable(this, undoableCommand){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = documentCommandController;
                    this.val$command = undoableCommand;
                }

                public void run() {
                    this.this$0.state = 1;
                    this.val$command.execute();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(runnable);
        }

        public void undo(UndoableCommand undoableCommand) {
            Runnable runnable = new Runnable(this, undoableCommand){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = documentCommandController;
                    this.val$command = undoableCommand;
                }

                public void run() {
                    this.this$0.state = 2;
                    this.val$command.undo();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(runnable);
        }

        public void redo(UndoableCommand undoableCommand) {
            Runnable runnable = new Runnable(this, undoableCommand){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = documentCommandController;
                    this.val$command = undoableCommand;
                }

                public void run() {
                    this.this$0.state = 3;
                    this.val$command.redo();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(runnable);
        }

        public int getState() {
            return this.state;
        }
    }

    public static interface CommandController {
        public void execute(UndoableCommand var1);

        public void undo(UndoableCommand var1);

        public void redo(UndoableCommand var1);

        public int getState();
    }

    public static class CommandNamesInfo {
        private String lastUndoableCommandName;
        private String lastRedoableCommandName;
        private String commandName;

        public CommandNamesInfo(String string, String string2, String string3) {
            this.lastUndoableCommandName = string2;
            this.lastRedoableCommandName = string3;
            this.commandName = string;
        }

        public String getLastRedoableCommandName() {
            return this.lastRedoableCommandName;
        }

        public String getLastUndoableCommandName() {
            return this.lastUndoableCommandName;
        }

        public String getCommandName() {
            return this.commandName;
        }
    }

    public static class HistoryBrowserAdapter
    implements HistoryBrowserListener {
        public void executePerformed(HistoryBrowserEvent historyBrowserEvent) {
        }

        public void undoPerformed(HistoryBrowserEvent historyBrowserEvent) {
        }

        public void redoPerformed(HistoryBrowserEvent historyBrowserEvent) {
        }

        public void historyReset(HistoryBrowserEvent historyBrowserEvent) {
        }

        public void compoundEditPerformed(HistoryBrowserEvent historyBrowserEvent) {
        }

        public void doCompoundEdit(HistoryBrowserEvent historyBrowserEvent) {
        }
    }

    public static interface HistoryBrowserListener
    extends EventListener {
        public void executePerformed(HistoryBrowserEvent var1);

        public void undoPerformed(HistoryBrowserEvent var1);

        public void redoPerformed(HistoryBrowserEvent var1);

        public void historyReset(HistoryBrowserEvent var1);

        public void doCompoundEdit(HistoryBrowserEvent var1);

        public void compoundEditPerformed(HistoryBrowserEvent var1);
    }

    public static class HistoryBrowserEvent
    extends EventObject {
        public HistoryBrowserEvent(Object object) {
            super(object);
        }
    }
}

