# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class ContinuousScatterplot(ImageAlgorithm):
    """
    ContinuousScatterplot - Given a 3d domain space represented by an
    unstructured grid composed of tetrahedral cells with bivariate
    fields, this filter tessellates each cell in the domain to polyhedral
    fragments by intersecting the projection of
    
    Superclass: ImageAlgorithm
    
    the cell into 2-D range space against two sets of cutting planes, one
    set is defined along the first field, the second set is defined along
    the second field. The volume of these subdivided polyhedral fragments
    can be computed and aggregated over cells to depict the density
    distribution of the data projection in the bivariate range space.
    
    @section Introduction Given a bivariate field (f1,f2) defined on an
    unstructured grid which is composed of tetrahedral cells, we can
    initially subdivide each cell based on its projection in the range
    into a number of fragments along the first field f1, we refer to
    these polyhedral fragments as Frag(f1) = {frag(f1)_1, frag(f1)_2, ...
    , frag(f1)_n}, where frag(f1)_n refers to the nth fragment along the
    first field subdivision. Each fragment has a range value and the
    value difference between the neighbouring fragments is represented as
    fragment width fw_f1, which is uniformly distributed across the
    range. Based on the structure of Frag(f1), for each of its cell
    "frag(f1)_n", we can further subdivide this cell based on the second
    field f2 using fragment width fw_f2. The tessellation along the
    second field results in an even finer fragment collection which we
    refer to as Frag(f1,f2) = {frag(f1,f2)_1, frag(f1,f2)_2, ... ,
    frag(f1,f2)_m}. We can observe that Frag(f1,f2) is a finer
    tessellation of the domain than Frag(f1) and will be used to compute
    the density distribution in the bivariate range space. The algorithm
    for fragment computation is similar to the first stage of the work in
    [0]. Each fragment "s" in Frag(f1,f2) has range values (f1(s), f2(s))
    in the bivariate fields. These values can be further mapped to a 2-D
    bin with a resolution rex_x * res_y. The mapped bin index (bin_index_x,
    bin_index_y) of the fragment can be computed by linear interpolation on
    its range values :
              bin_index_x = (int) res_x * (f1(s) - f1_min) / (f1_max -
    f1_min)
              bin_index_y = (int) res_y * (f2(s) - f2_min) / (f2_max -
    f2_min),
           where (f1_min, f1_max) is the range in first field. Once we
    know which bin a fragment coincides, the density value in each bin
    equals to the total geometric volume of the fragments in this bin.
    This volume distribution over the bins will be exported as a point
    data array in the output data structure. If we map this 2-D bin to a
    2-D image with each bin corresponding to a pixel and bin density to
    pixel transparency, then the image can be displayed as a continuous
    scatterplot.
    
    * @section Algorithm
    * The algorithm of this filter can be described as:
    *   Require: R.1 The domain space is an unstructured grid data set
      composed of
    *                tetrahedral cells;
    *            R.2 The range space contains two scalar fields, say f1
      and f2.
    *
    *   The most important step is to compute the fragments. The
      implementation processes
    *   the input grid one cell at a time, explicitly computing the
      intersection of the cell
    *   with the cutting planes defined by the fragment boundaries in
      each scalar field.
    *   In order to subdivide the cell, we need to define a list of
      cutting planes in each
    *   field. The interval between neighbouring cutting planes is
      related to the output 2-D
    *   bin resolution (res_x, res_y) and can be computed as :
    *                     fw_f1 = (f1_max - f1_min) / res_x
    *                     fw_f2 = (f2_max - f2_min) / res_y,
    *                 where (f1_max,f1_min) is the scalar range of first
      field.
    *
    *      1. For each tetrahedron T in the input grid:
    *
    *        1.1 Subdivide the cell T based on the first field f1, we
      will obtain a list
    *            of fragments: Frag(f1) = {frag(f1)_1, frag(f1)_2, ... ,
      frag(f1)_n}. The
    *            steps for subdivision can be described as:
    *
    *            1.1.1 For each cutting plane s with respect to the first
    field f1,
    *                  its field value f1(s) = f1_min + n * fw_f1, where
      n refers to the n-th
    *                  cutting plane:
    *
    *              1.1.2. Traverse each edge e starting from point a to b
    in the cell, we
    *                     will maintain three data classes, namely
      fragment_face,
    *                     residual_face and cut_set:
    *                     A. fragment_face contains vertices in the
      current fragment.
    *                     B. cut_set contains vertices whose range values
      equal to f1(s).
    *                        This set contains the current cutting plane.
    *                     C. residual_face contains the rest of the
      vertices in the cell.
    *                     In order to classify edge vertices into these
      classes, the
    *                     following case table is used for each vertex
      "a" :
    *                       case 0 :          f1(a)------ f1(s)
      ------f1(b)
    *                              condition: f1(a) < f1(s) , f1(b) >
      f1(s)
    *                              class:     p(s,e), a -> fragment_face
    *                                         p(s,e) -> cut_set
    *                                         p(s,e) -> residual_face
    *
    *                       case 1 :          f1(b)------ f1(s)
      ------f1(a)
    *                              condition: f1(a) > f1(s) , f1(b) <
      f1(s)
    *                              class:     p(s,e) -> fragment_face
    *                                         p(s,e) -> cut_set
    *                                         a -> residual_face
    *
    *                       case 2 :   
      f1(s),f1(a)-------------------f1(b)
    *                              condition: f1(s) == f1(a), f1(s) <=
      f1(b)
    *                              class:     a -> fragment_face
    *                                         a -> residual_face
    *                                         a -> cut_set
    *
    *                       case 3 :         
      f1(a)-------------------f1(b), f1(s)
    *                              condition: f1(s) > f1(a), f1(s) ==
      f1(b)
    *                              class:     a -> fragment_face
    *
    *                       case 4 :   
      f1(s),f1(b)-------------------f1(a)
    *                              condition: f1(s) < f1(a), f1(s) ==
      f1(b)
    *                              class:     a -> residual_face
    *                       Remark: 1. we use "->" to indicate "belongs
      to" relation.
    *                               2. p(s,e) refers to the interpolated
      point of range value
    *                                  f1(s) on the edge e.
    *
    *             1.1.3. After we have traversed every edge in a cell for
    the cutting plane
    *                    s, three classes for storing fragment, cutting
      plane and residual
    *                    faces are updated. The faces of the current
      fragment frag(f1)
    *                    are the union of all elements in fragment_face
      and cut_set.
    *
    *    1.2 Take the output of step 1.1, traverse each fragment in
      Frag(f1), define a list
    *        of cutting planes with respect to field f2, further
      subdivide the fragments in
    *        Frag(f1) following steps from 1.1.2 to 1.1.3. The output of
      this step will be
    *        the fragment collection Frag(f1,f2). Each fragment in
      Frag(f1,f2) can be further
    *        mapped to a 2-D bin based on its range values. The density
      value in each bin
    *        equals to the total geometric volume of the fragments in
      this bin. This volume
    *        distribution over the bins will be exported as a point data
      array in the output
    *        data structure.
    *
    * @section VTK Filter Design
    * The input and output ports of the filter:
    *      Input port : the input data set should be a
      UnstructuredGrid, with each of its
    *                   cell defined as a tetrahedron. At least two
      scalar fields are
    *                   associated with the data. The user needs to
      specify the name of the
    *                   two scalar arrays beforehand.
    *      Output port: the output data set is a 2d image stored as a
      ImageData.
    *                   The resolution of the output image can be set by
      the user.
    *                   The volume distribution of fragments in each
      pixel or bin
    *                   is stored in an point data array named "volume"
      in the output
    *                   ImageData.
    *
    * @section How To Use This Filter
    * Suppose we have a tetrahedral mesh stored in a UnstructuredGrid,
    we call this
    * data set "input_data". This data set has two scalar arrays whose
      names are "f1"
    * and "f2" respectively. We would like the resolution of output image
    set to (res_x,res_y).
    * Given these input, this filter can be called as follows in c++
      sample code:
    *
    *     SmartPointercsp =
    *                            SmartPointer::New();
    *     csp->_set_input_data(input_data);
    *     csp->_set_field1("f_1",res_x);
    *     csp->_set_field2("f_2",res_y);
    *     csp->Update();
    *
    * Then the output, "csp->_get_output()", will be a ImageData
      containing a scalar
    * array whose name is "volume". This array contains the volume
      distribution of the
    * fragments.
    *
    * [0] H.Carr and D.Duke, Joint contour nets: Topological analysis of
      multivariate data.
    *     IEEE Transactions on Visualization and Computer Graphics,
      volume 20,
    *     issue 08, pages 1100-1113, 2014
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContinuousScatterplot, obj, update, **traits)
    
    epsilon = traits.Float(1e-06, enter_set=True, auto_set=False, desc=\
        """
        Set the tolerance used when comparing floating point numbers for
        equality.
        """
    )

    def _epsilon_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEpsilon,
                        self.epsilon)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_field1(self, *args):
        """
        V.set_field1(string, int)
        C++: void SetField1(const char *fieldName, IdType ResX)
        Specify the name of the first field to be used in subdividing the
        dataset. Specify the resolution along x axis of the output image.
        """
        ret = self._wrap_call(self._vtk_obj.SetField1, *args)
        return ret

    def set_field2(self, *args):
        """
        V.set_field2(string, int)
        C++: void SetField2(const char *fieldName, IdType ResY)
        Specify the name of the second field to be used in subdividing
        the dataset. Specify the resolution along y axis of the output
        image.
        """
        ret = self._wrap_call(self._vtk_obj.SetField2, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('epsilon',
    'GetEpsilon'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'epsilon', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ContinuousScatterplot, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ContinuousScatterplot properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['epsilon']),
            title='Edit ContinuousScatterplot properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ContinuousScatterplot properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

