/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public final class DumpCargoDialog
extends FreeColDialog<List<Goods>> {
    private static final Logger logger = Logger.getLogger(DumpCargoDialog.class.getName());
    private final List<Goods> goodsList;
    private final List<JCheckBox> checkBoxes;

    public DumpCargoDialog(FreeColClient freeColClient, JFrame frame, Unit unit) {
        super(freeColClient, frame);
        this.goodsList = unit.getGoodsList();
        this.checkBoxes = new ArrayList<JCheckBox>(this.goodsList.size());
        for (Goods goods : this.goodsList) {
            JCheckBox jCheckBox = new JCheckBox(Messages.message(goods.getLabel(true)), true);
            this.checkBoxes.add(jCheckBox);
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "", ""));
        panel.add(Utility.localizedHeader("dumpCargo", true));
        for (JCheckBox jCheckBox : this.checkBoxes) {
            panel.add(jCheckBox);
        }
        panel.setSize(panel.getPreferredSize());
        Object t = null;
        List list = DumpCargoDialog.choices();
        list.add(new ChoiceItem<Object>(Messages.message("ok"), t).okOption().defaultOption());
        list.add(new ChoiceItem<Object>(Messages.message("cancel"), t).cancelOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, false, panel, new ImageIcon(this.getImageLibrary().getUnitImage(unit)), list);
    }

    @Override
    public List<Goods> getResponse() {
        Object value = this.getValue();
        ArrayList<Goods> gl = new ArrayList<Goods>();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            for (int i = 0; i < this.checkBoxes.size(); ++i) {
                if (!this.checkBoxes.get(i).isSelected()) continue;
                gl.add(this.goodsList.get(i));
            }
        }
        return gl;
    }
}

