/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.BlockInputStream;
import gnu.inet.ftp.BlockOutputStream;
import gnu.inet.ftp.CompressedInputStream;
import gnu.inet.ftp.CompressedOutputStream;
import gnu.inet.ftp.DTP;
import gnu.inet.ftp.DTPInputStream;
import gnu.inet.ftp.DTPOutputStream;
import gnu.inet.ftp.StreamInputStream;
import gnu.inet.ftp.StreamOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

final class PassiveModeDTP
implements DTP {
    final String address;
    final int port;
    Socket socket;
    DTPInputStream in;
    DTPOutputStream out;
    boolean completed;
    boolean inProgress;
    int transferMode;

    PassiveModeDTP(String string, int n, InetAddress inetAddress, int n2, int n3) throws IOException {
        this.address = string;
        this.port = n;
        this.completed = false;
        this.inProgress = false;
        this.socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(inetAddress, n + 1);
        this.socket.bind(inetSocketAddress2);
        if (n2 > 0) {
            this.socket.connect(inetSocketAddress, n2);
        } else {
            this.socket.connect(inetSocketAddress);
        }
        if (n3 > 0) {
            this.socket.setSoTimeout(n3);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        switch (this.transferMode) {
            case 1: {
                this.in = new StreamInputStream(this, this.socket.getInputStream());
                break;
            }
            case 2: {
                this.in = new BlockInputStream(this, this.socket.getInputStream());
                break;
            }
            case 3: {
                this.in = new CompressedInputStream(this, this.socket.getInputStream());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid transfer mode");
            }
        }
        this.in.setTransferComplete(false);
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.inProgress) {
            throw new IOException("Transfer in progress");
        }
        switch (this.transferMode) {
            case 1: {
                this.out = new StreamOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 2: {
                this.out = new BlockOutputStream(this, this.socket.getOutputStream());
                break;
            }
            case 3: {
                this.out = new CompressedOutputStream(this, this.socket.getOutputStream());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid transfer mode");
            }
        }
        this.out.setTransferComplete(false);
        return this.out;
    }

    @Override
    public void setTransferMode(int n) {
        this.transferMode = n;
    }

    @Override
    public void complete() {
        this.completed = true;
        if (!this.inProgress) {
            this.transferComplete();
        }
    }

    @Override
    public boolean abort() {
        this.completed = true;
        this.transferComplete();
        return this.inProgress;
    }

    @Override
    public void transferComplete() {
        if (this.in != null) {
            this.in.setTransferComplete(true);
        }
        if (this.out != null) {
            this.out.setTransferComplete(true);
        }
        this.inProgress = false;
        boolean bl = this.completed = this.completed || this.transferMode == 1;
        if (this.completed && this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

