/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myVcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "startupManager", "Lcom/intellij/openapi/startup/StartupManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;Lcom/intellij/openapi/startup/StartupManager;)V", "autoDetectModuleVcsMapping", "", "module", "Lcom/intellij/openapi/module/Module;", "autoDetectVcsMappings", "tryMapPieces", "", "getMappings", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "MyModulesListener", "intellij.platform.vcs.impl"})
public final class ModuleVcsDetector {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    /*
     * WARNING - void declaration
     */
    private final void autoDetectVcsMappings(boolean tryMapPieces) {
        Iterable rootPaths;
        VirtualFile root;
        Pair $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        void $this$flatMapTo$iv$iv;
        if (this.myVcsManager.haveDefaultMapping() != null) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(myProject).modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Iterator element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv2;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            Object[] objectArray = ProjectUtil.getRootManager((Module)v2).getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.rootManager.contentRoots");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List roots = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            root = (VirtualFile)element$iv$iv3;
            boolean bl2 = false;
            if (this.myVcsManager.findVersioningVcs(root) != null) {
                AbstractVcs abstractVcs;
                boolean bl3 = false;
                boolean bl4 = false;
                AbstractVcs it = abstractVcs;
                boolean bl5 = false;
                pair = TuplesKt.to((Object)root, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair2;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List rootVcses = (List)destination$iv$iv2;
        if (rootVcses.size() == 1) {
            void root2;
            $this$mapNotNullTo$iv$iv = (Pair)CollectionsKt.first((List)rootVcses);
            $this$mapNotNull$iv = (VirtualFile)$this$mapNotNullTo$iv$iv.component1();
            AbstractVcs vcs = (AbstractVcs)$this$mapNotNullTo$iv$iv.component2();
            VirtualFile projectBaseDir = this.myProject.getBaseDir();
            if (projectBaseDir != null && Intrinsics.areEqual((Object)projectBaseDir, (Object)root2)) {
                void $this$filterTo$iv$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = roots;
                boolean $i$f$map = false;
                Iterable $i$f$forEach2 = $this$map$iv;
                Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    root = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl = false;
                    void v5 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                    String string = v5.getPath();
                    collection.add(string);
                }
                rootPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                List<VcsDirectoryMapping> list = this.myVcsManager.getDirectoryMappings();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"myVcsManager.directoryMappings");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                destination$iv$iv3 = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
                    VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv$iv4;
                    boolean bl = false;
                    VcsDirectoryMapping vcsDirectoryMapping = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirectoryMapping, (String)"it");
                    if (!(!rootPaths.contains(vcsDirectoryMapping.getDirectory()))) continue;
                    destination$iv$iv4.add(element$iv$iv4);
                }
                List additionalMappings = (List)destination$iv$iv4;
                Collection collection = additionalMappings;
                AbstractVcs abstractVcs = vcs;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"vcs");
                this.myVcsManager.setAutoDirectoryMappings(CollectionsKt.plus((Collection)collection, (Object)VcsDirectoryMapping.createDefault((String)abstractVcs.getName())));
            }
        } else if (tryMapPieces) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = rootVcses;
            boolean $i$f$map = false;
            rootPaths = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$root$vcs;
                Pair destination$iv$iv4 = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv5;
                boolean bl = false;
                VirtualFile root3 = (VirtualFile)$dstr$root$vcs.component1();
                AbstractVcs vcs = (AbstractVcs)$dstr$root$vcs.component2();
                VirtualFile virtualFile = root3;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                String string = virtualFile.getPath();
                AbstractVcs abstractVcs = vcs;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"vcs");
                VcsDirectoryMapping vcsDirectoryMapping = new VcsDirectoryMapping(string, abstractVcs.getName());
                collection.add(vcsDirectoryMapping);
            }
            List newMappings = (List)destination$iv$iv5;
            List<VcsDirectoryMapping> list = this.myVcsManager.getDirectoryMappings();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"myVcsManager.directoryMappings");
            this.myVcsManager.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Iterable)newMappings));
        }
    }

    private final void autoDetectModuleVcsMapping(Module module) {
        if (this.myVcsManager.haveDefaultMapping() != null) {
            return;
        }
        boolean bl = false;
        List newMappings = new ArrayList();
        for (VirtualFile file : ProjectUtil.getRootManager((Module)module).getContentRoots()) {
            AbstractVcs vcs = this.myVcsManager.findVersioningVcs(file);
            if (vcs == null || vcs == this.myVcsManager.getVcsFor(file)) continue;
            VirtualFile virtualFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            newMappings.add(new VcsDirectoryMapping(virtualFile.getPath(), vcs.getName()));
        }
        Collection collection = newMappings;
        int n = 0;
        if (!collection.isEmpty()) {
            List<VcsDirectoryMapping> list = this.myVcsManager.getDirectoryMappings();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"myVcsManager.directoryMappings");
            this.myVcsManager.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Iterable)newMappings));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VcsDirectoryMapping> getMappings(Module module) {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
        VirtualFile[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            VcsDirectoryMapping vcsDirectoryMapping;
            Object v5;
            block2: {
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_9[i];
                boolean bl = false;
                void root = element$iv$iv;
                boolean bl2 = false;
                List<VcsDirectoryMapping> list = this.myVcsManager.getDirectoryMappings();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"myVcsManager.directoryMappings");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv;
                    boolean bl3 = false;
                    VcsDirectoryMapping vcsDirectoryMapping2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirectoryMapping2, (String)"it");
                    String string = vcsDirectoryMapping2.getDirectory();
                    void v4 = root;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"root");
                    if (!Intrinsics.areEqual((Object)string, (Object)v4.getPath())) continue;
                    v5 = element$iv;
                    break block2;
                }
                v5 = null;
            }
            if ((VcsDirectoryMapping)v5 == null) continue;
            boolean bl = false;
            boolean bl4 = false;
            VcsDirectoryMapping it$iv$iv = vcsDirectoryMapping;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ModuleVcsDetector(@NotNull Project myProject, @NotNull ProjectLevelVcsManagerImpl myVcsManager, @NotNull StartupManager startupManager) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)((Object)myVcsManager), (String)"myVcsManager");
        Intrinsics.checkParameterIsNotNull((Object)startupManager, (String)"startupManager");
        this.myProject = myProject;
        this.myVcsManager = myVcsManager;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            boolean bl = false;
            boolean bl2 = false;
            StartupManager $this$with = startupManager;
            boolean bl3 = false;
            $this$with.registerStartupActivity(new Runnable(this){
                final /* synthetic */ ModuleVcsDetector this$0;
                {
                    this.this$0 = moduleVcsDetector;
                }

                public final void run() {
                    if (ModuleVcsDetector.access$getMyVcsManager$p(this.this$0).needAutodetectMappings()) {
                        ModuleVcsDetector.access$autoDetectVcsMappings(this.this$0, true);
                    }
                }
            });
            $this$with.registerPostStartupActivity(new Runnable(this){
                final /* synthetic */ ModuleVcsDetector this$0;
                {
                    this.this$0 = moduleVcsDetector;
                }

                public final void run() {
                    MyModulesListener listener = this.this$0.new MyModulesListener();
                    MessageBusConnection messageBusConnection = ModuleVcsDetector.access$getMyProject$p(this.this$0).getMessageBus().connect();
                    boolean bl = false;
                    boolean bl2 = false;
                    MessageBusConnection $this$apply = messageBusConnection;
                    boolean bl3 = false;
                    $this$apply.subscribe(ProjectTopics.MODULES, (Object)listener);
                    $this$apply.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener);
                }
            });
        }
    }

    public static final /* synthetic */ Project access$getMyProject$p(ModuleVcsDetector $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/project/ModuleListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;)V", "myMappingsForRemovedModules", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "beforeModuleRemoved", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "beforeRootsChange", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "moduleAdded", "rootsChanged", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    implements ModuleRootListener,
    ModuleListener {
        private final List<VcsDirectoryMapping> myMappingsForRemovedModules;

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Iterable $this$forEach$iv = this.myMappingsForRemovedModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)element$iv;
                boolean bl = false;
                ModuleVcsDetector.this.myVcsManager.removeDirectoryMapping(mapping);
            }
            if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module);
        }

        public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module));
        }

        public MyModulesListener() {
            List list;
            MyModulesListener myModulesListener = this;
            boolean bl = false;
            myModulesListener.myMappingsForRemovedModules = list = (List)new ArrayList();
        }
    }
}

