/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.ScalarProperty;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.stateProperties.ObjectStateStoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/serialization/stateProperties/ObjectStoredProperty;", "T", "Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "Lcom/intellij/openapi/components/ScalarProperty;", "defaultValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "getModificationCount", "", "isEqualToDefault", "", "parseAndSetValue", "", "rawValue", "", "intellij.platform.objectSerializer"})
public class ObjectStoredProperty<T>
extends ObjectStateStoredPropertyBase<T>
implements ScalarProperty {
    private final T defaultValue;

    @Override
    @NotNull
    public JsonSchemaType getJsonType() {
        return this.defaultValue instanceof Boolean ? JsonSchemaType.BOOLEAN : JsonSchemaType.OBJECT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualToDefault() {
        Object value = this.getValue();
        if (Intrinsics.areEqual(this.defaultValue, value)) return true;
        Object t = value;
        if (!(t instanceof BaseState)) {
            t = null;
        }
        BaseState baseState = (BaseState)t;
        if (baseState == null) return false;
        boolean bl = baseState.isEqualToDefault();
        if (!bl) return false;
        return true;
    }

    public long getModificationCount() {
        Object t = this.getValue();
        if (!(t instanceof ModificationTracker)) {
            t = null;
        }
        ModificationTracker modificationTracker = (ModificationTracker)t;
        return modificationTracker != null ? modificationTracker.getModificationCount() : 0L;
    }

    public void parseAndSetValue(@Nullable String rawValue) {
        this.setValue(StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"yes") || StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"on"));
    }

    public ObjectStoredProperty(T defaultValue) {
        super(defaultValue);
        this.defaultValue = defaultValue;
    }
}

