/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@Tag(value="configurable")
public class ConfigurableEP<T extends UnnamedConfigurable>
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ConfigurableEP");
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String displayName;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Title)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Property(surroundWithTag=false)
    @XCollection
    public ConfigurableEP[] children;
    @Attribute(value="childrenEPName")
    public String childrenEPName;
    @Attribute(value="dynamic")
    public boolean dynamic;
    @Attribute(value="parentId")
    public String parentId;
    @Attribute(value="id")
    public String id;
    @Attribute(value="groupId")
    public String groupId;
    @Attribute(value="groupWeight")
    public int groupWeight;
    @Attribute(value="nonDefaultProject")
    public boolean nonDefaultProject;
    @Deprecated
    @Attribute(value="implementation")
    public String implementationClass;
    @Attribute(value="instance")
    public String instanceClass;
    @Attribute(value="provider")
    public String providerClass;
    @Attribute(value="treeRenderer")
    public String treeRendererClass;
    private final AtomicNotNullLazyValue<ObjectProducer> myProducer;
    private PicoContainer myPicoContainer;
    private Project myProject;

    public String getDisplayName() {
        if (this.displayName == null) {
            ResourceBundle resourceBundle = this.findBundle();
            if (resourceBundle != null) {
                this.displayName = CommonBundle.message((ResourceBundle)resourceBundle, (String)this.key, (Object[])new Object[0]);
            } else {
                this.displayName = this.providerClass != null ? this.providerClass : (this.instanceClass != null ? this.instanceClass : this.implementationClass);
                LOG.warn("Bundle missed for " + this.displayName);
            }
        }
        return this.displayName;
    }

    @Nullable
    public ResourceBundle findBundle() {
        String pathToBundle = this.findPathToBundle();
        if (pathToBundle == null) {
            return null;
        }
        ClassLoader loader = this.myPluginDescriptor == null ? null : this.myPluginDescriptor.getPluginClassLoader();
        return AbstractBundle.getResourceBundle((String)pathToBundle, (ClassLoader)(loader != null ? loader : ((Object)((Object)this)).getClass().getClassLoader()));
    }

    @Nullable
    private String findPathToBundle() {
        if (this.bundle == null && this.myPluginDescriptor instanceof IdeaPluginDescriptor) {
            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)this.myPluginDescriptor;
            return descriptor.getResourceBundleBaseName();
        }
        return this.bundle;
    }

    public ConfigurableEP[] getChildren() {
        for (ConfigurableEP child : this.children) {
            child.myPicoContainer = this.myPicoContainer;
            child.myPluginDescriptor = this.myPluginDescriptor;
            child.myProject = this.myProject;
        }
        return this.children;
    }

    public boolean isAvailable() {
        return !this.nonDefaultProject || this.myProject == null || !this.myProject.isDefault();
    }

    public ConfigurableEP() {
        this(ApplicationManager.getApplication().getPicoContainer(), null);
    }

    public ConfigurableEP(@NotNull Project project) {
        if (project == null) {
            ConfigurableEP.$$$reportNull$$$0(0);
        }
        this(project.getPicoContainer(), project);
    }

    protected ConfigurableEP(@NotNull PicoContainer picoContainer, @Nullable Project project) {
        if (picoContainer == null) {
            ConfigurableEP.$$$reportNull$$$0(1);
        }
        this.myProducer = AtomicNotNullLazyValue.createValue(this::createProducer);
        this.myProject = project;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    protected ObjectProducer createProducer() {
        block10: {
            ClassProducer classProducer;
            block11: {
                block8: {
                    ClassProducer classProducer2;
                    block9: {
                        block6: {
                            ProviderProducer providerProducer;
                            block7: {
                                if (this.providerClass == null) break block6;
                                providerProducer = new ProviderProducer((ConfigurableProvider)this.instantiate(this.providerClass, this.myPicoContainer));
                                if (providerProducer != null) break block7;
                                ConfigurableEP.$$$reportNull$$$0(2);
                            }
                            return providerProducer;
                        }
                        if (this.instanceClass == null) break block8;
                        classProducer2 = new ClassProducer(this.myPicoContainer, this.findClass(this.instanceClass));
                        if (classProducer2 != null) break block9;
                        ConfigurableEP.$$$reportNull$$$0(3);
                    }
                    return classProducer2;
                }
                if (this.implementationClass == null) break block10;
                classProducer = new ClassProducer(this.myPicoContainer, this.findClass(this.implementationClass));
                if (classProducer != null) break block11;
                ConfigurableEP.$$$reportNull$$$0(4);
            }
            return classProducer;
        }
        try {
            throw new RuntimeException("configurable class name is not set");
        }
        catch (AssertionError | Exception | LinkageError error) {
            LOG.error((Throwable)error);
            ObjectProducer objectProducer = new ObjectProducer();
            if (objectProducer == null) {
                ConfigurableEP.$$$reportNull$$$0(5);
            }
            return objectProducer;
        }
    }

    @Nullable
    public T createConfigurable() {
        ObjectProducer producer = (ObjectProducer)this.myProducer.getValue();
        if (producer.canCreateElement()) {
            UnnamedConfigurable configurable = (UnnamedConfigurable)producer.createElement();
            return (T)configurable;
        }
        return null;
    }

    @Nullable
    public ConfigurableTreeRenderer createTreeRenderer() {
        if (this.treeRendererClass == null) {
            return null;
        }
        try {
            return (ConfigurableTreeRenderer)ConfigurableEP.instantiate((Class)this.findClass(this.treeRendererClass), (PicoContainer)this.myPicoContainer);
        }
        catch (ProcessCanceledException exception) {
            throw exception;
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean canCreateConfigurable() {
        return ((ObjectProducer)this.myProducer.getValue()).canCreateElement();
    }

    @Nullable
    public Class<?> getConfigurableType() {
        return ((ObjectProducer)this.myProducer.getValue()).getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ConfigurableEP";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ConfigurableEP";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ClassProducer
    extends ObjectProducer {
        private final PicoContainer myContainer;
        private final Class<?> myType;

        private ClassProducer(PicoContainer container, Class<?> type) {
            this.myContainer = container;
            this.myType = type;
        }

        @Override
        protected Object createElement() {
            try {
                return AbstractExtensionPointBean.instantiate(this.myType, (PicoContainer)this.myContainer);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (ExtensionNotApplicableException ignore) {
                return null;
            }
            catch (AssertionError | Exception | LinkageError e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        @Override
        protected boolean canCreateElement() {
            return this.myType != null;
        }

        @Override
        protected Class<?> getType() {
            return this.myType;
        }
    }

    private static final class ProviderProducer
    extends ObjectProducer {
        private final ConfigurableProvider myProvider;

        private ProviderProducer(ConfigurableProvider provider) {
            this.myProvider = provider;
        }

        @Override
        protected Object createElement() {
            return this.myProvider == null ? null : this.myProvider.createConfigurable();
        }

        @Override
        protected boolean canCreateElement() {
            return this.myProvider != null && this.myProvider.canCreateConfigurable();
        }
    }

    protected static class ObjectProducer {
        protected ObjectProducer() {
        }

        protected Object createElement() {
            return null;
        }

        protected boolean canCreateElement() {
            return false;
        }

        protected Class<?> getType() {
            return null;
        }
    }
}

