/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapProvider;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.SystemInfo;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J,\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "", "providers", "", "Lcom/intellij/openapi/keymap/impl/BundledKeymapProvider;", "(Ljava/util/List;)V", "defaultKeymapName", "", "getDefaultKeymapName", "()Ljava/lang/String;", "keymaps", "Lcom/intellij/openapi/keymap/Keymap;", "getKeymaps", "()Ljava/util/List;", "myKeymaps", "Ljava/util/ArrayList;", "nameToScheme", "Lgnu/trove/THashMap;", "findScheme", "name", "findScheme$intellij_platform_ide_impl", "getKeymapPresentableName", "keymap", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "loadKeymapsFromElement", "", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "keymapName", "providerClass", "Ljava/lang/Class;", "Companion", "intellij.platform.ide.impl"})
public class DefaultKeymap {
    private final ArrayList<Keymap> myKeymaps;
    private final THashMap<String, Keymap> nameToScheme;
    public static final Companion Companion = new Companion(null);

    private final void loadKeymapsFromElement(SchemeDataHolder<? super KeymapImpl> dataHolder, String keymapName, Class<BundledKeymapProvider> providerClass) {
        DefaultKeymapImpl keymap = StringsKt.startsWith$default((String)keymapName, (String)"Mac OS X", (boolean)false, (int)2, null) ? (DefaultKeymapImpl)new MacOSDefaultKeymap(dataHolder, this, providerClass) : new DefaultKeymapImpl(dataHolder, this, providerClass);
        keymap.setName(keymapName);
        this.myKeymaps.add(keymap);
        this.nameToScheme.put((Object)keymapName, (Object)keymap);
    }

    @NotNull
    public final List<Keymap> getKeymaps() {
        return CollectionsKt.toList((Iterable)this.myKeymaps);
    }

    @Nullable
    public final Keymap findScheme$intellij_platform_ide_impl(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Keymap)this.nameToScheme.get((Object)name);
    }

    @NotNull
    public String getDefaultKeymapName() {
        return SystemInfo.isMac ? "Mac OS X 10.5+" : (SystemInfo.isGNOME ? "Default for GNOME" : (SystemInfo.isKDE ? "Default for KDE" : (SystemInfo.isXWindow ? "Default for XWin" : "$default")));
    }

    @NotNull
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)keymap, (String)"keymap");
        String name = keymap.getName();
        if (Intrinsics.areEqual((Object)name, (Object)"Mac OS X 10.5+")) {
            string = "Default for macOS";
        } else if (Intrinsics.areEqual((Object)name, (Object)"$default")) {
            string = "Default for Windows";
        } else if (Intrinsics.areEqual((Object)name, (Object)"Mac OS X")) {
            string = "IntelliJ IDEA Classic" + (SystemInfo.isMac ? "" : " (macOS)");
        } else if (Intrinsics.areEqual((Object)name, (Object)"NetBeans 6.5")) {
            string = "NetBeans";
        } else {
            String newName = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)name, (CharSequence)" (Mac OS X)"), (CharSequence)" OSX");
            string = newName == name ? name : newName + " (macOS)";
        }
        return string;
    }

    @JvmOverloads
    public DefaultKeymap(@NotNull List<? extends BundledKeymapProvider> providers) {
        Intrinsics.checkParameterIsNotNull(providers, (String)"providers");
        this.myKeymaps = new ArrayList();
        this.nameToScheme = new THashMap();
        for (BundledKeymapProvider bundledKeymapProvider : providers) {
            for (String fileName2 : bundledKeymapProvider.getKeymapFileNames()) {
                Logger $this$runAndLogException$iv = DefaultKeymapKt.access$getLOG$p();
                boolean $i$f$runAndLogException = false;
                try {
                    boolean bl = false;
                    SchemeDataHolder schemeDataHolder = new SchemeDataHolder<KeymapImpl>(this, bundledKeymapProvider, fileName2){
                        final /* synthetic */ DefaultKeymap this$0;
                        final /* synthetic */ BundledKeymapProvider $provider$inlined;
                        final /* synthetic */ String $fileName$inlined;
                        {
                            this.this$0 = defaultKeymap;
                            this.$provider$inlined = bundledKeymapProvider;
                            this.$fileName$inlined = string;
                        }

                        public Element read() {
                            return (Element)this.$provider$inlined.load(this.$fileName$inlined, 1.read.1.INSTANCE);
                        }

                        public void updateDigest(@NotNull KeymapImpl scheme) {
                            Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
                        }

                        public void updateDigest(@Nullable Element data) {
                        }
                    };
                    String string = bundledKeymapProvider.getKeyFromFileName(fileName2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"provider.getKeyFromFileName(fileName)");
                    this.loadKeymapsFromElement(schemeDataHolder, string, bundledKeymapProvider.getClass());
                }
                catch (ProcessCanceledException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (CancellationException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (Throwable e$iv) {
                    $this$runAndLogException$iv.error(e$iv);
                }
            }
        }
    }

    public /* synthetic */ DefaultKeymap(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ExtensionPointName<BundledKeymapProvider> extensionPointName = BundledKeymapProvider.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"BundledKeymapProvider.EP_NAME");
            List list3 = extensionPointName.getExtensionList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"BundledKeymapProvider.EP_NAME.extensionList");
            list2 = list3;
        }
        this(list2);
    }

    @JvmOverloads
    public DefaultKeymap() {
        this(null, 1, null);
    }

    @NotNull
    public static final DefaultKeymap getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final boolean matchesPlatform(@NotNull Keymap keymap) {
        return Companion.matchesPlatform(keymap);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap$Companion;", "", "()V", "instance", "Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "instance$annotations", "getInstance", "()Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "matchesPlatform", "", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void instance$annotations() {
        }

        @NotNull
        public final DefaultKeymap getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(DefaultKeymap.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (DefaultKeymap)object;
        }

        @JvmStatic
        public final boolean matchesPlatform(@NotNull Keymap keymap) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)keymap, (String)"keymap");
            switch (keymap.getName()) {
                case "$default": {
                    bl = SystemInfo.isWindows;
                    break;
                }
                case "Mac OS X": 
                case "Mac OS X 10.5+": {
                    bl = SystemInfo.isMac;
                    break;
                }
                case "Default for GNOME": 
                case "Default for KDE": 
                case "Default for XWin": {
                    bl = SystemInfo.isXWindow;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

