/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import java.awt.Image;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockableEditorTabbedContainer
implements DockContainer.Persistent {
    private final EditorsSplitters mySplitters;
    private final Project myProject;
    private final CopyOnWriteArraySet<DockContainer.Listener> myListeners = new CopyOnWriteArraySet();
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private final boolean myDisposeWhenEmpty;
    private boolean myWasEverShown;

    DockableEditorTabbedContainer(Project project) {
        this(project, null, true);
    }

    DockableEditorTabbedContainer(Project project, @Nullable EditorsSplitters splitters, boolean disposeWhenEmpty) {
        this.myProject = project;
        this.mySplitters = splitters;
        this.myDisposeWhenEmpty = disposeWhenEmpty;
    }

    public String getDockContainerType() {
        return "file-editors";
    }

    public Element getState() {
        Element editors = new Element("state");
        this.mySplitters.writeExternal(editors);
        return editors;
    }

    void fireContentClosed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(0);
        }
        for (DockContainer.Listener each : this.myListeners) {
            each.contentRemoved((Object)file2);
        }
    }

    void fireContentOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(1);
        }
        for (DockContainer.Listener each : this.myListeners) {
            each.contentAdded((Object)file2);
        }
    }

    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    public RelativeRectangle getAcceptAreaFallback() {
        JRootPane root = this.mySplitters.getRootPane();
        return root != null ? new RelativeRectangle((JComponent)root) : new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(2);
        }
        DockContainer.ContentResponse contentResponse = this.getTabsAt(content2, point) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(3);
        }
        return contentResponse;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent content2, RelativePoint point) {
        if (content2 instanceof EditorTabbedContainer.DockableEditor) {
            JBTabs targetTabs = this.mySplitters.getTabsAt(point);
            if (targetTabs != null) {
                return targetTabs;
            }
            EditorWindow wnd = this.mySplitters.getCurrentWindow();
            if (wnd != null) {
                EditorTabbedContainer tabs = wnd.getTabbedPane();
                if (tabs != null) {
                    return tabs.getTabs();
                }
            } else {
                EditorWindow[] windows;
                for (EditorWindow each : windows = this.mySplitters.getWindows()) {
                    if (each.getTabbedPane() == null || each.getTabbedPane().getTabs() == null) continue;
                    return each.getTabbedPane().getTabs();
                }
            }
        }
        return null;
    }

    public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
        DataProvider provider;
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(4);
        }
        EditorWindow window = null;
        if (this.myCurrentOver != null && (provider = this.myCurrentOver.getDataProvider()) != null) {
            window = (EditorWindow)EditorWindow.DATA_KEY.getData(provider);
        }
        EditorTabbedContainer.DockableEditor dockableEditor = (EditorTabbedContainer.DockableEditor)content2;
        VirtualFile file2 = dockableEditor.getFile();
        if (window == null || window.isDisposed()) {
            window = this.mySplitters.getOrCreateCurrentWindow(file2);
        }
        if (this.myCurrentOver != null) {
            int index = ((JBTabsEx)this.myCurrentOver).getDropInfoIndex();
            file2.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
        }
        ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(this.myProject)).openFileImpl2(window, file2, true);
        window.setFilePinned(file2, dockableEditor.isPinned());
    }

    public Image startDropOver(@NotNull DockableContent content2, RelativePoint point) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(5);
        }
        return null;
    }

    public Image processDropOver(@NotNull DockableContent content2, RelativePoint point) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(6);
        }
        JBTabs current = this.getTabsAt(content2, point);
        if (this.myCurrentOver != null && this.myCurrentOver != current) {
            this.resetDropOver(content2);
        }
        if (this.myCurrentOver == null && current != null) {
            this.myCurrentOver = current;
            Presentation presentation = content2.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation.getText()).setIcon(presentation.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, point);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, point);
        }
        return this.myCurrentOverImg;
    }

    public void resetDropOver(@NotNull DockableContent content2) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(7);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
        }
    }

    public JComponent getContainerComponent() {
        return this.mySplitters;
    }

    public EditorsSplitters getSplitters() {
        return this.mySplitters;
    }

    public void close(VirtualFile file2) {
        this.mySplitters.closeFile(file2, false);
    }

    public void closeAll() {
        VirtualFile[] files2;
        for (VirtualFile each : files2 = this.mySplitters.getOpenFiles()) {
            this.close(each);
        }
    }

    public void addListener(final DockContainer.Listener listener2, Disposable parent) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DockableEditorTabbedContainer.this.myListeners.remove(listener2);
            }
        });
    }

    public boolean isEmpty() {
        return this.mySplitters.isEmptyVisible();
    }

    public void dispose() {
        this.closeAll();
    }

    public boolean isDisposeWhenEmpty() {
        return this.myDisposeWhenEmpty;
    }

    public void showNotify() {
        if (!this.myWasEverShown) {
            this.myWasEverShown = true;
            this.getSplitters().openFiles();
        }
    }

    public void hideNotify() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireContentClosed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireContentOpen";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentResponse";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startDropOver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDropOver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetDropOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

