/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk getJdk(@Nullable Project project, @Nullable String jdkName) throws ExternalSystemJdkException {
        return ExternalSystemJdkUtil.resolveJdkName(ExternalSystemJdkUtil.getProjectJdk(project), jdkName);
    }

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk resolveJdkName(@Nullable Sdk projectSdk, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        switch (jdkName) {
            case "#JAVA_INTERNAL": {
                return ExternalSystemJdkUtil.getInternalJdk();
            }
            case "#USE_PROJECT_JDK": {
                if (projectSdk != null) {
                    return projectSdk;
                }
                throw new ProjectJdkNotFoundException();
            }
            case "#JAVA_HOME": {
                return ExternalSystemJdkUtil.getJavaHomeJdk();
            }
        }
        return ExternalSystemJdkUtil.getJdk(jdkName);
    }

    @NotNull
    private static Sdk getProjectJdk(@Nullable Project project) {
        if (project != null) {
            Module[] modules;
            Sdk res2 = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (res2 != null) {
                Sdk sdk = res2;
                if (sdk == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(0);
                }
                return sdk;
            }
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                Sdk sdk2 = sdk;
                if (sdk2 == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(1);
                }
                return sdk2;
            }
        }
        SdkType jdkType = ExternalSystemJdkUtil.getJavaSdk();
        Sdk sdk = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)jdkType).stream().filter(it -> ExternalSystemJdkUtil.isValidJdk(it.getHomePath())).max(jdkType.versionComparator()).orElseGet(ExternalSystemJdkUtil::getInternalJdk);
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(2);
        }
        return sdk;
    }

    @NotNull
    private static Sdk getJavaHomeJdk() {
        String javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
        if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
            throw new UndefinedJavaHomeException();
        }
        if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
            throw new InvalidJavaHomeException(javaHome);
        }
        SimpleJavaSdkType sdkType = SimpleJavaSdkType.getInstance();
        String sdkName = sdkType.suggestSdkName(null, javaHome);
        Sdk sdk = sdkType.createJdk(sdkName, javaHome);
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    @Nullable
    private static Sdk getJdk(@NotNull String jdkName) {
        Sdk jdk;
        if (jdkName == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(4);
        }
        if ((jdk = ProjectJdkTable.getInstance().findJdk(jdkName)) == null) {
            return null;
        }
        String homePath = jdk.getHomePath();
        if (!ExternalSystemJdkUtil.isValidJdk(homePath)) {
            throw new InvalidSdkException(homePath);
        }
        return jdk;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project) throws ExternalSystemJdkException {
        String javaHome;
        List allJdks;
        Sdk mostRecentSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project != null) {
            Sdk projectJdk = ExternalSystemJdkUtil.findProjectJDK(project, javaSdkType);
            if (projectJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)projectJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(5);
                }
                return pair;
            }
            Sdk referencedJdk = ExternalSystemJdkUtil.findReferencedJDK(project);
            if (referencedJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)referencedJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(6);
                }
                return pair;
            }
        }
        if ((mostRecentSdk = (Sdk)(allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType)).stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(javaSdkType.versionComparator()).orElse(null)) != null) {
            Pair pair = Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            Pair pair = Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
        if (pair == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static Sdk findProjectJDK(@NotNull Project project, SdkType javaSdkType) {
        if (project == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(10);
        }
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Stream<Sdk> projectSdks = Stream.concat(Stream.of(projectSdk), Stream.of(ModuleManager.getInstance((Project)project).getModules()).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()));
        return projectSdks.filter(sdk -> sdk != null && sdk.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null);
    }

    private static Sdk findReferencedJDK(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null && projectSdk.getSdkType() instanceof DependentSdkType && projectSdk.getSdkType() instanceof JavaSdkType) {
            JavaSdkType sdkType = (JavaSdkType)projectSdk.getSdkType();
            String jdkPath = FileUtil.toSystemIndependentName((String)new File(sdkType.getBinPath(projectSdk)).getParent());
            return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> {
                String homePath = sdk.getHomePath();
                return homePath != null && FileUtil.toSystemIndependentName((String)homePath).equals(jdkPath);
            }).findFirst().orElse(null);
        }
        return null;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
        if (collection == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdk();
        if (sdkType == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(12);
        }
        return sdkType;
    }

    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        Sdk jdk = ExternalSystemJdkProvider.getInstance().createJdk(null, homePath);
        SdkConfigurationUtil.addSdk(jdk);
        Sdk sdk = jdk;
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(13);
        }
        return sdk;
    }

    @NotNull
    private static SdkType getJavaSdk() {
        SdkType sdkType = ExternalSystemJdkProvider.getInstance().getJavaSdkType();
        if (sdkType == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(14);
        }
        return sdkType;
    }

    @NotNull
    private static Sdk getInternalJdk() {
        Sdk sdk = ExternalSystemJdkProvider.getInstance().getInternalJdk();
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(15);
        }
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectJdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaHomeJdk";
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkHomePaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdkType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJdk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProjectJDK";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

