/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.MainRunner;
import com.intellij.ide.plugins.PluginManagerConfigurableProxy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager
extends PluginManagerCore {
    public static final String INSTALLED_TXT = "installed.txt";

    @Nullable
    public static File getOnceInstalledIfExists() {
        File onceInstalledFile = new File(PathManager.getConfigPath(), INSTALLED_TXT);
        return onceInstalledFile.isFile() ? onceInstalledFile : null;
    }

    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        MainRunner.processException(t);
    }

    public static void reportPluginError() {
        if (myPluginError != null) {
            String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
            Notifications.Bus.notify((Notification)new Notification(title, title, myPluginError, NotificationType.ERROR, (notification, event) -> {
                notification.expire();
                String description = event.getDescription();
                if ("edit".equals(description)) {
                    IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                    PluginManagerConfigurableProxy.showPluginConfigurable((JFrame)ideFrame, null, new IdeaPluginDescriptor[0]);
                    return;
                }
                LinkedHashSet<String> disabledPlugins = new LinkedHashSet<String>(PluginManager.disabledPlugins());
                if (myPlugins2Disable != null && "disable".equals(description)) {
                    disabledPlugins.addAll(myPlugins2Disable);
                } else if (myPlugins2Enable != null && "enable".equals(description)) {
                    disabledPlugins.removeAll(myPlugins2Enable);
                    PluginManagerMain.notifyPluginsUpdated(null);
                }
                try {
                    PluginManager.saveDisabledPlugins(disabledPlugins, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                myPlugins2Enable = null;
                myPlugins2Disable = null;
            }));
            myPluginError = null;
        }
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManager.getPlugin(id) != null;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        if (id != null) {
            for (IdeaPluginDescriptor plugin : PluginManager.getPlugins()) {
                if (id != plugin.getPluginId()) continue;
                return plugin;
            }
        }
        return null;
    }

    public static void handleComponentError(@NotNull Throwable t, @Nullable String componentClassName, @Nullable PluginId pluginId) {
        Application app;
        if (t == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        if ((app = ApplicationManager.getApplication()) != null && app.isUnitTestMode()) {
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (t instanceof MainRunner.StartupAbortedException) {
            throw (MainRunner.StartupAbortedException)t;
        }
        if ((pluginId == null || "com.intellij".equals(pluginId.getIdString())) && componentClassName != null) {
            pluginId = PluginManager.getPluginByClassName(componentClassName);
        }
        if (pluginId == null || "com.intellij".equals(pluginId.getIdString())) {
            if (t instanceof ExtensionInstantiationException) {
                pluginId = ((ExtensionInstantiationException)t).getExtensionOwnerId();
            } else if (t instanceof PicoPluginExtensionInitializationException) {
                pluginId = ((PicoPluginExtensionInitializationException)t).getPluginId();
            }
        }
        if (pluginId != null && !"com.intellij".equals(pluginId.getIdString())) {
            throw new MainRunner.StartupAbortedException("Fatal error initializing plugin " + pluginId.getIdString(), new PluginException(t, pluginId));
        }
        throw new MainRunner.StartupAbortedException("Fatal error initializing '" + componentClassName + "'", t);
    }

    public static IdeaPluginDescriptor findPluginIfInitialized(@NotNull Throwable t) {
        if (t == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        return PluginManager.arePluginsInitialized() ? PluginManager.getPlugin(IdeErrorsDialog.findPluginId(t)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/ide/plugins/PluginManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleComponentError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginIfInitialized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

