/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.UiInterceptors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    private static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static SdkLeakTracker myOldSdks;
    private ThreadTracker myThreadTracker;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private static int ourTestCount;

    protected Project getProject() {
        return ourProject;
    }

    protected Module getModule() {
        return ourModule;
    }

    @NotNull
    protected PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)this.getProject());
        }
        PsiManager psiManager = ourPsiManager;
        if (psiManager == null) {
            LightPlatformTestCase.$$$reportNull$$$0(0);
        }
        return psiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        IdeaTestApplication ideaTestApplication = ourApplication = IdeaTestApplication.getInstance();
        if (ideaTestApplication == null) {
            LightPlatformTestCase.$$$reportNull$$$0(1);
        }
        return ideaTestApplication;
    }

    static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)ourApplication));
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            LightPlatformTestCase.$$$reportNull$$$0(2);
        }
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) throws IOException {
        if (descriptor == null) {
            LightPlatformTestCase.$$$reportNull$$$0(3);
        }
        ourProjectDescriptor = descriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        File projectFile = FileUtil.createTempFile((String)"light_temp", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        LightPlatformTestCase.setProject(PlatformTestCase.createProject(projectFile, LIGHT_PROJECT_MARK + buffer));
        ourPathToKeep = projectFile.getPath();
        ourPsiManager = null;
        try {
            ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

                @Override
                public void moduleCreated(@NotNull Module module2) {
                    if (module2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ourModule = module2;
                }

                @Override
                public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                    if (sourceRoot == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ourSourceRoot = sourceRoot;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "sourceRoot";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleCreated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "sourceRootCreated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (Throwable e) {
            try {
                LightPlatformTestCase.closeAndDeleteProject();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new RuntimeException(e);
        }
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        LightPlatformTestCase.initApplication();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            ourApplication.setDataProvider(this);
            LightProjectDescriptor descriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
            this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(() -> this.isStressTest() || ApplicationManager.getApplication() == null || ApplicationManager.getApplication() instanceof MockApplication ? null : CodeStyle.getDefaultSettings());
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        SimpleLightProjectDescriptor simpleLightProjectDescriptor = new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK());
        if (simpleLightProjectDescriptor == null) {
            LightPlatformTestCase.$$$reportNull$$$0(4);
        }
        return simpleLightProjectDescriptor;
    }

    @NotNull
    public static Pair.NonNull<Project, Module> doSetup(@NotNull LightProjectDescriptor descriptor, @NotNull LocalInspectionTool[] localInspectionTools, @NotNull Disposable parentDisposable) throws Exception {
        if (descriptor == null) {
            LightPlatformTestCase.$$$reportNull$$$0(5);
        }
        if (localInspectionTools == null) {
            LightPlatformTestCase.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            LightPlatformTestCase.$$$reportNull$$$0(7);
        }
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        myOldSdks = new SdkLeakTracker();
        boolean reusedProject = true;
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
            reusedProject = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        Project project2 = ourProject;
        try {
            projectManagerEx.openTestProject(project2);
        }
        catch (Throwable e) {
            LightPlatformTestCase.setProject(null);
            throw e;
        }
        if (reusedProject) {
            WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project2).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        }
        MessageBusConnection connection = project2.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                TestCase.fail((String)"Adding modules is not permitted in light tests.");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/LightPlatformTestCase$2";
                objectArray[2] = "moduleAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(project2);
        InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, project2, parentDisposable);
        LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx((Project)project2).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + project2.isOpen() + "; disposed:" + project2.isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)project2.isInitialized());
        CodeStyle.setTemporarySettings((Project)project2, (CodeStyleSettings)new CodeStyleSettings());
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(() -> ((FileDocumentManagerImpl)((FileDocumentManagerImpl)manager)).dropAllUnsavedDocuments());
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        Pair.NonNull nonNull = Pair.createNonNull((Object)project2, (Object)ourModule);
        if (nonNull == null) {
            LightPlatformTestCase.$$$reportNull$$$0(8);
        }
        return nonNull;
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            LightPlatformTestCase.$$$reportNull$$$0(9);
        }
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            LightPlatformTestCase.$$$reportNull$$$0(10);
        }
        InspectionsKt.enableInspectionTool(this.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            LightPlatformTestCase.$$$reportNull$$$0(11);
        }
        InspectionsKt.enableInspectionTool(this.getProject(), tool, this.getTestRootDisposable());
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            LightPlatformTestCase.$$$reportNull$$$0(12);
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        new RunAll(() -> {
            if (ApplicationManager.getApplication() != null) {
                CodeStyle.dropTemporarySettings((Project)project2);
            }
        }, () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null && ourApplication != null) {
                LightPlatformTestCase.doTearDown(project2, ourApplication);
            }
        }, () -> {
            if (project2 != null) {
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).clearScopesCachesForModules();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> myOldSdks.checkForJdkTableLeaks(), () -> super.tearDown(), () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2), () -> {
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }).run();
    }

    public static void doTearDown(@NotNull Project project2, @NotNull IdeaTestApplication application) {
        if (project2 == null) {
            LightPlatformTestCase.$$$reportNull$$$0(13);
        }
        if (application == null) {
            LightPlatformTestCase.$$$reportNull$$$0(14);
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue()).append(() -> CodeStyle.dropTemporarySettings((Project)project2)).append(() -> LightPlatformTestCase.checkJavaSwingTimersAreDisposed()).append(() -> UsefulTestCase.doPostponedFormatting(project2)).append(() -> LookupManager.hideActiveLookup((Project)project2)).append(() -> ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).prepareForNextTest()).append(() -> {
            if (ProjectManager.getInstance() == null) {
                throw new AssertionError((Object)"Application components damaged");
            }
        }).append(() -> WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            FileDocumentManager manager;
            if (ourSourceRoot != null) {
                try {
                    for (VirtualFile child : ourSourceRoot.getChildren()) {
                        child.delete(LightPlatformTestCase.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((manager = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
            }
        })).append(() -> EditorHistoryManager.getInstance((Project)project2).removeAllFiles()).append(() -> LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed())).append(() -> {
            LightPlatformTestCase.clearEncodingManagerDocumentQueue();
            if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> LightPlatformTestCase.clearUncommittedDocuments(project2)).append(() -> ((HintManagerImpl)HintManager.getInstance()).cleanup()).append(() -> ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests()).append(() -> ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests()).append(() -> ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest()).append(() -> TemplateDataLanguageMappings.getInstance((Project)project2).cleanupForNextTest()).append(() -> ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest()).append(() -> ((StructureViewFactoryImpl)StructureViewFactory.getInstance((Project)project2)).cleanupForNextTest()).append(() -> PlatformTestCase.waitForProjectLeakingThreads(project2, 10L, TimeUnit.SECONDS)).append(() -> ProjectManagerEx.getInstanceEx().closeTestProject(project2)).append(() -> application.setDataProvider(null)).append(() -> UiInterceptors.clear()).append(() -> {
            ourTestCase = null;
        }).append(() -> CompletionProgressIndicator.cleanupForNextTest()).append(() -> {
            if (ourTestCount++ % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }).run();
    }

    public static void clearEncodingManagerDocumentQueue() {
        EncodingManager encodingManager = (EncodingManager)ServiceManager.getServiceIfCreated(EncodingManager.class);
        if (encodingManager instanceof EncodingManagerImpl) {
            ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
        }
    }

    private static void checkJavaSwingTimersAreDisposed() throws Exception {
        Method sharedInstance;
        Object timerQueue;
        Class<?> TimerQueueClass = Class.forName("javax.swing.TimerQueue");
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(TimerQueueClass, (Object)(timerQueue = (sharedInstance = ReflectionUtil.getMethod(TimerQueueClass, (String)"sharedInstance", (Class[])new Class[0])).invoke(null, new Object[0])), DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer != null) {
            long delay = timer.getDelay(TimeUnit.MILLISECONDS);
            String text = "(delayed for " + delay + "ms)";
            Method getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
            Timer swingTimer = (Timer)getTimer.invoke(timer, new Object[0]);
            text = "Timer (listeners: " + Arrays.asList(swingTimer.getActionListeners()) + ") " + text;
            try {
                throw new AssertionFailedError("Not disposed java.swing.Timer: " + text + "; queue:" + timerQueue);
            }
            catch (Throwable throwable) {
                swingTimer.stop();
                throw throwable;
            }
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        if (project2 == null) {
            LightPlatformTestCase.$$$reportNull$$$0(15);
        }
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        new RunAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (ApplicationManager.getApplication() == null) {
                return;
            }
            RunAll runAll = new RunAll(new ThrowableRunnable[0]);
            for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError((Editor)editor)).append(() -> EditorFactory.getInstance().releaseEditor(editor));
            }
            runAll.run();
        }).run();
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareImpl(this::startRunAndTear);
    }

    protected void runBareImpl(ThrowableRunnable<?> start) throws Exception {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                start.run();
            }
            finally {
                try {
                    Application application = ApplicationManager.getApplication();
                    if (application instanceof ApplicationEx) {
                        PlatformTestCase.cleanupApplicationCaches(this.getProject());
                    }
                    this.resetAllFields();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }));
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            LightPlatformTestCase.$$$reportNull$$$0(16);
        }
        return this.getProject() == null || this.getProject().isDisposed() ? null : new TestDataProvider(this.getProject()).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            LightPlatformTestCase.$$$reportNull$$$0(17);
        }
        return emptyModuleType;
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            LightPlatformTestCase.$$$reportNull$$$0(18);
        }
        if (text == null) {
            LightPlatformTestCase.$$$reportNull$$$0(19);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
        if (psiFile == null) {
            LightPlatformTestCase.$$$reportNull$$$0(20);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            LightPlatformTestCase.$$$reportNull$$$0(21);
        }
        if (text == null) {
            LightPlatformTestCase.$$$reportNull$$$0(22);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
        if (psiFile == null) {
            LightPlatformTestCase.$$$reportNull$$$0(23);
        }
        return psiFile;
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        String string = name;
        if (string == null) {
            LightPlatformTestCase.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)this.getProject());
        if (codeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(25);
        }
        return codeStyleSettings;
    }

    @NotNull
    protected CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        if (language == null) {
            LightPlatformTestCase.$$$reportNull$$$0(26);
        }
        CommonCodeStyleSettings commonCodeStyleSettings = this.getCurrentCodeStyleSettings().getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(27);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    protected <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> settingsClass) {
        if (settingsClass == null) {
            LightPlatformTestCase.$$$reportNull$$$0(28);
        }
        CustomCodeStyleSettings customCodeStyleSettings = this.getCurrentCodeStyleSettings().getCustomSettings(settingsClass);
        if (customCodeStyleSettings == null) {
            LightPlatformTestCase.$$$reportNull$$$0(29);
        }
        return (T)customCodeStyleSettings;
    }

    protected void commitDocument(@NotNull Document document) {
        if (document == null) {
            LightPlatformTestCase.$$$reportNull$$$0(30);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
    }

    protected void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    protected Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            LightPlatformTestCase.$$$reportNull$$$0(31);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    public static synchronized void closeAndDeleteProject() {
        File parent;
        Project project2 = ourProject;
        if (project2 == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!project2.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)project2, (Object)ourModule.getProject());
            File ioFile = new File(project2.getProjectFilePath());
            if (ioFile.exists()) {
                File dir = ioFile.getParentFile();
                if (dir.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)dir);
                } else {
                    FileUtil.delete((File)ioFile);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().forceCloseProject(project2, true));
        LightPlatformTestCase.assertTrue((boolean)project2.isDisposed());
        if (ourPathToKeep != null && (parent = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
            parent.delete();
        }
        LightPlatformTestCase.setProject(null);
        LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
        ourModule = null;
        if (ourPsiManager != null) {
            LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
            ourPsiManager = null;
        }
        ourPathToKeep = null;
    }

    protected static void setProject(Project project2) {
        ourProject = project2;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localInspectionTools";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initApplication";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doSetup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLocalInspectionTools";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createLightFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSetup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTools";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTool";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doTearDown";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedDocuments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createLightFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            if (moduleType == null) {
                SimpleLightProjectDescriptor.$$$reportNull$$$0(0);
            }
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.myModuleType;
            if (moduleType == null) {
                SimpleLightProjectDescriptor.$$$reportNull$$$0(1);
            }
            return moduleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleType.equals((Object)that.myModuleType)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            OrderRootType[] rootTypes;
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            for (OrderRootType rootType : rootTypes = new OrderRootType[]{OrderRootType.CLASSES, AnnotationOrderRootType.getInstance()}) {
                Object[] myUrls = this.mySdk.getRootProvider().getUrls(rootType);
                Object[] newUrls = newSdk.getRootProvider().getUrls(rootType);
                if (ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

