/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.MyTranscoder;
import com.intellij.ui.svg.SaxSvgDocumentFactory;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SVGLoader {
    private static SvgColorPatcher ourColorPatcher = null;
    public static final int ICON_DEFAULT_SIZE = 16;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            SVGLoader.$$$reportNull$$$0(0);
        }
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(1);
        }
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        return SVGLoader.load(url, stream, scale, null);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale, @Nullable ImageLoader.Dimension2DDouble dimension2DDouble) throws IOException {
        void docSize;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(3);
        }
        try {
            MyTranscoder transcoder = MyTranscoder.createImage(scale, SVGLoader.createTranscodeInput(url, stream));
            if (docSize != null) {
                docSize.setSize(transcoder.getOrigDocWidth(), transcoder.getOrigDocHeight());
            }
            return transcoder.getImage();
        }
        catch (TranscoderException ex) {
            if (docSize != null) {
                docSize.setSize(0.0, 0.0);
            }
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx, double width, double d) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(4);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(5);
        }
        try {
            void height;
            double s = ctx.getScale(DerivedScaleType.PIX_SCALE);
            return MyTranscoder.createImage(1.0, SVGLoader.createTranscodeInput(url, stream), (float)(width * s), (float)(height * s)).getImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx, double width, double d) throws IOException {
        void height;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(6);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx, width, (double)height);
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(7);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(DerivedScaleType.PIX_SCALE));
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    @Deprecated
    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(8);
        }
        return SVGLoader.loadHiDPI(url, stream, (ScaleContext)ctx);
    }

    public static ImageLoader.Dimension2DDouble getDocumentSize(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        int ch;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(9);
        }
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(100);
        byte[] bytes = new byte[3];
        boolean checkClosingBracket = false;
        while ((ch = stream.read()) != -1) {
            buffer.write(ch);
            if (ch == 60) {
                int n = stream.read(bytes, 0, 3);
                if (n == -1) break;
                buffer.write(bytes, 0, n);
                checkClosingBracket = n == 3 && bytes[0] == 115 && bytes[1] == 118 && bytes[2] == 103;
                continue;
            }
            if (!checkClosingBracket || ch != 62) continue;
            buffer.write(new byte[]{60, 47, 115, 118, 103, 62});
            return SVGLoader.getDocumentSize(scale, SVGLoader.createTranscodeInput(url, new ByteArrayInputStream(buffer.getInternalBuffer(), 0, buffer.size())));
        }
        return new ImageLoader.Dimension2DDouble(16.0 * scale, 16.0 * scale);
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(10);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(11);
        }
        ImageLoader.Dimension2DDouble size = SVGLoader.getDocumentSize(ctx.getScale(DerivedScaleType.PIX_SCALE), SVGLoader.createTranscodeInput(url, stream));
        double iconMaxSize2 = MyTranscoder.getIconMaxSize();
        return Math.min(iconMaxSize2 / size.getWidth(), iconMaxSize2 / size.getHeight());
    }

    private SVGLoader() {
    }

    @NotNull
    private static TranscoderInput createTranscodeInput(@Nullable URL url, @NotNull InputStream stream) throws IOException {
        TranscoderInput myTranscoderInput;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(12);
        }
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol())) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new SaxSvgDocumentFactory().createDocument(uri, stream);
        SVGLoader.patchColors(url, document);
        TranscoderInput transcoderInput = myTranscoderInput = new TranscoderInput(document);
        if (transcoderInput == null) {
            SVGLoader.$$$reportNull$$$0(13);
        }
        return transcoderInput;
    }

    private static void patchColors(URL url, Document document) {
        if (ourColorPatcher != null) {
            ourColorPatcher.patchColors(url, document.getDocumentElement());
        }
    }

    public static void setColorPatcher(@Nullable SvgColorPatcher colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    /*
     * WARNING - void declaration
     */
    private static ImageLoader.Dimension2DDouble getDocumentSize(double scale, @NotNull TranscoderInput transcoderInput) {
        void input;
        if (transcoderInput == null) {
            SVGLoader.$$$reportNull$$$0(14);
        }
        SVGOMDocument document = (SVGOMDocument)input.getDocument();
        BridgeContext ctx = new MyTranscoder(scale).createBridgeContext(document);
        new GVTBuilder().build(ctx, (Document)document);
        Dimension2D size = ctx.getDocumentSize();
        return new ImageLoader.Dimension2DDouble(size.getWidth() * scale, size.getHeight() * scale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SVGLoader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SVGLoader";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTranscodeInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentSize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTranscodeInput";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SvgColorPatcher {
        @Deprecated
        default public void patchColors(Element svg) {
        }

        default public void patchColors(URL url, Element svg) {
            this.patchColors(svg);
        }
    }
}

