/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a*\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\f"}, d2={"condaEnvFolder", "", "kotlin.jvm.PlatformType", "path", "findActivateInPath", "Ljava/io/File;", "shellName", "findActivateOnWindows", "findActivateScript", "Lkotlin/Pair;", "sdkPath", "shellPath", "intellij.python.community.impl"})
public final class PyVirtualEnvReaderKt {
    @Nullable
    public static final Pair<String, String> findActivateScript(@Nullable String sdkPath, @Nullable String shellPath) {
        if (PythonSdkType.isVirtualEnv(sdkPath)) {
            File activate;
            String shellName = shellPath != null ? new File(shellPath).getName() : null;
            String string = sdkPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return (activate = PyVirtualEnvReaderKt.findActivateInPath(string, shellName)) != null && activate.exists() ? new Pair((Object)activate.getAbsolutePath(), null) : null;
        }
        if (PythonSdkType.isConda(sdkPath)) {
            String condaExecutable;
            String string = sdkPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((condaExecutable = PyCondaPackageService.getCondaExecutable(string)) != null) {
                String string2 = new File(condaExecutable).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File(condaExecutable).path");
                File activate = PyVirtualEnvReaderKt.findActivateInPath(string2, null);
                if (activate != null && activate.exists()) {
                    return new Pair((Object)activate.getPath(), (Object)PyVirtualEnvReaderKt.condaEnvFolder(sdkPath));
                }
            }
        }
        return null;
    }

    private static final File findActivateInPath(String path, String shellName) {
        return SystemInfo.isWindows ? PyVirtualEnvReaderKt.findActivateOnWindows(path) : (Intrinsics.areEqual((Object)shellName, (Object)"fish") || Intrinsics.areEqual((Object)shellName, (Object)"csh") ? new File(new File(path).getParentFile(), "activate." + shellName) : new File(new File(path).getParentFile(), "activate"));
    }

    private static final String condaEnvFolder(String path) {
        String string;
        if (SystemInfo.isWindows) {
            string = new File(path).getParent();
        } else {
            File file = new File(path).getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(path).parentFile");
            string = file.getParent();
        }
        return string;
    }

    private static final File findActivateOnWindows(String path) {
        for (String location : CollectionsKt.arrayListOf((Object[])new String[]{"activate.bat", "Scripts/activate.bat"})) {
            File file = new File(new File(path).getParentFile(), location);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

