/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.WeakIndexCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.CompressionEnabled;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static Logger logger = LoggerFactory.getLogger(OWLDataFactoryInternalsImpl.class);
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final BuildableWeakIndexCache<OWLClass> classesByURI;
    @Nonnull
    private final BuildableWeakIndexCache<OWLObjectProperty> objectPropertiesByURI;
    @Nonnull
    private final BuildableWeakIndexCache<OWLDataProperty> dataPropertiesByURI;
    @Nonnull
    private final BuildableWeakIndexCache<OWLDatatype> datatypesByURI;
    @Nonnull
    private final BuildableWeakIndexCache<OWLNamedIndividual> individualsByURI;
    @Nonnull
    private final BuildableWeakIndexCache<OWLAnnotationProperty> annotationPropertiesByURI;
    @Nonnull
    private final transient Interner<String> languageTagInterner;
    private final transient LoadingCache<OWLAnnotation, OWLAnnotation> annotationsCache;
    private AtomicInteger annotationsCount = new AtomicInteger(0);

    @Nonnull
    protected final <V extends OWLEntity> BuildableWeakIndexCache<V> buildCache() {
        return new BuildableWeakIndexCache();
    }

    @Inject
    public OWLDataFactoryInternalsImpl(@CompressionEnabled boolean useCompression) {
        super(useCompression);
        this.classesByURI = this.buildCache();
        this.objectPropertiesByURI = this.buildCache();
        this.dataPropertiesByURI = this.buildCache();
        this.datatypesByURI = this.buildCache();
        this.individualsByURI = this.buildCache();
        this.annotationPropertiesByURI = this.buildCache();
        this.languageTagInterner = Interners.newWeakInterner();
        Caffeine builder = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(2L, TimeUnit.MINUTES);
        if (logger.isDebugEnabled()) {
            builder.recordStats();
        }
        this.annotationsCache = builder.build(k -> k);
    }

    @Override
    @Nonnull
    public OWLClass getOWLClass(IRI iri) {
        return this.classesByURI.cache(iri, Buildable.OWLCLASS);
    }

    @Override
    public void purge() {
        this.classesByURI.clear();
        this.objectPropertiesByURI.clear();
        this.dataPropertiesByURI.clear();
        this.datatypesByURI.clear();
        this.individualsByURI.clear();
        this.annotationPropertiesByURI.clear();
        this.annotationsCache.invalidateAll();
    }

    @Override
    @Nonnull
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectPropertiesByURI.cache(iri, Buildable.OWLOBJECTPROPERTY);
    }

    @Override
    @Nonnull
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataPropertiesByURI.cache(iri, Buildable.OWLDATAPROPERTY);
    }

    @Override
    @Nonnull
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individualsByURI.cache(iri, Buildable.OWLNAMEDINDIVIDUAL);
    }

    @Override
    @Nonnull
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypesByURI.cache(iri, Buildable.OWLDATATYPE);
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationPropertiesByURI.cache(iri, Buildable.OWLANNOTATIONPROPERTY);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        if (lang == null) {
            lang = "";
        }
        lang = (String)this.languageTagInterner.intern((Object)lang.trim().toLowerCase());
        return super.getOWLLiteral(literal, lang);
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        int n;
        OWLAnnotationImpl key = new OWLAnnotationImpl(property, value, annotations);
        OWLAnnotation annotation = (OWLAnnotation)this.annotationsCache.get((Object)key);
        if (logger.isDebugEnabled() && (n = this.annotationsCount.incrementAndGet()) % 1000 == 0) {
            logger.debug("{}: Annotations Cache stats: {}", (Object)n, (Object)this.annotationsCache.stats());
        }
        return annotation;
    }

    protected static enum Buildable {
        OWLCLASS{

            @Nonnull
            OWLClass build(@Nonnull IRI iri) {
                return new OWLClassImpl(iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            @Nonnull
            OWLObjectProperty build(@Nonnull IRI iri) {
                return new OWLObjectPropertyImpl(iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            @Nonnull
            OWLDataProperty build(@Nonnull IRI iri) {
                return new OWLDataPropertyImpl(iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            @Nonnull
            OWLNamedIndividual build(@Nonnull IRI iri) {
                return new OWLNamedIndividualImpl(iri);
            }
        }
        ,
        OWLDATATYPE{

            @Nonnull
            OWLDatatype build(@Nonnull IRI iri) {
                return new OWLDatatypeImpl(iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            @Nonnull
            OWLAnnotationProperty build(@Nonnull IRI iri) {
                return new OWLAnnotationPropertyImpl(iri);
            }
        };


        @Nonnull
        abstract <K extends OWLEntity> K build(@Nonnull IRI var1);
    }

    protected class BuildableWeakIndexCache<V extends OWLEntity>
    extends WeakIndexCache<IRI, V> {
        private static final long serialVersionUID = 40000L;

        protected BuildableWeakIndexCache() {
        }

        @Override
        @Nonnull
        public V cache(@Nonnull IRI s, @Nonnull Buildable v) {
            OWLEntity toReturn;
            WeakReference w = (WeakReference)this.prefixCache.get(s);
            if (w != null && (toReturn = (OWLEntity)w.get()) != null) {
                return (V)toReturn;
            }
            Object value = v.build(s);
            this.prefixCache.put(s, new WeakReference(value));
            return (V)value;
        }
    }
}

