/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.windows;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.windows.WindowsNetworkProxyLibrary;

public class WindowsNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(WindowsNetworkProxy.class.getName());
    private static final String HTTP_PROPERTY_NAME = "http=";
    private static final String HTTPS_PROPERTY_NAME = "https=";
    private static final String SOCKS_PROPERTY_NAME = "socks=";
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "Windows system proxy resolver started.");
        WindowsNetworkProxyLibrary.ProxyConfig.ByReference prxCnf = new WindowsNetworkProxyLibrary.ProxyConfig.ByReference();
        boolean result = WindowsNetworkProxyLibrary.LIBRARY.WinHttpGetIEProxyConfigForCurrentUser(prxCnf);
        if (result) {
            Pointer pacFilePointer;
            LOGGER.log(Level.FINE, "Windows system proxy resolver successfully retrieved proxy settings.");
            if (prxCnf.autoDetect) {
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto detect");
            }
            if ((pacFilePointer = prxCnf.pacFile) != null) {
                String pacFileUrl = pacFilePointer.getString(0L, true);
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto - PAC ({0})", pacFileUrl);
                return new NetworkProxySettings(pacFileUrl);
            }
            Pointer proxyPointer = prxCnf.proxy;
            Pointer proxyBypassPointer = prxCnf.proxyBypass;
            if (proxyPointer != null) {
                String[] noProxyHosts;
                String proxyString = proxyPointer.getString(0L, true);
                LOGGER.log(Level.INFO, "Windows system proxy resolver: manual ({0})", proxyString);
                String httpProxy = null;
                String httpsProxy = null;
                String socksProxy = null;
                if (proxyString != null) {
                    proxyString = proxyString.toLowerCase();
                }
                if (proxyString.contains(SEMI_COLON)) {
                    String[] proxies;
                    for (String singleProxy : proxies = proxyString.split(SEMI_COLON)) {
                        if (singleProxy.startsWith(HTTP_PROPERTY_NAME)) {
                            httpProxy = singleProxy.substring(HTTP_PROPERTY_NAME.length());
                            continue;
                        }
                        if (singleProxy.startsWith(HTTPS_PROPERTY_NAME)) {
                            httpsProxy = singleProxy.substring(HTTPS_PROPERTY_NAME.length());
                            continue;
                        }
                        if (!singleProxy.startsWith(SOCKS_PROPERTY_NAME)) continue;
                        socksProxy = singleProxy.substring(SOCKS_PROPERTY_NAME.length());
                    }
                } else if (proxyString.startsWith(HTTP_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(HTTP_PROPERTY_NAME.length());
                    httpProxy = proxyString.replace(SPACE, COLON);
                } else if (proxyString.startsWith(HTTPS_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(HTTPS_PROPERTY_NAME.length());
                    httpsProxy = proxyString.replace(SPACE, COLON);
                } else if (proxyString.startsWith(SOCKS_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(SOCKS_PROPERTY_NAME.length());
                    socksProxy = proxyString.replace(SPACE, COLON);
                } else {
                    httpProxy = proxyString;
                    httpsProxy = proxyString;
                }
                if (proxyBypassPointer != null) {
                    String proxyBypass = proxyBypassPointer.getString(0L, true);
                    LOGGER.log(Level.INFO, "Windows system proxy resolver: manual - no proxy hosts ({0})", proxyBypass);
                    noProxyHosts = proxyBypass.split(SEMI_COLON);
                } else {
                    noProxyHosts = new String[]{};
                }
                return new NetworkProxySettings(httpProxy, httpsProxy, socksProxy, noProxyHosts);
            }
            LOGGER.log(Level.FINE, "Windows system proxy resolver: no proxy");
            return new NetworkProxySettings();
        }
        LOGGER.log(Level.SEVERE, "Windows system proxy resolver cannot retrieve proxy settings from Windows API!");
        return new NetworkProxySettings(false);
    }
}

