/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.index.PrebuiltIndexProviderBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IndexedStubs;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.PrebuiltStubsProviders;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubCumulativeInputDiffBuilder;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.stubs.StubVersionMap;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SharedMapForwardIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements PsiDependentIndex,
CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    private static final int VERSION = 39 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(@NotNull DataOutput out, @NotNull SerializedStubTree v) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if (v == null) {
                1.$$$reportNull$$$0(1);
            }
            v.write(out);
        }

        @NotNull
        public SerializedStubTree read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(2);
            }
            SerializedStubTree serializedStubTree = new SerializedStubTree(in);
            if (serializedStubTree == null) {
                1.$$$reportNull$$$0(3);
            }
            return serializedStubTree;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    protected static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> StubUpdatingIndex.canHaveStub(file2);
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        FileType fileType;
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if ((fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), ProjectUtil.guessProjectForFile((VirtualFile)file2))) instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType) {
                if (((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                    return true;
                }
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (file2 instanceof NewVirtualFile && fileBasedIndex instanceof FileBasedIndexImpl && ((FileBasedIndexImpl)fileBasedIndex).getIndex(INDEX_ID).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2)) {
                    return true;
                }
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @Override
    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        SingleEntryIndexer<SerializedStubTree> singleEntryIndexer = new SingleEntryIndexer<SerializedStubTree>(false){

            @Override
            @Nullable
            public SerializedStubTree computeValue(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (SerializedStubTree)ReadAction.compute(() -> {
                    PrebuiltStubsProvider prebuiltStubsProvider;
                    Stub rootStub = null;
                    if (Registry.is((String)"use.prebuilt.indices") && (prebuiltStubsProvider = (PrebuiltStubsProvider)PrebuiltStubsProviders.INSTANCE.forFileType(inputData.getFileType())) != null) {
                        rootStub = prebuiltStubsProvider.findStub(inputData);
                        if (PrebuiltIndexProviderBase.DEBUG_PREBUILT_INDICES) {
                            Stub stub = StubTreeBuilder.buildStubTree(inputData);
                            if (rootStub != null && stub != null) {
                                StubUpdatingIndex.check(rootStub, stub);
                            }
                        }
                    }
                    if (rootStub == null) {
                        rootStub = StubTreeBuilder.buildStubTree(inputData);
                    }
                    if (rootStub == null) {
                        return null;
                    }
                    VirtualFile file2 = inputData.getFile();
                    boolean isBinary = file2.getFileType().isBinary();
                    int contentLength = isBinary ? -1 : inputData.getPsiFile().getTextLength();
                    long byteLength = file2.getLength();
                    StubUpdatingIndex.rememberIndexingStamp(file2, isBinary, byteLength, contentLength);
                    BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                    SerializationManagerEx.getInstanceEx().serialize(rootStub, (OutputStream)bytes);
                    if (DebugAssertions.DEBUG) {
                        try {
                            Stub deserialized = SerializationManagerEx.getInstanceEx().deserialize(bytes.toInputStream());
                            StubUpdatingIndex.check(deserialized, rootStub);
                        }
                        catch (ProcessCanceledException pce) {
                            throw pce;
                        }
                        catch (Throwable t) {
                            LOG.error("Error indexing:" + file2, t);
                        }
                    }
                    SerializedStubTree serializedStubTree = new SerializedStubTree(bytes.getInternalBuffer(), bytes.size(), rootStub);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Indexing " + file2 + "; " + IndexingStampInfo.dumpSize(byteLength, contentLength));
                    }
                    try {
                        serializedStubTree.indexTree();
                    }
                    catch (SerializerNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                    return serializedStubTree;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/stubs/StubUpdatingIndex$2", "computeValue"));
            }
        };
        if (singleEntryIndexer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        return singleEntryIndexer;
    }

    private static void check(@NotNull Stub stub, @NotNull Stub stub2) {
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i = 0; i < len; ++i) {
            StubUpdatingIndex.check((Stub)stubs.get(i), (Stub)stubs2.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void rememberIndexingStamp(@NotNull VirtualFile file2, boolean isBinary, long contentByteLength, int n) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            void contentCharLength;
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentByteLength);
            boolean lengthsAreTheSame = contentByteLength == (long)contentCharLength;
            byte flags = 0;
            flags = BitUtil.set((byte)flags, (byte)1, (boolean)isBinary);
            flags = BitUtil.set((byte)flags, (byte)2, (boolean)lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !isBinary) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)contentCharLength);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long byteLength = DataInputOutputUtil.readLONG((DataInput)stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet((byte)flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet((byte)flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT((DataInput)stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        DataExternalizer<SerializedStubTree> dataExternalizer = KEY_EXTERNALIZER;
        if (dataExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        return inputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
        if (extension == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        if (storage == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        if (storage instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        MyIndex myIndex = new MyIndex(extension, storage);
        if (myIndex == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        return myIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rememberIndexingStamp";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private StubIndexImpl myStubIndex;
        private final StubVersionMap myStubVersionMap;
        private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.versionStamp", 2, true);

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
            if (extension == null) {
                MyIndex.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                MyIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage, new SharedMapForwardIndex((IndexExtension<?, ?, ?>)extension, null, IndexInfrastructure.getInputIndexStorageFile(extension.getName()), false), new StubUpdatingForwardIndexAccessor(), null);
            this.myStubVersionMap = new StubVersionMap();
            MyIndex.checkNameStorage();
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            StubIndexImpl stubIndexImpl = index;
            if (stubIndexImpl == null) {
                MyIndex.$$$reportNull$$$0(2);
            }
            return stubIndexImpl;
        }

        private static void checkNameStorage() throws StorageException {
            SerializationManagerEx serializationManager = SerializationManagerEx.getInstanceEx();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        @Override
        protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Integer, ? extends SerializedStubTree> map2) {
            if (map2 == null) {
                MyIndex.$$$reportNull$$$0(3);
            }
            IndexedStubs indexedStubs = StubUpdatingForwardIndexAccessor.getIndexedStubs(map2);
            super.removeTransientDataForInMemoryKeys(inputId, map2);
            MyIndex.removeStubIndexKeys(inputId, indexedStubs);
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys) {
            IndexedStubs indexedStubs;
            if (keys == null) {
                MyIndex.$$$reportNull$$$0(4);
            }
            try {
                StubUpdatingForwardIndexAccessor forwardIndexAccessor = (StubUpdatingForwardIndexAccessor)this.getForwardIndexAccessor();
                indexedStubs = (IndexedStubs)forwardIndexAccessor.deserializeData(this.getForwardIndexMap().get(Integer.valueOf(inputId)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            super.removeTransientDataForKeys(inputId, keys);
            MyIndex.removeStubIndexKeys(inputId, indexedStubs);
        }

        private static void removeStubIndexKeys(int inputId, @Nullable IndexedStubs indexedStubs) {
            Map<Object, Object> stubIndicesValueMap = indexedStubs != null ? indexedStubs.getStubIndicesValueMap() : Collections.emptyMap();
            StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
            for (StubIndexKey stubIndexKey : stubIndicesValueMap.keySet()) {
                stubIndex.removeTransientDataForFile(stubIndexKey, inputId, ((Map)stubIndicesValueMap.get(stubIndexKey)).keySet());
            }
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            this.myStubVersionMap.clear();
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        @NotNull
        protected InputDataDiffBuilder<Integer, SerializedStubTree> getKeysDiffBuilderInMemoryMode(int inputId, @NotNull Map<Integer, SerializedStubTree> keysAndValues) {
            if (keysAndValues == null) {
                MyIndex.$$$reportNull$$$0(5);
            }
            StubCumulativeInputDiffBuilder stubCumulativeInputDiffBuilder = new StubCumulativeInputDiffBuilder(inputId, StubUpdatingForwardIndexAccessor.getIndexedStubs(keysAndValues));
            if (stubCumulativeInputDiffBuilder == null) {
                MyIndex.$$$reportNull$$$0(6);
            }
            return stubCumulativeInputDiffBuilder;
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(7);
            }
            super.setIndexedStateForFile(fileId, file2);
            try (com.intellij.util.io.DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStubVersionMap.getIndexingTimestampDiffForFileType(file2.getFileType()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            boolean indexedStateForFile;
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(8);
            }
            if (!(indexedStateForFile = super.isIndexedStateForFile(fileId, file2))) {
                return false;
            }
            try {
                int diff;
                DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);
                int n = diff = stream != null ? DataInputOutputUtil.readINT((DataInput)stream) : 0;
                if (diff == 0) {
                    return false;
                }
                FileType fileType = this.myStubVersionMap.getFileTypeByIndexingTimestampDiff(diff);
                return fileType != null && this.myStubVersionMap.getStamp(file2.getFileType()) == this.myStubVersionMap.getStamp(fileType);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keysAndValues";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndex";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeysDiffBuilderInMemoryMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForInMemoryKeys";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForKeys";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeysDiffBuilderInMemoryMode";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setIndexedStateForFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isIndexedStateForFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

