/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.HttpUrlCellAppearance;
import com.intellij.openapi.roots.ui.util.JarSubfileCellAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.roots.ui.util.ValidFileCellAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileAppearanceServiceImpl
extends FileAppearanceService {
    private static final CellAppearanceEx EMPTY = new CellAppearanceEx(){

        public void customize(@NotNull SimpleColoredComponent component) {
            if (component == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String getText() {
            if ("" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customize";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public CellAppearanceEx empty() {
        CellAppearanceEx cellAppearanceEx = EMPTY;
        if (cellAppearanceEx == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(0);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(1);
        }
        if (!file2.isValid()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(file2.getPresentableUrl());
            if (cellAppearanceEx == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(2);
            }
            return cellAppearanceEx;
        }
        VirtualFileSystem fileSystem = file2.getFileSystem();
        if (fileSystem.getProtocol().equals("jar")) {
            JarSubfileCellAppearance jarSubfileCellAppearance = new JarSubfileCellAppearance(file2);
            if (jarSubfileCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(3);
            }
            return jarSubfileCellAppearance;
        }
        if (fileSystem instanceof HttpFileSystem) {
            HttpUrlCellAppearance httpUrlCellAppearance = new HttpUrlCellAppearance(file2);
            if (httpUrlCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(4);
            }
            return httpUrlCellAppearance;
        }
        if (file2.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)file2.getPresentableUrl(), (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(5);
            }
            return simpleTextCellAppearance;
        }
        ValidFileCellAppearance validFileCellAppearance = new ValidFileCellAppearance(file2);
        if (validFileCellAppearance == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(6);
        }
        return validFileCellAppearance;
    }

    @NotNull
    public CellAppearanceEx forIoFile(@NotNull File file2) {
        if (file2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(7);
        }
        String absolutePath = file2.getAbsolutePath();
        if (!file2.exists()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(absolutePath);
            if (cellAppearanceEx == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(8);
            }
            return cellAppearanceEx;
        }
        if (file2.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)absolutePath, (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(9);
            }
            return simpleTextCellAppearance;
        }
        String name = file2.getName();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        File parent = file2.getParentFile();
        CompositeAppearance appearance = CompositeAppearance.textComment((String)name, (String)parent.getAbsolutePath());
        appearance.setIcon(fileType.getIcon());
        CompositeAppearance compositeAppearance = appearance;
        if (compositeAppearance == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(10);
        }
        return compositeAppearance;
    }

    @NotNull
    public CellAppearanceEx forInvalidUrl(@NotNull String text2) {
        if (text2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(11);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)text2, (Icon)PlatformIcons.INVALID_ENTRY_ICON);
        if (simpleTextCellAppearance == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(12);
        }
        return simpleTextCellAppearance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forVirtualFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "forIoFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "forInvalidUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forVirtualFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forIoFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forInvalidUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

