/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class SuggestedChildRootInfo {
    private final VirtualFile myRootCandidate;
    private final DetectedLibraryRoot myDetectedRoot;
    private final Map<LibraryRootType, String> myRootTypeNames;
    private LibraryRootType mySelectedRootType;

    SuggestedChildRootInfo(@NotNull VirtualFile rootCandidate, @NotNull DetectedLibraryRoot detectedRoot, @NotNull Map<LibraryRootType, String> rootTypeNames) {
        if (rootCandidate == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(0);
        }
        if (detectedRoot == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(1);
        }
        if (rootTypeNames == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(2);
        }
        this.myRootCandidate = rootCandidate;
        this.myDetectedRoot = detectedRoot;
        this.myRootTypeNames = rootTypeNames;
        this.mySelectedRootType = detectedRoot.getTypes().get(0);
    }

    @NotNull
    public VirtualFile getRootCandidate() {
        VirtualFile virtualFile = this.myRootCandidate;
        if (virtualFile == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public DetectedLibraryRoot getDetectedRoot() {
        DetectedLibraryRoot detectedLibraryRoot = this.myDetectedRoot;
        if (detectedLibraryRoot == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(4);
        }
        return detectedLibraryRoot;
    }

    public String getRootTypeName(LibraryRootType type) {
        return this.myRootTypeNames.get(type);
    }

    @NotNull
    public LibraryRootType getSelectedRootType() {
        LibraryRootType libraryRootType = this.mySelectedRootType;
        if (libraryRootType == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(5);
        }
        return libraryRootType;
    }

    public void setSelectedRootType(String selectedRootType) {
        for (LibraryRootType type : this.myDetectedRoot.getTypes()) {
            if (!this.getRootTypeName(type).equals(selectedRootType)) continue;
            this.mySelectedRootType = type;
            break;
        }
    }

    @NotNull
    public String[] getRootTypeNames() {
        String[] types = ArrayUtilRt.toStringArray(this.myRootTypeNames.values());
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        if (types == null) {
            SuggestedChildRootInfo.$$$reportNull$$$0(6);
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCandidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRootType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTypeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

