/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputWrapper
extends OutputStream {
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @Nullable
    private StringBuilder myBuffer;
    private final boolean myStdOut;

    public OutputWrapper(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId, boolean stdOut) {
        if (listener2 == null) {
            OutputWrapper.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            OutputWrapper.$$$reportNull$$$0(1);
        }
        this.myListener = listener2;
        this.myTaskId = taskId;
        this.myStdOut = stdOut;
    }

    @Override
    public void write(int b) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        char c2 = (char)b;
        this.myBuffer.append(c2);
        if (c2 == '\n') {
            this.doFlush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int start2 = off;
        int maxOffset = off + len;
        for (int i = off; i < maxOffset; ++i) {
            if (b[i] != 10) continue;
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start2, i - start2 + 1, StandardCharsets.UTF_8));
            this.doFlush();
            start2 = i + 1;
        }
        if (start2 < maxOffset) {
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start2, maxOffset - start2, StandardCharsets.UTF_8));
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        this.myListener.onTaskOutput(this.myTaskId, this.myBuffer.toString(), this.myStdOut);
        this.myBuffer.setLength(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "taskId";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/util/OutputWrapper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

