/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.constraints.BaseConstrainedExecution;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.constraints.ExpirableConstrainedExecution;
import com.intellij.openapi.application.constraints.Expiration;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public class NonBlockingReadActionImpl<T>
extends ExpirableConstrainedExecution<NonBlockingReadActionImpl<T>>
implements NonBlockingReadAction<T> {
    @Nullable
    private final Pair<ModalityState, Consumer<T>> myEdtFinish;
    private final Callable<T> myComputation;
    private static final Set<CancellablePromise<?>> ourTasks = ContainerUtil.newConcurrentSet();

    NonBlockingReadActionImpl(@NotNull Callable<T> computation) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(0);
        }
        this(computation, null, new ConstrainedExecution.ContextConstraint[0], new BooleanSupplier[0], Collections.emptySet());
    }

    private NonBlockingReadActionImpl(@NotNull Callable<T> computation, @Nullable Pair<ModalityState, Consumer<T>> edtFinish, @NotNull ConstrainedExecution.ContextConstraint[] constraints, @NotNull BooleanSupplier[] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(1);
        }
        if (constraints == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(2);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(3);
        }
        if (expirationSet == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(4);
        }
        super(constraints, cancellationConditions, expirationSet);
        this.myComputation = computation;
        this.myEdtFinish = edtFinish;
    }

    @Override
    @NotNull
    protected NonBlockingReadActionImpl<T> cloneWith(@NotNull ConstrainedExecution.ContextConstraint[] constraints, @NotNull BooleanSupplier[] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet) {
        if (constraints == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(5);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(6);
        }
        if (expirationSet == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(7);
        }
        NonBlockingReadActionImpl<T> nonBlockingReadActionImpl = new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, constraints, cancellationConditions, expirationSet);
        if (nonBlockingReadActionImpl == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(8);
        }
        return nonBlockingReadActionImpl;
    }

    @Override
    public void dispatchLaterUnconstrained(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any());
    }

    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(10);
        }
        return (NonBlockingReadAction)this.withConstraint(new InSmartMode(project), (Disposable)project);
    }

    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(11);
        }
        return (NonBlockingReadAction)this.withConstraint(new WithDocumentsCommitted(project, ModalityState.any()), (Disposable)project);
    }

    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(12);
        }
        return (NonBlockingReadAction)this.cancelIf(expireCondition);
    }

    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<T> uiThreadAction) {
        if (modality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(13);
        }
        if (uiThreadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(14);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, Pair.create((Object)modality, uiThreadAction), this.getConstraints(), this.getCancellationConditions(), this.getExpirationSet());
    }

    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        if (backgroundThreadExecutor == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(15);
        }
        AsyncPromise promise = new AsyncPromise();
        new Submission(promise, backgroundThreadExecutor).transferToBgThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourTasks.add((CancellablePromise<?>)promise);
            promise.onProcessed(__ -> ourTasks.remove(promise));
        }
        return promise;
    }

    public static void cancelAllTasks() {
        while (!ourTasks.isEmpty()) {
            for (CancellablePromise<?> task2 : ourTasks) {
                task2.cancel();
            }
            WriteAction.run(() -> {});
        }
    }

    public static void waitForAsyncTaskCompletion() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        for (CancellablePromise<?> task2 : ourTasks) {
            NonBlockingReadActionImpl.waitForTask(task2);
        }
    }

    private static void waitForTask(@NotNull CancellablePromise<?> task2) {
        if (task2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(16);
        }
        int iteration = 0;
        while (!task2.isDone() && iteration++ < 60000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task2.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task2.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)"Too long async task");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationConditions";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirationSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expireCondition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundThreadExecutor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneWith";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dispatchLaterUnconstrained";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inSmartMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentsCommitted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expireWhen";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "finishOnUiThread";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Submission {
        private final AsyncPromise<? super T> promise;
        @NotNull
        private final Executor backendExecutor;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality;
        @Nullable
        private final BooleanSupplier myExpireCondition;

        Submission(@NotNull AsyncPromise<? super T> promise, Executor backgroundThreadExecutor) {
            if (backgroundThreadExecutor == null) {
                Submission.$$$reportNull$$$0(0);
            }
            this.creationModality = ModalityState.defaultModalityState();
            this.promise = promise;
            this.backendExecutor = backgroundThreadExecutor;
            promise.onError(__ -> {
                ProgressIndicator indicator = this.currentIndicator;
                if (indicator != null) {
                    indicator.cancel();
                }
            });
            Expiration expiration = NonBlockingReadActionImpl.this.composeExpiration();
            if (expiration != null) {
                Expiration.Handle expirationHandle = expiration.invokeOnExpiration(() -> promise.cancel());
                promise.onProcessed(value -> expirationHandle.unregisterHandler());
            }
            this.myExpireCondition = NonBlockingReadActionImpl.this.composeCancellationCondition();
        }

        void transferToBgThread() {
            this.transferToBgThread(BaseConstrainedExecution.ReschedulingAttempt.NULL);
        }

        void transferToBgThread(@NotNull BaseConstrainedExecution.ReschedulingAttempt previousAttempt) {
            if (previousAttempt == null) {
                Submission.$$$reportNull$$$0(1);
            }
            this.backendExecutor.execute(() -> {
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(this.creationModality);
                this.currentIndicator = indicator;
                try {
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.lambda$null$2((ProgressIndicator)indicator), (ProgressIndicator)indicator);
                }
                finally {
                    this.currentIndicator = null;
                }
                if (Promises.isPending(this.promise)) {
                    ReadAction.run(() -> {
                        if (!this.checkObsolete()) {
                            NonBlockingReadActionImpl.this.doScheduleWithinConstraints(attempt -> NonBlockingReadActionImpl.this.dispatchLaterUnconstrained(() -> this.transferToBgThread((BaseConstrainedExecution.ReschedulingAttempt)attempt)), previousAttempt);
                        }
                    });
                }
            });
        }

        void insideReadAction(ProgressIndicator indicator) {
            block5: {
                try {
                    if (this.checkObsolete() || !this.constraintsAreSatisfied()) {
                        return;
                    }
                    Object result2 = NonBlockingReadActionImpl.this.myComputation.call();
                    if (NonBlockingReadActionImpl.this.myEdtFinish != null) {
                        this.safeTransferToEdt(result2, NonBlockingReadActionImpl.this.myEdtFinish, indicator);
                    } else {
                        this.promise.setResult(result2);
                    }
                }
                catch (Throwable e) {
                    if (indicator.isCanceled()) break block5;
                    this.promise.setError(e);
                }
            }
        }

        private boolean constraintsAreSatisfied() {
            return ArraysKt.all((Object[])NonBlockingReadActionImpl.this.getConstraints(), ConstrainedExecution.ContextConstraint::isCorrectContext);
        }

        private boolean checkObsolete() {
            if (this.promise.isCancelled()) {
                return true;
            }
            if (this.myExpireCondition != null && this.myExpireCondition.getAsBoolean()) {
                this.promise.cancel();
                return true;
            }
            return false;
        }

        void safeTransferToEdt(T result2, Pair<? extends ModalityState, ? extends Consumer<T>> edtFinish, ProgressIndicator indicator) {
            if (Promises.isRejected(this.promise)) {
                return;
            }
            Semaphore semaphore = new Semaphore(1);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (indicator.isCanceled()) {
                    return;
                }
                if (this.checkObsolete()) {
                    semaphore.up();
                    return;
                }
                this.promise.setResult(result2);
                semaphore.up();
                if (this.promise.isSucceeded()) {
                    ((Consumer)edtFinish.second).accept(result2);
                }
            }, (ModalityState)edtFinish.first);
            while (!semaphore.waitFor(10L)) {
                if (!indicator.isCanceled()) continue;
                throw new ProcessCanceledException();
            }
        }

        private /* synthetic */ void lambda$null$2(ProgressIndicator indicator) {
            this.insideReadAction(indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backgroundThreadExecutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousAttempt";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "transferToBgThread";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

