/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsPersistence {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence");
    private static final String LEGACY_PERSISTENCE_STATE_FILE = "fus-previous-state.data";
    private static final String PERSISTENCE_STATE_FILE = "fus-state.data";
    private static final String SENT_DATA_FILE = "fus-sent-data.json";
    public static final String FUS_CACHE_PATH = "fus-sessions";

    public static void clearLegacyStates() {
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getSentDataFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getLegacyStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getPersistenceStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsCacheDirectory());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsLegacyCacheDirectory());
    }

    private static void deleteCaches(@Nullable File dir) {
        if (dir != null && dir.exists()) {
            try {
                boolean delete = FileUtil.delete((File)dir);
                if (!delete) {
                    LOG.info("Failed deleting legacy caches");
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Nullable
    public static File getStatisticsCacheDirectory() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("fus-sessions/").toFile();
    }

    @Nullable
    public static File getStatisticsLegacyCacheDirectory() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve(FUS_CACHE_PATH).toFile();
    }

    @NotNull
    public static File getPersistenceStateFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(PERSISTENCE_STATE_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @NotNull
    private static File getLegacyStateFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(LEGACY_PERSISTENCE_STATE_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    private static File getFileInStatisticsCacheDirectory(@NotNull String fileName2) {
        if (fileName2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(2);
        }
        File file2 = new File(FUStatisticsPersistence.getStatisticsCacheDirectory(), "/" + fileName2);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public static File getSentDataFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(SENT_DATA_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(4);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceStateFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyStateFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInStatisticsCacheDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileInStatisticsCacheDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

