/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsWhiteListGroupsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.whiteList.FUStatisticsWhiteListGroupsService");

    @Nullable
    public static FUSWhitelist getApprovedGroups(@NotNull String serviceUrl) {
        String content2;
        if (serviceUrl == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(0);
        }
        return (content2 = FUStatisticsWhiteListGroupsService.getFUSWhiteListContent(serviceUrl)) != null ? FUStatisticsWhiteListGroupsService.parseApprovedGroups(content2) : null;
    }

    @Nullable
    public static String loadWhiteListFromServer(@NotNull EventLogExternalSettingsService settingsService) {
        if (settingsService == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(1);
        }
        return FUStatisticsWhiteListGroupsService.getFUSWhiteListContent(settingsService.getWhiteListProductUrl());
    }

    public static long lastModifiedWhitelist(@NotNull EventLogExternalSettingsService settingsService) {
        if (settingsService == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(2);
        }
        return FUStatisticsWhiteListGroupsService.lastModifiedWhitelist(settingsService.getWhiteListProductUrl());
    }

    @Nullable
    private static String getFUSWhiteListContent(@Nullable String serviceUrl) {
        if (StringUtil.isEmptyOrSpaces((String)serviceUrl)) {
            return null;
        }
        String content2 = null;
        try {
            content2 = HttpRequests.request((String)serviceUrl).productNameAsUserAgent().readString(null);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return content2;
    }

    private static long lastModifiedWhitelist(@Nullable String serviceUrl) {
        try {
            if (!StringUtil.isEmptyOrSpaces((String)serviceUrl)) {
                return (Long)HttpRequests.head((String)serviceUrl).productNameAsUserAgent().connect(r -> r.getConnection().getLastModified());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return 0L;
    }

    @Nullable
    public static WLGroups parseWhiteListContent(@Nullable String content2) {
        if (StringUtil.isEmptyOrSpaces((String)content2)) {
            return null;
        }
        WLGroups groups = null;
        try {
            groups = (WLGroups)new GsonBuilder().create().fromJson(content2, WLGroups.class);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return groups;
    }

    @VisibleForTesting
    @NotNull
    public static FUSWhitelist parseApprovedGroups(@Nullable String content2) {
        WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(content2);
        if (groups == null) {
            FUSWhitelist fUSWhitelist = FUSWhitelist.empty();
            if (fUSWhitelist == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(3);
            }
            return fUSWhitelist;
        }
        HashMap<String, FUSWhitelist.GroupFilterCondition> groupToCondition = new HashMap<String, FUSWhitelist.GroupFilterCondition>();
        for (WLGroup group : groups.groups) {
            if (!group.isValid()) continue;
            groupToCondition.put(group.id, FUStatisticsWhiteListGroupsService.toCondition(group.builds, group.versions));
        }
        FUSWhitelist fUSWhitelist = FUSWhitelist.create(groupToCondition);
        if (fUSWhitelist == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(4);
        }
        return fUSWhitelist;
    }

    @NotNull
    private static FUSWhitelist.GroupFilterCondition toCondition(@Nullable List<WLBuild> builds, @Nullable List<WLVersion> versions) {
        List buildRanges = builds != null ? ContainerUtil.map(builds, b -> FUSWhitelist.BuildRange.create(b.from, b.to)) : Collections.emptyList();
        List versionRanges = versions != null ? ContainerUtil.map(versions, v -> FUSWhitelist.VersionRange.create(v.from, v.to)) : Collections.emptyList();
        FUSWhitelist.GroupFilterCondition groupFilterCondition = new FUSWhitelist.GroupFilterCondition(buildRanges, versionRanges);
        if (groupFilterCondition == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(5);
        }
        return groupFilterCondition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseApprovedGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApprovedGroups";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadWhiteListFromServer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lastModifiedWhitelist";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WLBuild {
        public String from;
        public String to;

        private WLBuild() {
        }

        public boolean contains(BuildNumber build2) {
            return !(!StringUtil.isEmpty((String)this.to) && BuildNumber.fromString((String)this.to).compareTo(build2) <= 0 || !StringUtil.isEmpty((String)this.from) && BuildNumber.fromString((String)this.from).compareTo(build2) > 0);
        }
    }

    public static class WLRule {
        @Nullable
        public Set<String> event_id;
        @Nullable
        public Map<String, Set<String>> event_data;
        @Nullable
        public Map<String, Set<String>> enums;
        @Nullable
        public Map<String, String> regexps;
    }

    public static class WLVersion {
        public final String from;
        public final String to;

        public WLVersion(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class WLGroup {
        @Nullable
        public String id;
        @Nullable
        public final ArrayList<WLBuild> builds = new ArrayList();
        @Nullable
        public final ArrayList<WLVersion> versions = new ArrayList();
        @Nullable
        public WLRule rules;

        public boolean accepts(BuildNumber current) {
            if (!this.isValid()) {
                return false;
            }
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            return !hasBuilds || this.builds.stream().anyMatch(build2 -> build2.contains(current));
        }

        private boolean isValid() {
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            boolean hasVersions = this.versions != null && !this.versions.isEmpty();
            return StringUtil.isNotEmpty((String)this.id) && (hasBuilds || hasVersions);
        }
    }

    public static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();
        @Nullable
        public Map<String, Set<String>> globalEnums;
        @Nullable
        public WLRule rules;
        @Nullable
        public String version;
    }
}

