/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceModelFilter;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ServiceViewModel
implements Disposable,
InvokerSupplier {
    protected final ServiceModel myModel;
    protected final ServiceModelFilter myModelFilter;
    private final ServiceModelFilter.ServiceViewFilter myFilter;
    private final List<ServiceViewModelListener> myListeners;
    private volatile boolean myShowGroups;
    private volatile boolean myShowContributorRoots;

    protected ServiceViewModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, ServiceModelFilter.ServiceViewFilter condition) {
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(0);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(1);
        }
        this.myListeners = new CopyOnWriteArrayList<ServiceViewModelListener>();
        this.myModel = model2;
        this.myModelFilter = modelFilter;
        this.myFilter = condition;
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getRoots() {
        List roots = this.processGroups(this.doGetRoots());
        if (roots.stream().anyMatch(ServiceModel.ContributorNode.class::isInstance)) {
            roots = this.myShowContributorRoots ? ContainerUtil.filter(roots, item -> !(item instanceof ServiceModel.ContributorNode) || !this.getChildren((ServiceModel.ServiceViewItem)item).isEmpty()) : roots.stream().flatMap(item -> item instanceof ServiceModel.ContributorNode ? this.getChildren((ServiceModel.ServiceViewItem)item).stream() : Stream.of(item)).collect(Collectors.toList());
        }
        List list2 = roots;
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    protected abstract List<? extends ServiceModel.ServiceViewItem> doGetRoots();

    abstract void eventProcessed(ServiceEventListener.ServiceEvent var1);

    void saveState(ServiceViewState viewState) {
        viewState.groupByServiceGroups = this.myShowGroups;
        viewState.groupByContributor = this.myShowContributorRoots;
    }

    void filtersChanged() {
        this.notifyListeners();
    }

    ServiceModelFilter.ServiceViewFilter getFilter() {
        return this.myFilter;
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent) {
        if (parent == null) {
            ServiceViewModel.$$$reportNull$$$0(3);
        }
        List<? extends ServiceModel.ServiceViewItem> list2 = this.processGroups(this.myModelFilter.filter(parent.getChildren(), this.myFilter));
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    protected ServiceModel.ServiceViewItem findItem(@NotNull ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceViewItem updatedItem;
        if (item == null) {
            ServiceViewModel.$$$reportNull$$$0(5);
        }
        if ((updatedItem = ServiceViewModel.findItem(item, this.myModel.getRoots())) != null) {
            return updatedItem;
        }
        return this.myModel.findItem(item.getValue(), item.getRootContributor().getClass());
    }

    void addModelListener(@NotNull ServiceViewModelListener listener2) {
        if (listener2 == null) {
            ServiceViewModel.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener2);
    }

    void removeModelListener(@NotNull ServiceViewModelListener listener2) {
        if (listener2 == null) {
            ServiceViewModel.$$$reportNull$$$0(7);
        }
        this.myListeners.remove(listener2);
    }

    boolean isGroupByServiceGroups() {
        return this.myShowGroups;
    }

    void setGroupByServiceGroups(boolean value) {
        if (this.myShowGroups != value) {
            this.myShowGroups = value;
            this.notifyListeners();
        }
    }

    boolean isGroupByContributor() {
        return this.myShowContributorRoots;
    }

    void setGroupByContributor(boolean value) {
        if (this.myShowContributorRoots != value) {
            this.myShowContributorRoots = value;
            this.notifyListeners();
        }
    }

    protected void notifyListeners() {
        for (ServiceViewModelListener listener2 : this.myListeners) {
            listener2.rootsChanged();
        }
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myModel.getInvoker();
        if (invoker == null) {
            ServiceViewModel.$$$reportNull$$$0(8);
        }
        return invoker;
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> processGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(9);
        }
        if (this.myShowGroups) {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.filterEmptyGroups(items);
            if (list2 == null) {
                ServiceViewModel.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List list3 = items.stream().flatMap(item -> item instanceof ServiceModel.ServiceGroupNode ? this.getChildren((ServiceModel.ServiceViewItem)item).stream() : Stream.of(item)).collect(Collectors.toList());
        if (list3 == null) {
            ServiceViewModel.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> filterEmptyGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.filter(items, item -> !(item instanceof ServiceModel.ServiceGroupNode) || !this.filterEmptyGroups(this.getChildren((ServiceModel.ServiceViewItem)item)).isEmpty());
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(13);
        }
        return list2;
    }

    static ServiceViewModel createModel(@NotNull List<ServiceModel.ServiceViewItem> items, @Nullable ServiceViewContributor contributor, @NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
        if (items == null) {
            ServiceViewModel.$$$reportNull$$$0(14);
        }
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(15);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(16);
        }
        if (contributor != null) {
            ServiceModel.ServiceViewItem contributorRoot = null;
            for (ServiceModel.ServiceViewItem serviceViewItem : model2.getRoots()) {
                if (contributor != serviceViewItem.getContributor()) continue;
                contributorRoot = serviceViewItem;
                break;
            }
            if (contributorRoot != null && contributorRoot.getChildren().equals(items)) {
                return new ContributorModel(model2, modelFilter, contributor, parentFilter);
            }
        }
        if (items.size() == 1) {
            AtomicReference<ServiceModel.ServiceViewItem> ref;
            ServiceModel.ServiceViewItem item = items.get(0);
            if (item instanceof ServiceModel.ContributorNode) {
                return new ContributorModel(model2, modelFilter, item.getContributor(), parentFilter);
            }
            if (item instanceof ServiceModel.ServiceGroupNode) {
                ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)item);
                return new GroupModel(model2, modelFilter, ref, parentFilter);
            }
            ref = new AtomicReference<ServiceModel.ServiceViewItem>(item);
            return new SingeServiceModel(model2, modelFilter, ref, parentFilter);
        }
        return new ServiceListModel(model2, modelFilter, items, parentFilter);
    }

    @Nullable
    static ServiceViewModel loadModel(@NotNull ServiceViewState viewState, @NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter, @NotNull Map<String, ServiceViewContributor> contributors) {
        if (viewState == null) {
            ServiceViewModel.$$$reportNull$$$0(17);
        }
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(18);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(19);
        }
        if (contributors == null) {
            ServiceViewModel.$$$reportNull$$$0(20);
        }
        if (viewState.viewType.equals("contributor")) {
            ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
            ServiceViewContributor contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
            return contributor == null ? null : new ContributorModel(model2, modelFilter, contributor, parentFilter);
        }
        if (viewState.viewType.equals("group")) {
            ServiceViewContributor contributor;
            ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
            ServiceViewContributor serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
            if (contributor == null) {
                return null;
            }
            ServiceModel.ServiceViewItem groupItem = model2.findItemById(serviceState.path, contributor);
            if (groupItem instanceof ServiceModel.ServiceGroupNode) {
                AtomicReference<ServiceModel.ServiceGroupNode> ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)groupItem);
                return new GroupModel(model2, modelFilter, ref, parentFilter);
            }
        } else if (viewState.viewType.equals("service")) {
            ServiceViewContributor contributor;
            ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
            ServiceViewContributor serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
            if (contributor == null) {
                return null;
            }
            ServiceModel.ServiceViewItem serviceItem = model2.findItemById(serviceState.path, contributor);
            if (serviceItem != null) {
                AtomicReference<ServiceModel.ServiceViewItem> ref = new AtomicReference<ServiceModel.ServiceViewItem>(serviceItem);
                return new SingeServiceModel(model2, modelFilter, ref, parentFilter);
            }
        } else if (viewState.viewType.equals("services")) {
            ArrayList<ServiceModel.ServiceViewItem> items = new ArrayList<ServiceModel.ServiceViewItem>();
            for (ServiceViewState.ServiceState serviceState : viewState.roots) {
                ServiceViewContributor contributor = contributors.get(serviceState.contributor);
                if (contributor == null) continue;
                ContainerUtil.addIfNotNull(items, (Object)model2.findItemById(serviceState.path, contributor));
            }
            if (!items.isEmpty()) {
                return new ServiceListModel(model2, modelFilter, items, parentFilter);
            }
        }
        return null;
    }

    @Nullable
    protected static ServiceModel.ServiceViewItem findItem(ServiceModel.ServiceViewItem viewItem, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        return ServiceViewModel.findItem(ServiceViewModel.getPath(viewItem), modelItems);
    }

    @Nullable
    private static ServiceModel.ServiceViewItem findItem(Deque<ServiceModel.ServiceViewItem> path, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        ServiceModel.ServiceViewItem node = path.removeFirst();
        for (ServiceModel.ServiceViewItem serviceViewItem : modelItems) {
            if (!serviceViewItem.equals(node)) continue;
            if (path.isEmpty()) {
                return serviceViewItem;
            }
            return ServiceViewModel.findItem(path, serviceViewItem.getChildren());
        }
        return null;
    }

    protected static Deque<ServiceModel.ServiceViewItem> getPath(ServiceModel.ServiceViewItem item) {
        LinkedList<ServiceModel.ServiceViewItem> path = new LinkedList<ServiceModel.ServiceViewItem>();
        do {
            path.addFirst(item);
        } while ((item = item.getParent()) != null);
        return path;
    }

    @Nullable
    private static List<String> getIdPath(@Nullable ServiceModel.ServiceViewItem item) {
        ArrayList<String> path = new ArrayList<String>();
        while (item != null) {
            String id = item.getViewDescriptor().getId();
            if (id == null) {
                return null;
            }
            path.add(id);
            item = item.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    @Nullable
    private static ServiceViewState.ServiceState getState(@Nullable ServiceModel.ServiceViewItem item) {
        if (item == null) {
            return null;
        }
        List<String> path = ServiceViewModel.getIdPath(item);
        if (path == null) {
            return null;
        }
        ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
        serviceState.contributor = item.getRootContributor().getClass().getName();
        serviceState.path = path;
        return serviceState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFilter";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewState";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processGroups";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findItem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ServiceListModel
    extends ServiceViewModel {
        private static final String TYPE = "services";
        private final List<ServiceModel.ServiceViewItem> myRoots;

        ServiceListModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull List<ServiceModel.ServiceViewItem> roots, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                ServiceListModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ServiceListModel.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                ServiceListModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return roots.contains(item);
                }
            });
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(this.myRoots, this.getFilter());
            if (list2 == null) {
                ServiceListModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        void eventProcessed(ServiceEventListener.ServiceEvent e) {
            boolean update2 = false;
            ArrayList<ServiceModel.ServiceViewItem> toRemove2 = new ArrayList<ServiceModel.ServiceViewItem>();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                ServiceModel.ServiceViewItem node = this.myRoots.get(i);
                if (!e.contributorClass.isInstance(node.getRootContributor())) continue;
                ServiceModel.ServiceViewItem updatedNode = this.findItem(node);
                if (updatedNode != null) {
                    this.myRoots.remove(i);
                    this.myRoots.add(i, updatedNode);
                } else {
                    toRemove2.add(node);
                }
                update2 = true;
            }
            this.myRoots.removeAll(toRemove2);
            if (update2) {
                this.notifyListeners();
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            for (ServiceModel.ServiceViewItem root : this.myRoots) {
                ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(root));
            }
        }

        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$ServiceListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$ServiceListModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class SingeServiceModel
    extends ServiceViewModel {
        private static final String TYPE = "service";
        private final AtomicReference<ServiceModel.ServiceViewItem> myServiceRef;

        SingeServiceModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceViewItem> serviceRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                SingeServiceModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                SingeServiceModel.$$$reportNull$$$0(1);
            }
            if (serviceRef == null) {
                SingeServiceModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return item.equals(serviceRef.get());
                }
            });
            this.myServiceRef = serviceRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            List<Object> list2 = service == null ? Collections.emptyList() : Collections.singletonList(service);
            if (list2 == null) {
                SingeServiceModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            if (service == null || !e.contributorClass.isInstance(service.getRootContributor())) {
                return;
            }
            this.myServiceRef.set(this.findItem(service));
            this.notifyListeners();
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myServiceRef.get()));
        }

        ServiceModel.ServiceViewItem getService() {
            return this.myServiceRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$SingeServiceModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$SingeServiceModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class GroupModel
    extends ServiceViewModel {
        private static final String TYPE = "group";
        private final AtomicReference<ServiceModel.ServiceGroupNode> myGroupRef;

        GroupModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceGroupNode> groupRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                GroupModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                GroupModel.$$$reportNull$$$0(1);
            }
            if (groupRef == null) {
                GroupModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    ServiceModel.ServiceGroupNode group = (ServiceModel.ServiceGroupNode)groupRef.get();
                    ServiceModel.ServiceViewItem parent = item.getParent();
                    return parent != null && group != null && ServiceViewModel.getPath(parent).equals(ServiceViewModel.getPath(group));
                }
            });
            this.myGroupRef = groupRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            List<Object> list2 = group == null ? Collections.emptyList() : this.getChildren(group);
            if (list2 == null) {
                GroupModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            if (group == null || !e.contributorClass.isInstance(group.getRootContributor())) {
                return;
            }
            this.myGroupRef.set((ServiceModel.ServiceGroupNode)GroupModel.findItem(group, this.myModel.getRoots()));
            this.notifyListeners();
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myGroupRef.get()));
        }

        ServiceModel.ServiceGroupNode getGroup() {
            return this.myGroupRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$GroupModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$GroupModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ContributorModel
    extends ServiceViewModel {
        private static final String TYPE = "contributor";
        private final ServiceViewContributor myContributor;

        ContributorModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull ServiceViewContributor contributor, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                ContributorModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ContributorModel.$$$reportNull$$$0(1);
            }
            if (contributor == null) {
                ContributorModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributor.equals(item.getContributor());
                }
            });
            this.myContributor = contributor;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), (Condition)this.getFilter()), this.getFilter());
            if (list2 == null) {
                ContributorModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        void eventProcessed(ServiceEventListener.ServiceEvent e) {
            if (e.contributorClass.isInstance(this.myContributor)) {
                this.notifyListeners();
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
            serviceState.contributor = this.myContributor.getClass().getName();
            viewState.roots = ContainerUtil.newSmartList((Object)serviceState);
        }

        ServiceViewContributor getContributor() {
            return this.myContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TYPE;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$ContributorModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$ContributorModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AllServicesModel
    extends ServiceViewModel {
        AllServicesModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter) {
            if (model2 == null) {
                AllServicesModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                AllServicesModel.$$$reportNull$$$0(1);
            }
            super(model2, modelFilter, null);
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(this.myModel.getRoots(), null);
            if (list2 == null) {
                AllServicesModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        void eventProcessed(ServiceEventListener.ServiceEvent e) {
            this.notifyListeners();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$AllServicesModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$AllServicesModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface ServiceViewModelListener {
        public void rootsChanged();
    }
}

