/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.sorting.RankingSupport;
import com.intellij.completion.tracker.LookupElementPositionTracker;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.stats.completion.CompletionEventLogger;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionLoggerImplKt;
import com.intellij.stats.completion.CompletionUtil;
import com.intellij.stats.completion.ElementPositionHistory;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.LookupState;
import com.intellij.stats.completion.LookupStateManager;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.CustomMessageEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.events.LookupStateLogData;
import com.intellij.stats.completion.events.PerformanceEvent;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import com.intellij.stats.personalization.UserFactorsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%0$*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/stats/completion/CompletionFileLogger;", "Lcom/intellij/stats/completion/CompletionLogger;", "installationUID", "", "completionUID", "eventLogger", "Lcom/intellij/stats/completion/CompletionEventLogger;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/stats/completion/CompletionEventLogger;)V", "stateManager", "Lcom/intellij/stats/completion/LookupStateManager;", "afterBackspacePressed", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "timestamp", "", "afterCharTyped", "c", "", "completionCancelled", "completionStarted", "isExperimentPerformed", "", "experimentVersion", "", "mlTimeContribution", "customMessage", "message", "downPressed", "itemSelectedByTyping", "itemSelectedCompletionFinished", "performanceMessage", "description", "value", "upPressed", "itemsHistory", "", "Lcom/intellij/stats/completion/ElementPositionHistory;", "intellij.statsCollector"})
public final class CompletionFileLogger
extends CompletionLogger {
    private final LookupStateManager stateManager;
    private final String installationUID;
    private final String completionUID;
    private final CompletionEventLogger eventLogger;

    @Override
    public void completionStarted(@NotNull LookupImpl lookup, boolean isExperimentPerformed, int experimentVersion, long timestamp, long mlTimeContribution) {
        Map map;
        Object mlRankingVersion;
        Object object;
        String pluginVersion;
        String string;
        String ideVersion;
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        Language language = LookupExtensionsKt.language(lookup);
        String string2 = PluginManager.BUILD_NUMBER;
        if (string2 == null) {
            string2 = ideVersion = "ideVersion";
        }
        if ((string = CompletionLoggerImplKt.access$calcPluginVersion()) == null) {
            string = pluginVersion = "pluginVersion";
        }
        if ((object = RankingSupport.INSTANCE.getRanker(language)) == null || (object = ((RankingSupport.LanguageRanker)object).version()) == null) {
            object = mlRankingVersion = "NONE";
        }
        if ((map = (Map)lookup.getUserData(UserFactorsManager.Companion.getUSER_FACTORS_KEY())) == null) {
            map = MapsKt.emptyMap();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"lookup.getUserData(UserF\u2026ACTORS_KEY) ?: emptyMap()");
        Map userFactors = map;
        Language language2 = language;
        String string3 = language2 != null ? language2.getDisplayName() : null;
        int n = LookupExtensionsKt.prefixLength(lookup);
        Long l = (Long)lookup.getUserData(CompletionUtil.INSTANCE.getCOMPLETION_STARTING_TIME_KEY());
        if (l == null) {
            l = timestamp;
        }
        CompletionStartedEvent event = new CompletionStartedEvent(ideVersion, pluginVersion, (String)mlRankingVersion, this.installationUID, this.completionUID, string3, isExperimentPerformed, experimentVersion, state, userFactors, n, l.longValue());
        Long shownTimestamp = CompletionUtil.INSTANCE.getShownTimestamp(lookup);
        if (shownTimestamp != null) {
            event.lookupShownTime = shownTimestamp;
        }
        event.mlTimeContribution = mlTimeContribution;
        Editor editor = lookup.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"lookup.editor");
        event.isOneLineMode = editor.isOneLineMode();
        CompletionParameters completionParameters = CompletionUtil.INSTANCE.getCurrentCompletionParameters();
        event.isAutoPopup = completionParameters != null ? Boolean.valueOf(completionParameters.isAutoPopup()) : null;
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void customMessage(@NotNull String message, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CustomMessageEvent event = new CustomMessageEvent(this.installationUID, this.completionUID, message, timestamp);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void performanceMessage(@NotNull String description, long value, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.eventLogger.log((LogEvent)new PerformanceEvent(this.installationUID, this.completionUID, description, value, timestamp));
    }

    @Override
    public void afterCharTyped(char c, @NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        TypeEvent event = new TypeEvent(this.installationUID, this.completionUID, state, LookupExtensionsKt.prefixLength(lookup), timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void downPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        DownPressedEvent event = new DownPressedEvent(this.installationUID, this.completionUID, state, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void upPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        UpPressedEvent event = new UpPressedEvent(this.installationUID, this.completionUID, state, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void completionCancelled(long timestamp) {
        CompletionCancelledEvent event = new CompletionCancelledEvent(this.installationUID, this.completionUID, timestamp);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void itemSelectedByTyping(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        Map<Integer, ElementPositionHistory> history2 = this.itemsHistory(lookup);
        TypedSelectEvent event = new TypedSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId$p(state), history2, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void itemSelectedCompletionFinished(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        Map<Integer, ElementPositionHistory> history2 = this.itemsHistory(lookup);
        ExplicitSelectEvent event = new ExplicitSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId$p(state), history2, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, ElementPositionHistory> itemsHistory(@NotNull LookupImpl $this$itemsHistory) {
        void $this$mapTo$iv$iv;
        LookupElementPositionTracker positionTracker = LookupElementPositionTracker.Companion.getInstance();
        List list = $this$itemsHistory.getItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"items");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Integer n = this.stateManager.getElementId((LookupElement)v1);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            Pair pair = TuplesKt.to((Object)n, (Object)new ElementPositionHistory(positionTracker.positionsHistory($this$itemsHistory, (LookupElement)it)));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void afterBackspacePressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        BackspaceEvent event = new BackspaceEvent(this.installationUID, this.completionUID, state, LookupExtensionsKt.prefixLength(lookup), timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    public CompletionFileLogger(@NotNull String installationUID, @NotNull String completionUID, @NotNull CompletionEventLogger eventLogger) {
        Intrinsics.checkParameterIsNotNull((Object)installationUID, (String)"installationUID");
        Intrinsics.checkParameterIsNotNull((Object)completionUID, (String)"completionUID");
        Intrinsics.checkParameterIsNotNull((Object)eventLogger, (String)"eventLogger");
        this.installationUID = installationUID;
        this.completionUID = completionUID;
        this.eventLogger = eventLogger;
        this.stateManager = new LookupStateManager();
    }
}

