/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeSmellDetectorImpl
extends CodeSmellDetector {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.CodeSmellDetectorImpl");

    public CodeSmellDetectorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void showCodeSmellErrors(@NotNull List<CodeSmellInfo> smellList) {
        if (smellList == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(0);
        }
        Collections.sort(smellList, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (smellList.isEmpty()) {
                return;
            }
            VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(this.myProject);
            AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)AbstractVcsHelper.getInstance((Project)this.myProject);
            helper.openMessagesView(errorTreeView, VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]));
            FileDocumentManager fileManager = FileDocumentManager.getInstance();
            for (CodeSmellInfo smellInfo : smellList) {
                VirtualFile file = fileManager.getFile(smellInfo.getDocument());
                OpenFileDescriptor navigatable = new OpenFileDescriptor(this.myProject, file, smellInfo.getStartLine(), smellInfo.getStartColumn());
                String exportPrefix = NewErrorTreeViewPanel.createExportPrefix((int)(smellInfo.getStartLine() + 1));
                String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix((int)(smellInfo.getStartLine() + 1), (int)(smellInfo.getStartColumn() + 1));
                if (smellInfo.getSeverity() == HighlightSeverity.ERROR) {
                    errorTreeView.addMessage(4, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                    continue;
                }
                errorTreeView.addMessage(5, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
            }
        });
    }

    @Override
    @NotNull
    public List<CodeSmellInfo> findCodeSmells(final @NotNull List<? extends VirtualFile> filesToCheck) throws ProcessCanceledException {
        if (filesToCheck == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(1);
        }
        final ArrayList<CodeSmellInfo> result2 = new ArrayList<CodeSmellInfo>();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                throw new RuntimeException("Must not run under write action");
            }
            final Ref exception = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        result2.addAll(CodeSmellDetectorImpl.this.findCodeSmells(filesToCheck, progress));
                    }
                    catch (ProcessCanceledException e) {
                        LOG.info("Code analysis canceled", (Throwable)e);
                        exception.set((Object)e);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        exception.set((Object)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl$1", "run"));
                }
            });
            if (!exception.isNull()) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)((Throwable)exception.get()));
            }
        } else if (ProgressManager.getInstance().hasProgressIndicator()) {
            result2.addAll(this.findCodeSmells(filesToCheck, ProgressManager.getInstance().getProgressIndicator()));
        } else {
            throw new RuntimeException("Must run from Event Dispatch Thread or with a progress indicator");
        }
        ArrayList<CodeSmellInfo> arrayList = result2;
        if (arrayList == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private List<CodeSmellInfo> findCodeSmells(@NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress) {
        if (files2 == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(3);
        }
        if (progress == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(4);
        }
        ArrayList<CodeSmellInfo> result2 = new ArrayList<CodeSmellInfo>();
        for (int i = 0; i < files2.size(); ++i) {
            if (progress.isCanceled()) {
                throw new ProcessCanceledException();
            }
            VirtualFile file = files2.get(i);
            progress.setText(VcsBundle.message((String)"searching.for.code.smells.processing.file.progress.text", (Object[])new Object[]{file.getPresentableUrl()}));
            progress.setFraction((double)i / (double)files2.size());
            result2.addAll(this.findCodeSmells(file, progress));
        }
        ArrayList<CodeSmellInfo> arrayList = result2;
        if (arrayList == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private List<CodeSmellInfo> findCodeSmells(@NotNull VirtualFile file, @NotNull ProgressIndicator progress) {
        if (file == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(7);
        }
        DaemonProgressIndicator daemonIndicator = new DaemonProgressIndicator();
        ((ProgressIndicatorEx)progress).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase((ProgressIndicator)daemonIndicator){
            final /* synthetic */ ProgressIndicator val$daemonIndicator;
            {
                this.val$daemonIndicator = progressIndicator;
            }

            public void cancel() {
                super.cancel();
                this.val$daemonIndicator.cancel();
            }
        });
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
        if (psiFile == null || document == null) {
            List<CodeSmellInfo> list = Collections.emptyList();
            if (list == null) {
                CodeSmellDetectorImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<CodeSmellInfo> result2 = Collections.synchronizedList(new ArrayList());
        ProgressManager.getInstance().runProcess(() -> this.lambda$findCodeSmells$4((ProgressIndicator)daemonIndicator, psiFile, document, result2), (ProgressIndicator)daemonIndicator);
        List<CodeSmellInfo> list = result2;
        if (list == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<HighlightInfo> runMainPasses(ProgressIndicator daemonIndicator, PsiFile psiFile, Document document) {
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        ProcessCanceledException exception = null;
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        int retries = 100;
        for (int i = 0; i < retries; ++i) {
            List list;
            int oldDelay = settings.getAutoReparseDelay();
            try {
                settings.setAutoReparseDelay(0);
                List list2 = (List)dumbService.runReadActionInSmartMode(() -> codeAnalyzer.runMainPasses(psiFile, document, daemonIndicator));
                list = list2;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getClass() != Throwable.class) {
                    throw e;
                }
                exception = e;
                continue;
            }
            finally {
                settings.setAutoReparseDelay(oldDelay);
            }
            if (list == null) {
                CodeSmellDetectorImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        throw exception;
    }

    private void convertErrorsAndWarnings(@NotNull Collection<? extends HighlightInfo> highlights, @NotNull List<? super CodeSmellInfo> result2, @NotNull Document document) {
        if (highlights == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(12);
        }
        if (document == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(13);
        }
        for (HighlightInfo highlightInfo : highlights) {
            HighlightSeverity severity = highlightInfo.getSeverity();
            if (SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).compare(severity, HighlightSeverity.WARNING) < 0) continue;
            result2.add(new CodeSmellInfo(document, CodeSmellDetectorImpl.getDescription(highlightInfo), new TextRange(highlightInfo.startOffset, highlightInfo.endOffset), severity));
        }
    }

    private static String getDescription(@NotNull HighlightInfo highlightInfo) {
        if (highlightInfo == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(14);
        }
        String description = highlightInfo.getDescription();
        HighlightInfoType type = highlightInfo.type;
        if (type instanceof HighlightInfoType.HighlightInfoTypeSeverityByKey) {
            HighlightDisplayKey severityKey = ((HighlightInfoType.HighlightInfoTypeSeverityByKey)type).getSeverityKey();
            String id = severityKey.getID();
            return "[" + id + "] " + description;
        }
        return description;
    }

    private /* synthetic */ void lambda$findCodeSmells$4(ProgressIndicator daemonIndicator, PsiFile psiFile, Document document, List result2) {
        List<HighlightInfo> infos = this.runMainPasses(daemonIndicator, psiFile, document);
        this.convertErrorsAndWarnings(infos, result2, document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smellList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheck";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeSmells";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCodeSmellErrors";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCodeSmells";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertErrorsAndWarnings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

