/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtilRt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil
extends ExceptionUtilRt {
    private ExceptionUtil() {
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e.getCause() == null) {
                Throwable throwable = e;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e = e.getCause();
        }
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        return ExceptionUtilRt.findCause(e, klass);
    }

    public static boolean causedBy(Throwable e, Class klass) {
        return ExceptionUtilRt.causedBy(e, klass);
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        String string = ExceptionUtil.getThrowableText(new Throwable());
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable t) {
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.getBuffer().toString();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        if (stackFrameSkipPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        String string = ExceptionUtilRt.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getUserStackTrace(@NotNull Throwable aThrowable, Logger logger) {
        String result;
        if (aThrowable == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if ((result = ExceptionUtil.getThrowableText(aThrowable, "com.intellij.")).contains("\n\tat") || aThrowable.getStackTrace().length <= 0) {
            String string = result.trim() + " (no stack trace)";
            if (string == null) {
                ExceptionUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        logger.error(aThrowable);
        String string = result;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e.getCause() != null && (result == null || result.contains(exceptionPattern) || result.contains(errorPattern))) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, exceptionPattern);
            result = ExceptionUtil.extractMessage(result, errorPattern);
        }
        return result;
    }

    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        if (errorPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) {
        ExceptionUtilRt.rethrowUnchecked(t);
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        ExceptionUtilRt.rethrowAll(t);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    @NotNull
    public static String getNonEmptyMessage(@NotNull Throwable t, @NotNull String defaultMessage) {
        String message;
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (defaultMessage == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        String string = !StringUtil.isEmptyOrSpaces(message = t.getMessage()) ? message : defaultMessage;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStackTrace";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

