/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import git4idea.actions.GitCheckoutAction;
import git4idea.actions.GitSingleCommitActionGroup;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lgit4idea/actions/GitCheckoutActionGroup;", "Lgit4idea/actions/GitSingleCommitActionGroup;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/intellij/vcs/log/VcsLog;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/CommitId;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/VcsLog;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/CommitId;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getRefNames", "", "", "intellij.vcs.git"})
public final class GitCheckoutActionGroup
extends GitSingleCommitActionGroup {
    @Override
    @NotNull
    public AnAction[] getChildren(@NotNull AnActionEvent e, @NotNull Project project, @NotNull VcsLog log, @NotNull GitRepository repository, @NotNull CommitId commit2) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commit2, (String)"commit");
        List<String> refNames = this.getRefNames(e, log, repository);
        ArrayList<GitCheckoutAction> actions = new ArrayList<GitCheckoutAction>();
        for (String refName : refNames) {
            actions.add(new GitCheckoutAction(project, repository, refName, refName));
        }
        boolean hasMultipleActions = !actions.isEmpty();
        String checkoutRevisionText = (hasMultipleActions ? "" : "Checkout ") + "Revision '" + commit2.getHash().toShortString() + '\'';
        String string = commit2.getHash().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.hash.asString()");
        actions.add(new GitCheckoutAction(project, repository, string, checkoutRevisionText));
        DefaultActionGroup mainGroup = new DefaultActionGroup("Checkout", (List)actions);
        mainGroup.setPopup(hasMultipleActions);
        return new AnAction[]{(AnAction)mainGroup};
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRefNames(AnActionEvent e, VcsLog log, GitRepository repository) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$filterTo$iv;
        List list = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"e.getData(VcsLogDataKeys\u2026_LOG_REFS) ?: emptyList()");
        List refs = list;
        Iterable iterable = refs;
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv2 : $this$filterTo$iv) {
            VcsRef it = (VcsRef)element$iv2;
            boolean bl2 = false;
            VcsRef vcsRef = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsRef, (String)"it");
            if (!Intrinsics.areEqual((Object)vcsRef.getType(), (Object)GitRefManager.LOCAL_BRANCH)) continue;
            destination$iv.add(element$iv2);
        }
        List localBranches = (List)destination$iv;
        VcsLogProvider provider = (VcsLogProvider)log.getLogProviders().get(repository.getRoot());
        if (provider != null) {
            VcsLogRefManager vcsLogRefManager = provider.getReferenceManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogRefManager, (String)"provider.referenceManager");
            ContainerUtil.sort((List)localBranches, (Comparator)vcsLogRefManager.getLabelsOrderComparator());
        }
        Iterable $this$map$iv = localBranches;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsRef vcsRef = (VcsRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            String string = v3.getName();
            collection.add(string);
        }
        List refNames = (List)destination$iv$iv;
        String string = repository.getCurrentBranchName();
        if (string == null) {
            return refNames;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repository.currentBranchName ?: return refNames");
        String currentBranchName = string;
        return CollectionsKt.minus((Iterable)refNames, (Object)currentBranchName);
    }

    public GitCheckoutActionGroup() {
        super("Checkout", false);
    }
}

